/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.spirit;

import com.klikli_dev.occultism.api.common.data.WorkAreaSize;
import com.klikli_dev.occultism.api.common.item.IHandleItemMode;
import com.klikli_dev.occultism.client.gui.GuiHelper;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.common.item.spirit.calling.ItemMode;
import com.klikli_dev.occultism.common.item.spirit.calling.ItemModes;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.util.EntityUtil;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;

public class BookOfCallingItem
extends Item
implements IHandleItemMode {
    public static Map<UUID, Long> spiritDeathRegister = new HashMap<UUID, Long>();
    public String translationKeyBase;
    public Predicate<SpiritEntity> targetSpirit;

    public BookOfCallingItem(Item.Properties properties, String translationKeyBase, Predicate<SpiritEntity> targetSpirit) {
        super(properties);
        this.translationKeyBase = translationKeyBase;
        this.targetSpirit = targetSpirit;
    }

    public String getTranslationKeyBase() {
        return this.translationKeyBase;
    }

    public List<ItemMode> getItemModes() {
        return new ArrayList<ItemMode>();
    }

    @Override
    public int getItemMode(ItemStack stack) {
        return ItemNBTUtil.getItemMode(stack);
    }

    @Override
    public void setItemMode(ItemStack stack, int mode) {
        ItemNBTUtil.setItemMode(stack, mode);
    }

    public ItemMode nextItemMode(ItemStack stack) {
        int mode = this.getItemMode(stack);
        mode = (mode + 1) % this.getItemModes().size();
        this.setItemMode(stack, mode);
        return this.getCurrentItemMode(stack);
    }

    public int modeValue(ItemMode mode) {
        return this.getItemModes().indexOf(mode);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.getItemInHand(pUsedHand);
        if (!pPlayer.isShiftKeyDown() && pLevel.isClientSide) {
            ItemMode curr = this.getCurrentItemMode(itemStack);
            WorkAreaSize workAreaSize = ItemNBTUtil.getWorkAreaSize(itemStack);
            GuiHelper.openBookOfCallingGui(curr, workAreaSize);
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        Level world = context.getLevel();
        Direction facing = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        CompoundTag entityData = ItemNBTUtil.getSpiritEntityData(itemStack);
        if (entityData != null) {
            if (!world.isClientSide) {
                EntityType<?> type = EntityUtil.entityTypeFromNbt(entityData);
                facing = facing == null ? Direction.UP : facing;
                BlockPos spawnPos = pos.immutable();
                if (!world.getBlockState(spawnPos).getCollisionShape((BlockGetter)world, spawnPos).isEmpty()) {
                    spawnPos = spawnPos.relative(facing);
                }
                entityData.remove("Pos");
                CompoundTag wrapper = new CompoundTag();
                wrapper.put("EntityTag", (Tag)entityData);
                SpiritEntity entity = (SpiritEntity)type.create(world);
                entity.load(entityData);
                entity.absMoveTo((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5, 0.0f, 0.0f);
                world.addFreshEntity((Entity)entity);
                ItemNBTUtil.updateItemNBTFromEntity(itemStack, entity);
                world.addFreshEntity((Entity)entity);
                itemStack.remove(OccultismDataComponents.SPIRIT_ENTITY_DATA);
                itemStack.set(DataComponents.RARITY, (Object)Rarity.COMMON);
                player.inventoryMenu.broadcastChanges();
            }
        } else {
            if (player.isShiftKeyDown()) {
                return this.handleItemMode(player, world, pos, itemStack, facing);
            }
            if (world.isClientSide) {
                ItemMode curr = this.getCurrentItemMode(itemStack);
                WorkAreaSize workAreaSize = ItemNBTUtil.getWorkAreaSize(itemStack);
                GuiHelper.openBookOfCallingGui(curr, workAreaSize);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (!(target instanceof SpiritEntity)) {
            return InteractionResult.PASS;
        }
        SpiritEntity targetSpirit = (SpiritEntity)target;
        if (target.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (!targetSpirit.getUUID().equals(ItemNBTUtil.getSpiritEntityUUID(stack))) {
            if (player.isShiftKeyDown()) {
                if (this.targetSpirit.test(targetSpirit)) {
                    ItemNBTUtil.setSpiritEntityUUID(stack, targetSpirit.getUUID());
                    stack.set(DataComponents.RARITY, (Object)Rarity.RARE);
                    ItemNBTUtil.setBoundSpiritName(stack, targetSpirit.getName().getString());
                    player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_target_linked"), true);
                    player.swing(hand);
                    player.setItemInHand(hand, stack);
                    player.inventoryMenu.broadcastChanges();
                    return InteractionResult.SUCCESS;
                }
                if (this.getCurrentItemMode(stack) == ItemModes.SET_DEPOSIT) {
                    if (targetSpirit.getCapability(Capabilities.ItemHandler.ENTITY) != null) {
                        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
                        if (boundSpiritId != null) {
                            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(target.level().getServer(), boundSpiritId).map(e -> (SpiritEntity)e);
                            if (boundSpirit.isPresent()) {
                                boundSpirit.get().setDepositEntityUUID(targetSpirit.getUUID());
                                ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                                ItemNBTUtil.setDepositEntityName(stack, target.getName().getString());
                                player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_set_deposit_entity", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().getName().getString()), TextUtil.formatDemonName(targetSpirit.getName().getString())}), true);
                                player.swing(hand);
                                player.setItemInHand(hand, stack);
                                player.inventoryMenu.broadcastChanges();
                                return InteractionResult.SUCCESS;
                            }
                            player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
                            return InteractionResult.FAIL;
                        }
                        player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_target_cannot_link"), true);
                        return InteractionResult.FAIL;
                    }
                    player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_target_entity_no_inventory"), true);
                    return InteractionResult.FAIL;
                }
                player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_target_cannot_link"), true);
                return InteractionResult.FAIL;
            }
            player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_target_uuid_no_match"), true);
            return InteractionResult.FAIL;
        }
        CompoundTag entityData = new CompoundTag();
        String id = targetSpirit.getEncodeId();
        if (id != null) {
            entityData.putString("id", id);
        }
        entityData = targetSpirit.saveWithoutId(entityData);
        ItemNBTUtil.setSpiritEntityData(stack, entityData);
        ItemNBTUtil.setSpiritEntityUUID(stack, targetSpirit.getUUID());
        ItemNBTUtil.setBoundSpiritName(stack, targetSpirit.getName().getString());
        player.swing(hand);
        player.setItemInHand(hand, stack);
        targetSpirit.remove(Entity.RemovalReason.DISCARDED);
        player.inventoryMenu.broadcastChanges();
        return InteractionResult.SUCCESS;
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        Long deathTime;
        UUID spiritID;
        if (worldIn.getGameTime() % 1200L == 0L && (spiritID = ItemNBTUtil.getSpiritEntityUUID(stack)) != null && (deathTime = spiritDeathRegister.get(spiritID)) != null && deathTime < worldIn.getGameTime()) {
            spiritDeathRegister.remove(spiritID);
            stack.set(OccultismDataComponents.SPIRIT_DEAD, (Object)true);
            stack.remove(OccultismDataComponents.SPIRIT_ENTITY_UUID);
        }
        super.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)(this.getTranslationKeyBase() + (ItemNBTUtil.getSpiritDead(pStack) ? ".tooltip_dead" : ".tooltip")), (Object[])new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(pStack))}));
    }

    public boolean isFoil(ItemStack stack) {
        return ItemNBTUtil.getSpiritEntityData(stack) != null;
    }

    public void verifyComponentsAfterLoad(ItemStack pStack) {
        super.verifyComponentsAfterLoad(pStack);
        if (pStack.has(OccultismDataComponents.SPIRIT_ENTITY_UUID)) {
            pStack.set(DataComponents.RARITY, (Object)Rarity.RARE);
        } else {
            pStack.set(DataComponents.RARITY, (Object)Rarity.COMMON);
        }
    }

    public ItemMode getCurrentItemMode(ItemStack stack) {
        int mode = this.getItemMode(stack);
        if (mode < 0 || mode >= this.getItemModes().size()) {
            mode = 0;
            this.setItemMode(stack, mode);
        }
        return this.getItemModes().get(mode);
    }

    public boolean useWorkAreaSize() {
        return true;
    }

    public InteractionResult handleItemMode(Player player, Level world, BlockPos pos, ItemStack stack, Direction facing) {
        ItemMode itemMode = this.getCurrentItemMode(stack);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!world.isClientSide) {
            return itemMode.handle(blockEntity, player, world, pos, stack, facing) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }
}

