/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.spirit.demonicpartner;

import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.common.entity.spirit.demonicpartner.DemonicPartnerLieNextToPartnerGoal;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismTags;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DemonicPartner
extends TamableAnimal {
    private static final EntityDataAccessor<Boolean> IS_LYING = SynchedEntityData.defineId(DemonicPartner.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Long> HEART_TIME = SynchedEntityData.defineId(DemonicPartner.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    protected Optional<RecipeHolder<SmokingRecipe>> lastRecipe = Optional.empty();
    protected static final int HEART_INTERVAL = 12000;
    protected long lastHeartTime;

    protected DemonicPartner(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.createAttributes().add(Attributes.ATTACK_DAMAGE, 9.0);
    }

    protected void dropFromLootTable(DamageSource pDamageSource, boolean pAttackedRecently) {
        super.dropFromLootTable(pDamageSource, pAttackedRecently);
        LivingEntity owner = this.getOwner();
        ItemStack shard = new ItemStack((ItemLike)OccultismItems.SOUL_SHARD_ITEM.get());
        float health = this.getHealth();
        this.setHealth(this.getMaxHealth());
        this.resetFallDistance();
        this.removeAllEffects();
        CompoundTag entityData = new CompoundTag();
        String id = this.getEncodeId();
        if (id != null) {
            entityData.putString("id", id);
        }
        entityData = this.saveWithoutId(entityData);
        shard.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)entityData));
        this.setHealth(health);
        if (owner instanceof Player) {
            Player player = (Player)owner;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)shard);
        } else {
            ItemEntity entityitem = new ItemEntity(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), shard);
            entityitem.setPickUpDelay(5);
            entityitem.setDeltaMovement(entityitem.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            this.level().addFreshEntity((Entity)entityitem);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_LYING, (Object)false).define(HEART_TIME, (Object)0L);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(HEART_TIME, (Object)compound.getLong("heartLastTime"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putLong("heartLastTime", this.getHeartTime());
    }

    private void setHeartTime(long b) {
        this.entityData.set(HEART_TIME, (Object)b);
    }

    private long getHeartTime() {
        return (Long)this.entityData.get(HEART_TIME);
    }

    public boolean isLying() {
        return (Boolean)this.entityData.get(IS_LYING);
    }

    public void setLying(boolean pLying) {
        this.entityData.set(IS_LYING, (Object)pLying);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new DemonicPartnerLieNextToPartnerGoal(this));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.7, true));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean isFood(ItemStack pStack) {
        return pStack.is(OccultismTags.Items.DEMONIC_PARTNER_FOOD);
    }

    public Optional<RecipeHolder<SmokingRecipe>> getRecipe(ItemStack pStack) {
        return this.level().getRecipeManager().getAllRecipesFor(RecipeType.SMOKING).stream().filter(r -> ((SmokingRecipe)r.value()).ingredient.test(pStack)).findFirst();
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
        if (this.level().isClientSide && this.swinging) {
            Vec3 direction = Vec3.directionFromRotation((Vec2)this.getRotationVector()).scale(0.6);
            for (int i = 0; i < 5; ++i) {
                Vec3 pos = this.position().add(direction.x + (double)(this.getRandom().nextFloat() - 0.5f) * 0.7, 1.5 + (double)(this.getRandom().nextFloat() - 0.5f) * 0.7, direction.z + (double)(this.getRandom().nextFloat() - 0.5f) * 0.7);
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, pos.x, pos.y, pos.z, direction.x * 0.25, 0.0, direction.z * 0.25);
            }
        }
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (this.level().isClientSide) {
            boolean willInteract = this.isOwnedBy((LivingEntity)pPlayer) || this.isTame() || itemstack.is(Items.DIAMOND) && !this.isTame();
            return willInteract ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.isTame() && this.isOwnedBy((LivingEntity)pPlayer)) {
            Optional<RecipeHolder<SmokingRecipe>> recipe;
            if (itemstack.is(OccultismItems.CURSED_HONEY.asItem())) {
                long time = this.getHeartTime() + 12000L - this.level().getGameTime();
                if (time < 0L) {
                    this.setHeartTime(this.level().getGameTime());
                    this.lastHeartTime = this.level().getGameTime();
                    itemstack.shrink(1);
                    ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)new ItemStack((ItemLike)OccultismItems.SWEET_HONEY_HEART.asItem()));
                } else {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"dialog.occultism.partner.heart_on_cooldown", (Object[])new Object[]{time}), true);
                }
                return InteractionResult.SUCCESS;
            }
            PotionContents effects = (PotionContents)itemstack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            if (effects.hasEffects()) {
                for (MobEffectInstance instance : effects.getAllEffects()) {
                    if (((MobEffect)instance.getEffect().value()).isInstantenous()) {
                        ((MobEffect)instance.getEffect().value()).applyInstantenousEffect((Entity)this, (Entity)this, (LivingEntity)pPlayer, instance.getAmplifier(), 1.0);
                        continue;
                    }
                    pPlayer.addEffect(new MobEffectInstance(instance.getEffect(), instance.getDuration() * 5, instance.getAmplifier(), instance.isAmbient(), instance.isVisible()));
                }
                if (!pPlayer.isCreative()) {
                    itemstack.shrink(1);
                    ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                }
                return InteractionResult.SUCCESS;
            }
            Optional<RecipeHolder<SmokingRecipe>> optional = this.lastRecipe.isPresent() ? (((SmokingRecipe)this.lastRecipe.get().value()).ingredient.test(itemstack) ? this.lastRecipe : this.getRecipe(itemstack)) : (recipe = this.getRecipe(itemstack));
            if (recipe.isPresent()) {
                this.lastRecipe = recipe;
                ItemStack result = ((SmokingRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)this.level().registryAccess());
                if (pPlayer.isShiftKeyDown()) {
                    ItemStack multiResult = result.copy();
                    multiResult.setCount(result.getCount() * itemstack.getCount());
                    if (!pPlayer.isCreative()) {
                        itemstack.shrink(itemstack.getCount());
                    }
                    ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)multiResult);
                } else {
                    if (!pPlayer.isCreative()) {
                        itemstack.shrink(1);
                    }
                    ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)result);
                }
                for (int i = 0; i < 2; ++i) {
                    Vec3 pos = this.position().add((double)(this.getRandom().nextFloat() - 0.5f) * 0.7, 1.5 + (double)(this.getRandom().nextFloat() - 0.5f) * 0.7, (double)(this.getRandom().nextFloat() - 0.5f) * 0.7);
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.FLAME, pos.x, pos.y, pos.z, 1, 0.0, 0.0, 0.0, 0.0);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                this.heal(itemstack.getFoodProperties((LivingEntity)this).nutrition());
                if (!pPlayer.isCreative()) {
                    itemstack.shrink(1);
                }
                this.gameEvent((Holder)GameEvent.EAT, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.mobInteract(pPlayer, pHand);
            if ((!interactionresult.consumesAction() || this.isBaby()) && itemstack.isEmpty()) {
                this.setOrderedToSit(!this.isOrderedToSit());
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (itemstack.is(Items.DIAMOND)) {
            if (!pPlayer.isCreative()) {
                itemstack.shrink(1);
            }
            if (!EventHooks.onAnimalTame((Animal)this, (Player)pPlayer)) {
                this.tame(pPlayer);
                this.navigation.stop();
                this.setTarget(null);
                this.setOrderedToSit(true);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(pPlayer, pHand);
    }

    public boolean doHurtTarget(Entity pEntity) {
        boolean flag = super.doHurtTarget(pEntity);
        pEntity.setRemainingFireTicks(40);
        this.heal(1.0f);
        return flag;
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        return super.isInvulnerableTo(source) || source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.FLY_INTO_WALL);
    }
}

