/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.capability;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageSyncFamiliarSettings;
import com.klikli_dev.occultism.registry.OccultismDataStorage;
import com.klikli_dev.occultism.registry.OccultismEntities;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class FamiliarSettingsData
implements INBTSerializable<CompoundTag> {
    private static ImmutableList<EntityType<? extends IFamiliar>> familiars = null;
    private final Map<EntityType<?>, Boolean> familiarEnabled = new HashMap();

    public FamiliarSettingsData() {
        for (EntityType<? extends IFamiliar> familiar : FamiliarSettingsData.getFamiliars()) {
            this.familiarEnabled.put(familiar, true);
        }
    }

    public static List<EntityType<? extends IFamiliar>> getFamiliars() {
        if (familiars == null) {
            familiars = ImmutableList.of((Object)((EntityType)OccultismEntities.GREEDY_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.OTHERWORLD_BIRD_TYPE.get()), (Object)((EntityType)OccultismEntities.BAT_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.DEER_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.CTHULHU_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.DEVIL_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.DRAGON_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.BLACKSMITH_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.GUARDIAN_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.HEADLESS_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.CHIMERA_FAMILIAR_TYPE.get()), (Object)((EntityType)OccultismEntities.GOAT_FAMILIAR_TYPE.get()), (Object[])new EntityType[]{(EntityType)OccultismEntities.SHUB_NIGGURATH_FAMILIAR_TYPE.get(), (EntityType)OccultismEntities.BEHOLDER_FAMILIAR_TYPE.get(), (EntityType)OccultismEntities.FAIRY_FAMILIAR_TYPE.get(), (EntityType)OccultismEntities.MUMMY_FAMILIAR_TYPE.get(), (EntityType)OccultismEntities.BEAVER_FAMILIAR_TYPE.get()});
        }
        return familiars;
    }

    public static void syncFor(ServerPlayer player) {
        ((FamiliarSettingsData)player.getData(OccultismDataStorage.FAMILIAR_SETTINGS)).sync(player);
    }

    public void clone(FamiliarSettingsData settings) {
        for (Map.Entry<EntityType<?>, Boolean> entry : settings.familiarEnabled.entrySet()) {
            this.familiarEnabled.put(entry.getKey(), entry.getValue());
        }
    }

    public void setFamiliarEnabled(EntityType<?> familiar, boolean b) {
        this.familiarEnabled.put(familiar, b);
    }

    public boolean isFamiliarEnabled(EntityType<?> familiar) {
        return this.familiarEnabled.get(familiar);
    }

    public void sync(ServerPlayer player) {
        Networking.sendTo(player, new MessageSyncFamiliarSettings(this, player.registryAccess()));
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        for (Map.Entry<EntityType<?>, Boolean> entry : this.familiarEnabled.entrySet()) {
            compound.putBoolean(BuiltInRegistries.ENTITY_TYPE.getKey(entry.getKey()).getPath(), entry.getValue().booleanValue());
        }
        return compound;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        for (EntityType<? extends IFamiliar> familiar : FamiliarSettingsData.getFamiliars()) {
            if (!nbt.contains(BuiltInRegistries.ENTITY_TYPE.getKey(familiar).getPath())) continue;
            this.familiarEnabled.put(familiar, nbt.getBoolean(BuiltInRegistries.ENTITY_TYPE.getKey(familiar).getPath()));
        }
    }
}

