/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.feature.common.mods.minecraft;

import dev.uncandango.alltheleaks.annotation.Issue;
import dev.uncandango.alltheleaks.mixin.core.accessor.PatchedDataComponentMapAccessor;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.fml.loading.LoadingModList;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Issue(modId="minecraft", issueId="Ingredient Deduplication", versionRange="1.21.1", mixins={"main.IngredientMixin", "main.IngredientMixin$IngredientAccessor", "accessor.PatchedDataComponentMapAccessor", "accessor.HolderReferenceAccessor", "main.HolderReferenceMixin", "main.IngredientLockMixin", "main.ItemStackLockMixin"}, config="ingredientDedupe", configActivated=false)
public class IngredientDedupe {
    private static final ObjectOpenCustomHashSet<Ingredient> INGREDIENT_CACHE;
    private static final boolean MODERNFIX_DEDUPLICATION;

    private static boolean strictIsSameItemSameComponents(ItemStack item1, ItemStack item2) {
        DataComponentMap dataComponentMap = item1.getComponents();
        if (dataComponentMap instanceof PatchedDataComponentMapAccessor) {
            PatchedDataComponentMapAccessor accessor1 = (PatchedDataComponentMapAccessor)dataComponentMap;
            dataComponentMap = item2.getComponents();
            if (dataComponentMap instanceof PatchedDataComponentMapAccessor) {
                Reference2ObjectMap<DataComponentType<?>, Optional<?>> bPatch;
                PatchedDataComponentMapAccessor accessor2 = (PatchedDataComponentMapAccessor)dataComponentMap;
                if (!accessor1.atl$getPrototype().equals((Object)accessor2.atl$getPrototype())) {
                    return false;
                }
                Reference2ObjectMap<DataComponentType<?>, Optional<?>> aPatch = accessor1.atl$getPatch();
                if (aPatch != (bPatch = accessor2.atl$getPatch())) {
                    if (aPatch.size() != bPatch.size()) {
                        return false;
                    }
                    for (Reference2ObjectMap.Entry entry : Reference2ObjectMaps.fastIterable(aPatch)) {
                        Optional value = (Optional)bPatch.get(entry.getKey());
                        if (value == null) {
                            return false;
                        }
                        if (value.isPresent() != ((Optional)entry.getValue()).isPresent()) {
                            return false;
                        }
                        if (!value.isPresent() || value.get() == ((Optional)entry.getValue()).get()) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return item1.getComponents() == item2.getComponents();
    }

    public static synchronized Ingredient intern(Ingredient ingredient) {
        return (Ingredient)INGREDIENT_CACHE.addOrGet((Object)ingredient);
    }

    static {
        Hash.Strategy<Ingredient> BASIC_HASH_STRATEGY = new Hash.Strategy<Ingredient>(){

            public int hashCode(Ingredient o) {
                if (o == null) {
                    return 0;
                }
                int result = 1;
                for (Ingredient.Value element : o.getValues()) {
                    if (element instanceof Ingredient.ItemValue) {
                        Ingredient.ItemValue iv = (Ingredient.ItemValue)element;
                        result = 31 * result + ItemStackLinkedSet.TYPE_AND_TAG.hashCode((Object)iv.item()) + (iv.item().getCount() > 1 ? iv.item().getCount() : 0);
                        continue;
                    }
                    result = 31 * result + (element == null ? 0 : element.hashCode());
                }
                return result;
            }

            /*
             * Loose catch block
             */
            public boolean equals(Ingredient a, Ingredient b) {
                Ingredient.Value[] bValues;
                if (b == null) {
                    return false;
                }
                Ingredient.Value[] aValues = a.getValues();
                if (aValues.length != (bValues = b.getValues()).length) {
                    return false;
                }
                for (int i = 0; i < aValues.length; ++i) {
                    Ingredient.Value aValue = aValues[i];
                    Ingredient.Value bValue = bValues[i];
                    if (aValue.getClass() != bValue.getClass()) {
                        return false;
                    }
                    if (aValue instanceof Ingredient.TagValue && bValue instanceof Ingredient.TagValue) {
                        if (aValue.equals((Object)bValue)) continue;
                        return false;
                    }
                    if (aValue instanceof Ingredient.ItemValue) {
                        ItemStack itemStack;
                        Ingredient.ItemValue itemValue = (Ingredient.ItemValue)aValue;
                        ItemStack item = itemStack = itemValue.item();
                        if (bValue instanceof Ingredient.ItemValue) {
                            Ingredient.ItemValue itemValue2 = (Ingredient.ItemValue)bValue;
                            ItemStack item1 = itemStack = itemValue2.item();
                            if (!(MODERNFIX_DEDUPLICATION ? aValue != bValue : item.getCount() != item1.getCount() || !ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)item1))) continue;
                            return false;
                        }
                    }
                    return false;
                }
                return true;
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        };
        INGREDIENT_CACHE = new ObjectOpenCustomHashSet((Hash.Strategy)BASIC_HASH_STRATEGY);
        MODERNFIX_DEDUPLICATION = LoadingModList.get().getModFileById("modernfix") != null ? ModernFixMixinPlugin.instance.isOptionEnabled("perf.ingredient_item_deduplication.IngredientMixin") : false;
    }
}

