/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;

public class FlyNodeEvaluator
extends WalkNodeEvaluator {
    private final Long2ObjectMap<PathType> pathTypeByPosCache = new Long2ObjectOpenHashMap();
    private static final float SMALL_MOB_SIZE = 1.0f;
    private static final float SMALL_MOB_INFLATED_START_NODE_BOUNDING_BOX = 1.1f;
    private static final int MAX_START_NODE_CANDIDATES = 10;

    @Override
    public void prepare(PathNavigationRegion p_77261_, Mob p_77262_) {
        super.prepare(p_77261_, p_77262_);
        this.pathTypeByPosCache.clear();
        p_77262_.onPathfindingStart();
    }

    @Override
    public void done() {
        this.mob.onPathfindingDone();
        this.pathTypeByPosCache.clear();
        super.done();
    }

    @Override
    public Node getStart() {
        BlockPos $$4;
        int $$3;
        if (this.canFloat() && this.mob.isInWater()) {
            int $$0 = this.mob.getBlockY();
            BlockPos.MutableBlockPos $$1 = new BlockPos.MutableBlockPos(this.mob.getX(), (double)$$0, this.mob.getZ());
            BlockState $$2 = this.currentContext.getBlockState($$1);
            while ($$2.is(Blocks.WATER)) {
                $$1.set(this.mob.getX(), (double)(++$$0), this.mob.getZ());
                $$2 = this.currentContext.getBlockState($$1);
            }
        } else {
            $$3 = Mth.floor(this.mob.getY() + 0.5);
        }
        if (!this.canStartAt($$4 = BlockPos.containing(this.mob.getX(), $$3, this.mob.getZ()))) {
            for (BlockPos $$5 : this.iteratePathfindingStartNodeCandidatePositions(this.mob)) {
                if (!this.canStartAt($$5)) continue;
                return super.getStartNode($$5);
            }
        }
        return super.getStartNode($$4);
    }

    @Override
    protected boolean canStartAt(BlockPos p_262645_) {
        PathType $$1 = this.getCachedPathType(p_262645_.getX(), p_262645_.getY(), p_262645_.getZ());
        return this.mob.getPathfindingMalus($$1) >= 0.0f;
    }

    @Override
    public Target getTarget(double p_326875_, double p_326936_, double p_326811_) {
        return this.getTargetNodeAt(p_326875_, p_326936_, p_326811_);
    }

    @Override
    public int getNeighbors(Node[] p_77266_, Node p_77267_) {
        Node $$28;
        Node $$27;
        Node $$26;
        Node $$25;
        Node $$24;
        Node $$23;
        Node $$22;
        Node $$21;
        Node $$20;
        Node $$19;
        Node $$18;
        Node $$17;
        Node $$16;
        Node $$15;
        Node $$14;
        Node $$13;
        Node $$12;
        Node $$11;
        Node $$10;
        Node $$9;
        Node $$8;
        Node $$7;
        Node $$6;
        Node $$5;
        Node $$4;
        int $$2 = 0;
        Node $$3 = this.findAcceptedNode(p_77267_.x, p_77267_.y, p_77267_.z + 1);
        if (this.isOpen($$3)) {
            p_77266_[$$2++] = $$3;
        }
        if (this.isOpen($$4 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y, p_77267_.z))) {
            p_77266_[$$2++] = $$4;
        }
        if (this.isOpen($$5 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y, p_77267_.z))) {
            p_77266_[$$2++] = $$5;
        }
        if (this.isOpen($$6 = this.findAcceptedNode(p_77267_.x, p_77267_.y, p_77267_.z - 1))) {
            p_77266_[$$2++] = $$6;
        }
        if (this.isOpen($$7 = this.findAcceptedNode(p_77267_.x, p_77267_.y + 1, p_77267_.z))) {
            p_77266_[$$2++] = $$7;
        }
        if (this.isOpen($$8 = this.findAcceptedNode(p_77267_.x, p_77267_.y - 1, p_77267_.z))) {
            p_77266_[$$2++] = $$8;
        }
        if (this.isOpen($$9 = this.findAcceptedNode(p_77267_.x, p_77267_.y + 1, p_77267_.z + 1)) && this.hasMalus($$3) && this.hasMalus($$7)) {
            p_77266_[$$2++] = $$9;
        }
        if (this.isOpen($$10 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y + 1, p_77267_.z)) && this.hasMalus($$4) && this.hasMalus($$7)) {
            p_77266_[$$2++] = $$10;
        }
        if (this.isOpen($$11 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y + 1, p_77267_.z)) && this.hasMalus($$5) && this.hasMalus($$7)) {
            p_77266_[$$2++] = $$11;
        }
        if (this.isOpen($$12 = this.findAcceptedNode(p_77267_.x, p_77267_.y + 1, p_77267_.z - 1)) && this.hasMalus($$6) && this.hasMalus($$7)) {
            p_77266_[$$2++] = $$12;
        }
        if (this.isOpen($$13 = this.findAcceptedNode(p_77267_.x, p_77267_.y - 1, p_77267_.z + 1)) && this.hasMalus($$3) && this.hasMalus($$8)) {
            p_77266_[$$2++] = $$13;
        }
        if (this.isOpen($$14 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y - 1, p_77267_.z)) && this.hasMalus($$4) && this.hasMalus($$8)) {
            p_77266_[$$2++] = $$14;
        }
        if (this.isOpen($$15 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y - 1, p_77267_.z)) && this.hasMalus($$5) && this.hasMalus($$8)) {
            p_77266_[$$2++] = $$15;
        }
        if (this.isOpen($$16 = this.findAcceptedNode(p_77267_.x, p_77267_.y - 1, p_77267_.z - 1)) && this.hasMalus($$6) && this.hasMalus($$8)) {
            p_77266_[$$2++] = $$16;
        }
        if (this.isOpen($$17 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y, p_77267_.z - 1)) && this.hasMalus($$6) && this.hasMalus($$5)) {
            p_77266_[$$2++] = $$17;
        }
        if (this.isOpen($$18 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y, p_77267_.z + 1)) && this.hasMalus($$3) && this.hasMalus($$5)) {
            p_77266_[$$2++] = $$18;
        }
        if (this.isOpen($$19 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y, p_77267_.z - 1)) && this.hasMalus($$6) && this.hasMalus($$4)) {
            p_77266_[$$2++] = $$19;
        }
        if (this.isOpen($$20 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y, p_77267_.z + 1)) && this.hasMalus($$3) && this.hasMalus($$4)) {
            p_77266_[$$2++] = $$20;
        }
        if (this.isOpen($$21 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y + 1, p_77267_.z - 1)) && this.hasMalus($$17) && this.hasMalus($$6) && this.hasMalus($$5) && this.hasMalus($$7) && this.hasMalus($$12) && this.hasMalus($$11)) {
            p_77266_[$$2++] = $$21;
        }
        if (this.isOpen($$22 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y + 1, p_77267_.z + 1)) && this.hasMalus($$18) && this.hasMalus($$3) && this.hasMalus($$5) && this.hasMalus($$7) && this.hasMalus($$9) && this.hasMalus($$11)) {
            p_77266_[$$2++] = $$22;
        }
        if (this.isOpen($$23 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y + 1, p_77267_.z - 1)) && this.hasMalus($$19) && this.hasMalus($$6) && this.hasMalus($$4) && this.hasMalus($$7) && this.hasMalus($$12) && this.hasMalus($$10)) {
            p_77266_[$$2++] = $$23;
        }
        if (this.isOpen($$24 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y + 1, p_77267_.z + 1)) && this.hasMalus($$20) && this.hasMalus($$3) && this.hasMalus($$4) && this.hasMalus($$7) && this.hasMalus($$9) && this.hasMalus($$10)) {
            p_77266_[$$2++] = $$24;
        }
        if (this.isOpen($$25 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y - 1, p_77267_.z - 1)) && this.hasMalus($$17) && this.hasMalus($$6) && this.hasMalus($$5) && this.hasMalus($$8) && this.hasMalus($$16) && this.hasMalus($$15)) {
            p_77266_[$$2++] = $$25;
        }
        if (this.isOpen($$26 = this.findAcceptedNode(p_77267_.x + 1, p_77267_.y - 1, p_77267_.z + 1)) && this.hasMalus($$18) && this.hasMalus($$3) && this.hasMalus($$5) && this.hasMalus($$8) && this.hasMalus($$13) && this.hasMalus($$15)) {
            p_77266_[$$2++] = $$26;
        }
        if (this.isOpen($$27 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y - 1, p_77267_.z - 1)) && this.hasMalus($$19) && this.hasMalus($$6) && this.hasMalus($$4) && this.hasMalus($$8) && this.hasMalus($$16) && this.hasMalus($$14)) {
            p_77266_[$$2++] = $$27;
        }
        if (this.isOpen($$28 = this.findAcceptedNode(p_77267_.x - 1, p_77267_.y - 1, p_77267_.z + 1)) && this.hasMalus($$20) && this.hasMalus($$3) && this.hasMalus($$4) && this.hasMalus($$8) && this.hasMalus($$13) && this.hasMalus($$14)) {
            p_77266_[$$2++] = $$28;
        }
        return $$2;
    }

    private boolean hasMalus(@Nullable Node p_77264_) {
        return p_77264_ != null && p_77264_.costMalus >= 0.0f;
    }

    private boolean isOpen(@Nullable Node p_77270_) {
        return p_77270_ != null && !p_77270_.closed;
    }

    @Nullable
    protected Node findAcceptedNode(int p_262970_, int p_263018_, int p_262947_) {
        Node $$3 = null;
        PathType $$4 = this.getCachedPathType(p_262970_, p_263018_, p_262947_);
        float $$5 = this.mob.getPathfindingMalus($$4);
        if ($$5 >= 0.0f) {
            $$3 = this.getNode(p_262970_, p_263018_, p_262947_);
            $$3.type = $$4;
            $$3.costMalus = Math.max($$3.costMalus, $$5);
            if ($$4 == PathType.WALKABLE) {
                $$3.costMalus += 1.0f;
            }
        }
        return $$3;
    }

    @Override
    protected PathType getCachedPathType(int p_326867_, int p_326833_, int p_326788_) {
        return (PathType)((Object)this.pathTypeByPosCache.computeIfAbsent(BlockPos.asLong(p_326867_, p_326833_, p_326788_), p_330153_ -> this.getPathTypeOfMob(this.currentContext, p_326867_, p_326833_, p_326788_, this.mob)));
    }

    @Override
    public PathType getPathType(PathfindingContext p_331058_, int p_77246_, int p_77247_, int p_77248_) {
        PathType $$4 = p_331058_.getPathTypeFromState(p_77246_, p_77247_, p_77248_);
        if ($$4 == PathType.OPEN && p_77247_ >= p_331058_.level().getMinBuildHeight() + 1) {
            BlockPos $$5 = new BlockPos(p_77246_, p_77247_ - 1, p_77248_);
            PathType $$6 = p_331058_.getPathTypeFromState($$5.getX(), $$5.getY(), $$5.getZ());
            if ($$6 == PathType.DAMAGE_FIRE || $$6 == PathType.LAVA) {
                $$4 = PathType.DAMAGE_FIRE;
            } else if ($$6 == PathType.DAMAGE_OTHER) {
                $$4 = PathType.DAMAGE_OTHER;
            } else if ($$6 == PathType.COCOA) {
                $$4 = PathType.COCOA;
            } else if ($$6 == PathType.FENCE) {
                if (!$$5.equals(p_331058_.mobPosition())) {
                    $$4 = PathType.FENCE;
                }
            } else {
                PathType pathType = $$4 = $$6 == PathType.WALKABLE || $$6 == PathType.OPEN || $$6 == PathType.WATER ? PathType.OPEN : PathType.WALKABLE;
            }
        }
        if ($$4 == PathType.WALKABLE || $$4 == PathType.OPEN) {
            $$4 = FlyNodeEvaluator.checkNeighbourBlocks(p_331058_, p_77246_, p_77247_, p_77248_, $$4);
        }
        return $$4;
    }

    private Iterable<BlockPos> iteratePathfindingStartNodeCandidatePositions(Mob p_263108_) {
        boolean $$2;
        AABB $$1 = p_263108_.getBoundingBox();
        boolean bl = $$2 = $$1.getSize() < 1.0;
        if (!$$2) {
            return List.of(BlockPos.containing($$1.minX, p_263108_.getBlockY(), $$1.minZ), BlockPos.containing($$1.minX, p_263108_.getBlockY(), $$1.maxZ), BlockPos.containing($$1.maxX, p_263108_.getBlockY(), $$1.minZ), BlockPos.containing($$1.maxX, p_263108_.getBlockY(), $$1.maxZ));
        }
        double $$3 = Math.max(0.0, (double)1.1f - $$1.getZsize());
        double $$4 = Math.max(0.0, (double)1.1f - $$1.getXsize());
        double $$5 = Math.max(0.0, (double)1.1f - $$1.getYsize());
        AABB $$6 = $$1.inflate($$4, $$5, $$3);
        return BlockPos.randomBetweenClosed(p_263108_.getRandom(), 10, Mth.floor($$6.minX), Mth.floor($$6.minY), Mth.floor($$6.minZ), Mth.floor($$6.maxX), Mth.floor($$6.maxY), Mth.floor($$6.maxZ));
    }
}

