/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.AABB;

public class CatSpawner
implements CustomSpawner {
    private static final int TICK_DELAY = 1200;
    private int nextTick;

    @Override
    public int tick(ServerLevel p_35330_, boolean p_35331_, boolean p_35332_) {
        if (!p_35332_ || !p_35330_.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return 0;
        }
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        this.nextTick = 1200;
        ServerPlayer $$3 = p_35330_.getRandomPlayer();
        if ($$3 == null) {
            return 0;
        }
        RandomSource $$4 = p_35330_.random;
        int $$5 = (8 + $$4.nextInt(24)) * ($$4.nextBoolean() ? -1 : 1);
        int $$6 = (8 + $$4.nextInt(24)) * ($$4.nextBoolean() ? -1 : 1);
        BlockPos $$7 = $$3.blockPosition().offset($$5, 0, $$6);
        int $$8 = 10;
        if (!p_35330_.hasChunksAt($$7.getX() - 10, $$7.getZ() - 10, $$7.getX() + 10, $$7.getZ() + 10)) {
            return 0;
        }
        if (SpawnPlacements.isSpawnPositionOk(EntityType.CAT, p_35330_, $$7)) {
            if (p_35330_.isCloseToVillage($$7, 2)) {
                return this.spawnInVillage(p_35330_, $$7);
            }
            if (p_35330_.structureManager().getStructureWithPieceAt($$7, StructureTags.CATS_SPAWN_IN).isValid()) {
                return this.spawnInHut(p_35330_, $$7);
            }
        }
        return 0;
    }

    private int spawnInVillage(ServerLevel p_35327_, BlockPos p_35328_) {
        List<Cat> $$3;
        int $$2 = 48;
        if (p_35327_.getPoiManager().getCountInRange(p_219610_ -> p_219610_.is(PoiTypes.HOME), p_35328_, 48, PoiManager.Occupancy.IS_OCCUPIED) > 4L && ($$3 = p_35327_.getEntitiesOfClass(Cat.class, new AABB(p_35328_).inflate(48.0, 8.0, 48.0))).size() < 5) {
            return this.spawnCat(p_35328_, p_35327_);
        }
        return 0;
    }

    private int spawnInHut(ServerLevel p_35337_, BlockPos p_35338_) {
        int $$2 = 16;
        List<Cat> $$3 = p_35337_.getEntitiesOfClass(Cat.class, new AABB(p_35338_).inflate(16.0, 8.0, 16.0));
        if ($$3.size() < 1) {
            return this.spawnCat(p_35338_, p_35337_);
        }
        return 0;
    }

    private int spawnCat(BlockPos p_35334_, ServerLevel p_35335_) {
        Cat $$2 = EntityType.CAT.create(p_35335_);
        if ($$2 == null) {
            return 0;
        }
        $$2.finalizeSpawn(p_35335_, p_35335_.getCurrentDifficultyAt(p_35334_), MobSpawnType.NATURAL, null);
        $$2.moveTo(p_35334_, 0.0f, 0.0f);
        p_35335_.addFreshEntityWithPassengers($$2);
        return 1;
    }
}

