/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundProjectilePowerPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class ServerEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TOLERANCE_LEVEL_ROTATION = 1;
    private static final double TOLERANCE_LEVEL_POSITION = 7.62939453125E-6;
    public static final int FORCED_POS_UPDATE_PERIOD = 60;
    private static final int FORCED_TELEPORT_PERIOD = 400;
    private final ServerLevel level;
    private final Entity entity;
    private final int updateInterval;
    private final boolean trackDelta;
    private final Consumer<Packet<?>> broadcast;
    private final VecDeltaCodec positionCodec = new VecDeltaCodec();
    private int lastSentYRot;
    private int lastSentXRot;
    private int lastSentYHeadRot;
    private Vec3 lastSentMovement;
    private int tickCount;
    private int teleportDelay;
    private List<Entity> lastPassengers = Collections.emptyList();
    private boolean wasRiding;
    private boolean wasOnGround;
    @Nullable
    private List<SynchedEntityData.DataValue<?>> trackedDataValues;

    public ServerEntity(ServerLevel p_8528_, Entity p_8529_, int p_8530_, boolean p_8531_, Consumer<Packet<?>> p_8532_) {
        this.level = p_8528_;
        this.broadcast = p_8532_;
        this.entity = p_8529_;
        this.updateInterval = p_8530_;
        this.trackDelta = p_8531_;
        this.positionCodec.setBase(p_8529_.trackingPosition());
        this.lastSentMovement = p_8529_.getDeltaMovement();
        this.lastSentYRot = Mth.floor(p_8529_.getYRot() * 256.0f / 360.0f);
        this.lastSentXRot = Mth.floor(p_8529_.getXRot() * 256.0f / 360.0f);
        this.lastSentYHeadRot = Mth.floor(p_8529_.getYHeadRot() * 256.0f / 360.0f);
        this.wasOnGround = p_8529_.onGround();
        this.trackedDataValues = p_8529_.getEntityData().getNonDefaultValues();
    }

    public void sendChanges() {
        Entity entity;
        List<Entity> $$0 = this.entity.getPassengers();
        if (!$$0.equals(this.lastPassengers)) {
            this.broadcast.accept(new ClientboundSetPassengersPacket(this.entity));
            ServerEntity.removedPassengers($$0, this.lastPassengers).forEach(p_352697_ -> {
                if (p_352697_ instanceof ServerPlayer) {
                    ServerPlayer $$1 = (ServerPlayer)p_352697_;
                    $$1.connection.teleport($$1.getX(), $$1.getY(), $$1.getZ(), $$1.getYRot(), $$1.getXRot());
                }
            });
            this.lastPassengers = $$0;
        }
        if ((entity = this.entity) instanceof ItemFrame) {
            ItemFrame $$1 = (ItemFrame)entity;
            if (this.tickCount % 10 == 0) {
                MapId $$3;
                MapItemSavedData $$4;
                ItemStack $$2 = $$1.getItem();
                if ($$2.getItem() instanceof MapItem && ($$4 = MapItem.getSavedData($$3 = $$2.get(DataComponents.MAP_ID), (Level)this.level)) != null) {
                    for (ServerPlayer $$5 : this.level.players()) {
                        $$4.tickCarriedBy($$5, $$2);
                        Packet<?> $$6 = $$4.getUpdatePacket($$3, $$5);
                        if ($$6 == null) continue;
                        $$5.connection.send($$6);
                    }
                }
                this.sendDirtyEntityData();
            }
        }
        if (this.tickCount % this.updateInterval == 0 || this.entity.hasImpulse || this.entity.getEntityData().isDirty()) {
            if (this.entity.isPassenger()) {
                boolean $$9;
                int $$7 = Mth.floor(this.entity.getYRot() * 256.0f / 360.0f);
                int $$8 = Mth.floor(this.entity.getXRot() * 256.0f / 360.0f);
                boolean bl = $$9 = Math.abs($$7 - this.lastSentYRot) >= 1 || Math.abs($$8 - this.lastSentXRot) >= 1;
                if ($$9) {
                    this.broadcast.accept(new ClientboundMoveEntityPacket.Rot(this.entity.getId(), (byte)$$7, (byte)$$8, this.entity.onGround()));
                    this.lastSentYRot = $$7;
                    this.lastSentXRot = $$8;
                }
                this.positionCodec.setBase(this.entity.trackingPosition());
                this.sendDirtyEntityData();
                this.wasRiding = true;
            } else {
                Vec3 $$23;
                double $$24;
                boolean $$22;
                ++this.teleportDelay;
                int $$10 = Mth.floor(this.entity.getYRot() * 256.0f / 360.0f);
                int $$11 = Mth.floor(this.entity.getXRot() * 256.0f / 360.0f);
                Vec3 $$12 = this.entity.trackingPosition();
                boolean $$13 = this.positionCodec.delta($$12).lengthSqr() >= 7.62939453125E-6;
                Packet<ClientGamePacketListener> $$14 = null;
                boolean $$15 = $$13 || this.tickCount % 60 == 0;
                boolean $$16 = Math.abs($$10 - this.lastSentYRot) >= 1 || Math.abs($$11 - this.lastSentXRot) >= 1;
                boolean $$17 = false;
                boolean $$18 = false;
                long $$19 = this.positionCodec.encodeX($$12);
                long $$20 = this.positionCodec.encodeY($$12);
                long $$21 = this.positionCodec.encodeZ($$12);
                boolean bl = $$22 = $$19 < -32768L || $$19 > 32767L || $$20 < -32768L || $$20 > 32767L || $$21 < -32768L || $$21 > 32767L;
                if ($$22 || this.teleportDelay > 400 || this.wasRiding || this.wasOnGround != this.entity.onGround()) {
                    this.wasOnGround = this.entity.onGround();
                    this.teleportDelay = 0;
                    $$14 = new ClientboundTeleportEntityPacket(this.entity);
                    $$17 = true;
                    $$18 = true;
                } else if ($$15 && $$16 || this.entity instanceof AbstractArrow) {
                    $$14 = new ClientboundMoveEntityPacket.PosRot(this.entity.getId(), (short)$$19, (short)$$20, (short)$$21, (byte)$$10, (byte)$$11, this.entity.onGround());
                    $$17 = true;
                    $$18 = true;
                } else if ($$15) {
                    $$14 = new ClientboundMoveEntityPacket.Pos(this.entity.getId(), (short)$$19, (short)$$20, (short)$$21, this.entity.onGround());
                    $$17 = true;
                } else if ($$16) {
                    $$14 = new ClientboundMoveEntityPacket.Rot(this.entity.getId(), (byte)$$10, (byte)$$11, this.entity.onGround());
                    $$18 = true;
                }
                if ((this.trackDelta || this.entity.hasImpulse || this.entity instanceof LivingEntity && ((LivingEntity)this.entity).isFallFlying()) && this.tickCount > 0 && (($$24 = ($$23 = this.entity.getDeltaMovement()).distanceToSqr(this.lastSentMovement)) > 1.0E-7 || $$24 > 0.0 && $$23.lengthSqr() == 0.0)) {
                    this.lastSentMovement = $$23;
                    Entity entity2 = this.entity;
                    if (entity2 instanceof AbstractHurtingProjectile) {
                        AbstractHurtingProjectile $$25 = (AbstractHurtingProjectile)entity2;
                        this.broadcast.accept(new ClientboundBundlePacket((Iterable<Packet<? super ClientGamePacketListener>>)List.of(new ClientboundSetEntityMotionPacket(this.entity.getId(), this.lastSentMovement), new ClientboundProjectilePowerPacket($$25.getId(), $$25.accelerationPower))));
                    } else {
                        this.broadcast.accept(new ClientboundSetEntityMotionPacket(this.entity.getId(), this.lastSentMovement));
                    }
                }
                if ($$14 != null) {
                    this.broadcast.accept($$14);
                }
                this.sendDirtyEntityData();
                if ($$17) {
                    this.positionCodec.setBase($$12);
                }
                if ($$18) {
                    this.lastSentYRot = $$10;
                    this.lastSentXRot = $$11;
                }
                this.wasRiding = false;
            }
            int $$26 = Mth.floor(this.entity.getYHeadRot() * 256.0f / 360.0f);
            if (Math.abs($$26 - this.lastSentYHeadRot) >= 1) {
                this.broadcast.accept(new ClientboundRotateHeadPacket(this.entity, (byte)$$26));
                this.lastSentYHeadRot = $$26;
            }
            this.entity.hasImpulse = false;
        }
        ++this.tickCount;
        if (this.entity.hurtMarked) {
            this.entity.hurtMarked = false;
            this.broadcastAndSend(new ClientboundSetEntityMotionPacket(this.entity));
        }
    }

    private static Stream<Entity> removedPassengers(List<Entity> p_277592_, List<Entity> p_277658_) {
        return p_277658_.stream().filter(p_275361_ -> !p_277592_.contains(p_275361_));
    }

    public void removePairing(ServerPlayer p_8535_) {
        this.entity.stopSeenByPlayer(p_8535_);
        p_8535_.connection.send(new ClientboundRemoveEntitiesPacket(this.entity.getId()));
    }

    public void addPairing(ServerPlayer p_8542_) {
        ArrayList<Packet<? super ClientGamePacketListener>> $$1 = new ArrayList<Packet<? super ClientGamePacketListener>>();
        this.sendPairingData(p_8542_, $$1::add);
        p_8542_.connection.send(new ClientboundBundlePacket((Iterable<Packet<? super ClientGamePacketListener>>)$$1));
        this.entity.startSeenByPlayer(p_8542_);
    }

    public void sendPairingData(ServerPlayer p_289562_, Consumer<Packet<ClientGamePacketListener>> p_289563_) {
        Leashable $$8;
        Object object;
        if (this.entity.isRemoved()) {
            LOGGER.warn("Fetching packet for removed entity {}", (Object)this.entity);
        }
        Packet<ClientGamePacketListener> $$2 = this.entity.getAddEntityPacket(this);
        p_289563_.accept($$2);
        if (this.trackedDataValues != null) {
            p_289563_.accept(new ClientboundSetEntityDataPacket(this.entity.getId(), this.trackedDataValues));
        }
        boolean $$3 = this.trackDelta;
        if (this.entity instanceof LivingEntity) {
            Collection<AttributeInstance> $$4 = ((LivingEntity)this.entity).getAttributes().getSyncableAttributes();
            if (!$$4.isEmpty()) {
                p_289563_.accept(new ClientboundUpdateAttributesPacket(this.entity.getId(), $$4));
            }
            if (((LivingEntity)this.entity).isFallFlying()) {
                $$3 = true;
            }
        }
        if ($$3 && !(this.entity instanceof LivingEntity)) {
            p_289563_.accept(new ClientboundSetEntityMotionPacket(this.entity.getId(), this.lastSentMovement));
        }
        if (this.entity instanceof LivingEntity) {
            ArrayList $$5 = Lists.newArrayList();
            object = EquipmentSlot.values();
            int n = ((EquipmentSlot[])object).length;
            for (int i = 0; i < n; ++i) {
                EquipmentSlot $$6 = object[i];
                ItemStack $$7 = ((LivingEntity)this.entity).getItemBySlot($$6);
                if ($$7.isEmpty()) continue;
                $$5.add(Pair.of((Object)$$6, (Object)$$7.copy()));
            }
            if (!$$5.isEmpty()) {
                p_289563_.accept(new ClientboundSetEquipmentPacket(this.entity.getId(), $$5));
            }
        }
        if (!this.entity.getPassengers().isEmpty()) {
            p_289563_.accept(new ClientboundSetPassengersPacket(this.entity));
        }
        if (this.entity.isPassenger()) {
            p_289563_.accept(new ClientboundSetPassengersPacket(this.entity.getVehicle()));
        }
        if ((object = this.entity) instanceof Leashable && ($$8 = (Leashable)object).isLeashed()) {
            p_289563_.accept(new ClientboundSetEntityLinkPacket(this.entity, $$8.getLeashHolder()));
        }
    }

    public Vec3 getPositionBase() {
        return this.positionCodec.getBase();
    }

    public Vec3 getLastSentMovement() {
        return this.lastSentMovement;
    }

    public float getLastSentXRot() {
        return (float)(this.lastSentXRot * 360) / 256.0f;
    }

    public float getLastSentYRot() {
        return (float)(this.lastSentYRot * 360) / 256.0f;
    }

    public float getLastSentYHeadRot() {
        return (float)(this.lastSentYHeadRot * 360) / 256.0f;
    }

    private void sendDirtyEntityData() {
        SynchedEntityData $$0 = this.entity.getEntityData();
        List<SynchedEntityData.DataValue<?>> $$1 = $$0.packDirty();
        if ($$1 != null) {
            this.trackedDataValues = $$0.getNonDefaultValues();
            this.broadcastAndSend(new ClientboundSetEntityDataPacket(this.entity.getId(), $$1));
        }
        if (this.entity instanceof LivingEntity) {
            Set<AttributeInstance> $$2 = ((LivingEntity)this.entity).getAttributes().getAttributesToSync();
            if (!$$2.isEmpty()) {
                this.broadcastAndSend(new ClientboundUpdateAttributesPacket(this.entity.getId(), $$2));
            }
            $$2.clear();
        }
    }

    private void broadcastAndSend(Packet<?> p_8539_) {
        this.broadcast.accept(p_8539_);
        if (this.entity instanceof ServerPlayer) {
            ((ServerPlayer)this.entity).connection.send(p_8539_);
        }
    }
}

