/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen;

import cy.jdkdigital.productivetrees.datagen.BeeProvider;
import cy.jdkdigital.productivetrees.datagen.BlockTagProvider;
import cy.jdkdigital.productivetrees.datagen.DataMapProvider;
import cy.jdkdigital.productivetrees.datagen.FeatureProvider;
import cy.jdkdigital.productivetrees.datagen.ItemTagProvider;
import cy.jdkdigital.productivetrees.datagen.LanguageProvider;
import cy.jdkdigital.productivetrees.datagen.LootDataProvider;
import cy.jdkdigital.productivetrees.datagen.LootModifierProvider;
import cy.jdkdigital.productivetrees.datagen.ModelProvider;
import cy.jdkdigital.productivetrees.datagen.RecipeProvider;
import cy.jdkdigital.productivetrees.datagen.compat.CompatLootDataProvider;
import cy.jdkdigital.productivetrees.datagen.compat.CompatModelProvider;
import cy.jdkdigital.productivetrees.datagen.compat.CompatRecipeProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="productivetrees", bus=EventBusSubscriber.Bus.MOD)
public class ProductiveTreesDataProvider {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new LanguageProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new ModelProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new CompatModelProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new CompatLootDataProvider(output, List.of(new LootTableProvider.SubProviderEntry(CompatLootDataProvider.LootProvider::new, LootContextParamSets.BLOCK)), provider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootDataProvider(output, List.of(new LootTableProvider.SubProviderEntry(LootDataProvider.LootProvider::new, LootContextParamSets.BLOCK)), provider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootModifierProvider(output, provider));
        generator.addProvider(event.includeServer(), (DataProvider)new FeatureProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new CompatRecipeProvider(output, provider));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(output, provider));
        generator.addProvider(event.includeServer(), (DataProvider)new BeeProvider(output, provider));
        generator.addProvider(event.includeServer(), (DataProvider)new DataMapProvider(output, provider));
        BlockTagProvider blockTags = new BlockTagProvider(output, provider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagProvider(output, provider, blockTags.contentsGetter(), helper));
    }
}

