/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen;

import cy.jdkdigital.productivetrees.registry.ModTags;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemTagProvider
extends ItemTagsProvider {
    public ItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> future, CompletableFuture<TagsProvider.TagLookup<Block>> provider, ExistingFileHelper helper) {
        super(output, future, provider, "productivetrees", helper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        TreeFinder.trees.forEach((id, treeObject) -> this.tag(ItemTags.SAPLINGS).add((Object)TreeUtil.getBlock(id, "_sapling").asItem()));
        TreeFinder.trees.forEach((id, treeObject) -> {
            this.tag(ItemTags.LEAVES).add((Object)TreeUtil.getBlock(id, "_leaves").asItem());
            this.copy(BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(id.getPath() + "_logs"))), ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(id.getPath() + "_logs"))));
        });
        this.copy(BlockTags.FLOWERS, ItemTags.FLOWERS);
        this.copy(BlockTags.LOGS, ItemTags.LOGS);
        this.copy(BlockTags.LOGS_THAT_BURN, ItemTags.LOGS_THAT_BURN);
        this.copy(BlockTags.PLANKS, ItemTags.PLANKS);
        this.copy(BlockTags.WOODEN_BUTTONS, ItemTags.WOODEN_BUTTONS);
        this.copy(BlockTags.WOODEN_FENCES, ItemTags.WOODEN_FENCES);
        this.copy(BlockTags.WOODEN_PRESSURE_PLATES, ItemTags.WOODEN_PRESSURE_PLATES);
        this.copy(BlockTags.WOODEN_SLABS, ItemTags.WOODEN_SLABS);
        this.copy(BlockTags.WOODEN_STAIRS, ItemTags.WOODEN_STAIRS);
        this.copy(BlockTags.WOODEN_DOORS, ItemTags.WOODEN_DOORS);
        this.copy(BlockTags.WOODEN_TRAPDOORS, ItemTags.WOODEN_TRAPDOORS);
        this.copy(Tags.Blocks.BOOKSHELVES, Tags.Items.BOOKSHELVES);
        this.copy(Tags.Blocks.FENCE_GATES_WOODEN, Tags.Items.FENCE_GATES_WOODEN);
        this.copy(BlockTags.STANDING_SIGNS, ItemTags.SIGNS);
        this.copy(BlockTags.CEILING_HANGING_SIGNS, ItemTags.HANGING_SIGNS);
        this.tag(ModTags.STRIPPER_TOOLS).addOptionalTag(ItemTags.AXES).addOptional(ResourceLocation.parse((String)"allthemodium:alloy_axe")).addOptional(ResourceLocation.parse((String)"allthemodium:unobtainium_axe")).addOptional(ResourceLocation.parse((String)"allthemodium:vibranium_axe")).addOptional(ResourceLocation.parse((String)"allthemodium:allthemodium_axe"));
        this.copy(ModTags.POLLINATABLE, ModTags.POLLINATABLE_ITEM);
        this.copy(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"productivebees:advanced_beehives")), ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"productivebees:advanced_beehives")));
        this.copy(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"productivebees:expansion_boxes")), ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"productivebees:expansion_boxes")));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender dietFruitsTag = this.tag(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"diet:fruits")));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender dietProteinsTag = this.tag(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"diet:proteins")));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender dietIngredientsTag = this.tag(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"diet:ingredients")));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender moddedStrippedLogs = this.tag(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"create:modded_stripped_logs")));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender moddedStrippedWood = this.tag(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"create:modded_stripped_wood")));
        TreeFinder.trees.forEach((id, treeObject) -> {
            moddedStrippedLogs.add((Object)TreeUtil.getBlock(id, "_stripped_log").asItem());
            moddedStrippedWood.add((Object)TreeUtil.getBlock(id, "_stripped_wood").asItem());
        });
        this.tag(ModTags.SAWDUST).add((Object)((Item)TreeRegistrator.SAWDUST.get()));
        this.tag(ModTags.DUSTS_WOOD).add((Object)((Item)TreeRegistrator.SAWDUST.get()));
        this.tag(ModTags.DUSTS).addTag(ModTags.DUSTS_WOOD);
        this.tag(ModTags.COFFEE_BEANS).add((Object)((Item)TreeRegistrator.COFFEE_BEAN.get()));
        this.tag(ModTags.CLOVE).add((Object)((Item)TreeRegistrator.CLOVE.get()));
        this.tag(ModTags.CINNAMON).add((Object)((Item)TreeRegistrator.CINNAMON.get()));
        this.tag(ModTags.NUTMEG).add((Object)((Item)TreeRegistrator.NUTMEG.get()));
        this.tag(ModTags.STAR_ANISE).add((Object)((Item)TreeRegistrator.STAR_ANISE.get()));
        this.tag(ModTags.ROASTED_COFFEE_BEANS).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"roasted_coffee_bean"))));
        this.tag(ModTags.MAPLE_SYRUP).add((Object)((Item)TreeRegistrator.MAPLE_SYRUP.get()));
        this.tag(ModTags.DATE_PALM_JUICE).add((Object)((Item)TreeRegistrator.DATE_PALM_JUICE.get()));
        this.tag(ModTags.CORK).add((Object)((Item)TreeRegistrator.CORK.get()));
        this.tag(ModTags.RUBBER).add((Object)((Item)TreeRegistrator.CURED_RUBBER.get()));
        this.tag(Tags.Items.DYES_YELLOW).add((Object)((Item)TreeRegistrator.FUSTIC.get()));
        this.tag(Tags.Items.DYES_RED).add((Object[])new Item[]{(Item)TreeRegistrator.DRACAENA_SAP.get(), (Item)TreeRegistrator.HAEMATOXYLIN.get()});
        TreeRegistrator.BERRIES.forEach(cropConfig -> {
            TagKey tagKey = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("berries/" + ItemTagProvider.tagName(cropConfig.name()))));
            TagKey tagKeyFruit = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("fruits/" + ItemTagProvider.tagName(cropConfig.name()))));
            TagKey tagKeyCrop = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("crops/" + ItemTagProvider.tagName(cropConfig.name()))));
            this.tag(tagKey).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)cropConfig.name()))));
            this.tag(ModTags.BERRIES).addTag(tagKey);
            dietFruitsTag.addTag(tagKey);
            this.tag(tagKeyFruit).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)cropConfig.name()))));
            this.tag(ModTags.FRUITS).addTag(tagKeyFruit);
            this.tag(tagKeyCrop).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)cropConfig.name()))));
            this.tag(ModTags.CROPS).addTag(tagKeyCrop);
        });
        TreeRegistrator.FRUITS.forEach(cropConfig -> {
            TagKey tagKey = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("fruits/" + ItemTagProvider.tagName(cropConfig.name()))));
            TagKey tagKeyCrop = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("crops/" + ItemTagProvider.tagName(cropConfig.name()))));
            this.tag(tagKey).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)cropConfig.name()))));
            this.tag(ModTags.FRUITS).addTag(tagKey);
            dietFruitsTag.addTag(tagKey);
            this.tag(tagKeyCrop).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)cropConfig.name()))));
            this.tag(ModTags.CROPS).addTag(tagKeyCrop);
        });
        TreeRegistrator.NUTS.forEach(cropConfig -> {
            TagKey tagKey = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("nuts/" + ItemTagProvider.tagName(cropConfig.name()))));
            TagKey tagKeyCrop = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("crops/" + ItemTagProvider.tagName(cropConfig.name()))));
            this.tag(tagKey).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)cropConfig.name()))));
            this.tag(ModTags.NUTS).addTag(tagKey);
            dietProteinsTag.addTag(tagKey);
            this.tag(tagKeyCrop).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)cropConfig.name()))));
            this.tag(ModTags.CROPS).addTag(tagKeyCrop);
        });
        TreeRegistrator.ROASTED_NUTS.forEach(cropConfig -> {
            TagKey tagKey = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("nuts/" + ItemTagProvider.tagName(cropConfig.name()))));
            this.tag(tagKey).add((Object)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)cropConfig.name()))));
            this.tag(ModTags.NUTS).addTag(tagKey);
            dietProteinsTag.addTag(tagKey);
        });
        this.tag(ModTags.FRUITS_APPLE).add((Object[])new Item[]{Items.APPLE, (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"golden_delicious_apple")), (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"granny_smith_apple")), (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"beliy_naliv_apple"))});
        this.tag(ModTags.FRUITS_CRABAPPLE).add((Object[])new Item[]{(Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sweet_crabapple")), (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"prairie_crabapple")), (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"flowering_crabapple"))});
        this.tag(ModTags.FRUITS_CHERRY).add((Object[])new Item[]{(Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"black_cherry")), (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sour_cherry")), (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sparkling_cherry")), (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"wild_cherry"))});
        this.tag(ModTags.FRUITS).addTags(new TagKey[]{ModTags.FRUITS_APPLE, ModTags.FRUITS_CRABAPPLE, ModTags.FRUITS_CHERRY});
        dietIngredientsTag.add((Object[])new Item[]{(Item)TreeRegistrator.ALLSPICE.get(), (Item)TreeRegistrator.CAROB.get(), (Item)TreeRegistrator.COFFEE_BEAN.get(), (Item)TreeRegistrator.CLOVE.get(), (Item)TreeRegistrator.CINNAMON.get(), (Item)TreeRegistrator.NUTMEG.get(), (Item)TreeRegistrator.STAR_ANISE.get()});
        this.copy(Tags.Blocks.STORAGE_BLOCKS, Tags.Items.STORAGE_BLOCKS);
        TreeRegistrator.CRATED_CROPS.forEach(cratePath -> {
            TagKey blockTagKey = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("storage_blocks/" + cratePath.getPath().replace("_crate", ""))));
            TagKey tagKey = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("storage_blocks/" + cratePath.getPath().replace("_crate", ""))));
            this.copy(blockTagKey, tagKey);
        });
    }

    public static String tagName(String cropName) {
        if (cropName.equals("star_fruit")) {
            return "starfruit";
        }
        if (cropName.equals("juniper_berry")) {
            return "juniperberry";
        }
        if (cropName.equals("coffee_bean")) {
            return "coffee_beans";
        }
        return cropName;
    }

    public String getName() {
        return "Productive Trees Item Tags Provider";
    }
}

