/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile.factory;

import com.jerry.mekaf.common.tile.factory.TileEntityAdvancedFactoryBase;
import com.jerry.mekaf.common.upgrade.ChemicalToItemUpgradeData;
import com.jerry.mekmm.common.util.ChemicalStackMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntBiFunction;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.lookup.monitor.FactoryRecipeCacheLookupMonitor;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityChemicalToItemFactory<RECIPE extends MekanismRecipe<?>>
extends TileEntityAdvancedFactoryBase<RECIPE> {
    protected CIProcessInfo[] processInfoSlots;
    public OutputInventorySlot[] outputSlot;
    public IChemicalTank[] inputTank;
    public List<IChemicalTank> inputChemicalTanks = new ArrayList<IChemicalTank>();
    public List<IInventorySlot> outputItemSlots = new ArrayList<IInventorySlot>();

    protected TileEntityChemicalToItemFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state, List<CachedRecipe.OperationTracker.RecipeError> errorTypes, Set<CachedRecipe.OperationTracker.RecipeError> globalErrorTypes) {
        super(blockProvider, pos, state, errorTypes, globalErrorTypes);
        this.processInfoSlots = new CIProcessInfo[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            this.processInfoSlots[i] = new CIProcessInfo(i, this.inputTank[i], (IInventorySlot)this.outputSlot[i]);
        }
        for (CIProcessInfo info : this.processInfoSlots) {
            this.inputChemicalTanks.add(info.inputTank());
            this.outputItemSlots.add(info.outputSlot());
        }
        this.configComponent.setupItemIOConfig(Collections.emptyList(), this.outputItemSlots, (IInventorySlot)this.energySlot, false);
        ConfigInfo chemicalConfig = this.configComponent.getConfig(TransmissionType.CHEMICAL);
        if (chemicalConfig != null) {
            chemicalConfig.addSlotInfo(DataType.INPUT, (ISlotInfo)new ChemicalSlotInfo(true, false, this.inputChemicalTanks));
        }
    }

    @Override
    protected void addTanks(ChemicalTankHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.inputTank = new IChemicalTank[this.tier.processes];
        this.chemicalInputHandlers = new IInputHandler[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            int index = i;
            this.inputTank[i] = BasicChemicalTank.inputModern((long)(10000L * (long)this.tier.processes), this::isValidInputChemical, stack -> this.isChemicalValidForTank((ChemicalStack)stack) && this.inputProducesOutput(index, (ChemicalStack)stack, (IInventorySlot)this.outputSlot[index], false), (IContentsListener)this.recipeCacheLookupMonitors[index]);
            builder.addTank(this.inputTank[i]);
            this.chemicalInputHandlers[i] = InputHelper.getInputHandler((IChemicalTank)this.inputTank[i], (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        }
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.outputSlot = new OutputInventorySlot[this.tier.processes];
        this.itemOutputHandlers = new IOutputHandler[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            FactoryRecipeCacheLookupMonitor lookupMonitor = this.recipeCacheLookupMonitors[i];
            IContentsListener updateSortingAndUnpause = () -> {
                updateSortingListener.onContentsChanged();
                lookupMonitor.unpause();
            };
            int index = i;
            this.outputSlot[i] = OutputInventorySlot.at((IContentsListener)updateSortingAndUnpause, (int)this.getXPos(i), (int)70);
            ((OutputInventorySlot)builder.addSlot((IInventorySlot)this.outputSlot[i])).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, index)));
            this.itemOutputHandlers[i] = OutputHelper.getOutputHandler((IInventorySlot)this.outputSlot[i], (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
        }
    }

    public boolean inputProducesOutput(int process, @NotNull ChemicalStack fallbackInput, @NotNull IInventorySlot outputSlot, boolean updateCache) {
        return outputSlot.isEmpty() || this.getRecipeForInput(process, fallbackInput, outputSlot, updateCache) != null;
    }

    @Contract(value="null, _ -> false")
    protected abstract boolean isCachedRecipeValid(@Nullable CachedRecipe<RECIPE> var1, @NotNull ChemicalStack var2);

    @Nullable
    protected RECIPE getRecipeForInput(int process, @NotNull ChemicalStack fallbackInput, @NotNull IInventorySlot outputSlot, boolean updateCache) {
        CachedRecipe cached;
        if (!CommonWorldTickHandler.flushTagAndRecipeCaches && this.isCachedRecipeValid(cached = this.getCachedRecipe(process), fallbackInput)) {
            return (RECIPE)cached.getRecipe();
        }
        RECIPE foundRecipe = this.findRecipe(process, fallbackInput, outputSlot);
        if (foundRecipe == null) {
            return null;
        }
        if (updateCache) {
            this.recipeCacheLookupMonitors[process].updateCachedRecipe(foundRecipe);
        }
        return foundRecipe;
    }

    @Nullable
    protected abstract RECIPE findRecipe(int var1, @NotNull ChemicalStack var2, @NotNull IInventorySlot var3);

    public abstract boolean isChemicalValidForTank(@NotNull ChemicalStack var1);

    public abstract boolean isValidInputChemical(@NotNull ChemicalStack var1);

    protected abstract int getNeededInput(RECIPE var1, ChemicalStack var2);

    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof ChemicalToItemUpgradeData) {
            int i;
            ChemicalToItemUpgradeData data = (ChemicalToItemUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.energySlot.deserializeNBT(provider, data.energySlot.serializeNBT(provider));
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputTanks.size(); ++i) {
                this.inputChemicalTanks.get(i).deserializeNBT(provider, data.inputTanks.get(i).serializeNBT(provider));
            }
            for (i = 0; i < data.outputSlots.size(); ++i) {
                this.outputItemSlots.get(i).setStack(data.outputSlots.get(i).getStack());
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components, provider);
            }
        } else {
            super.parseUpgradeData(provider, upgradeData);
        }
    }

    @Override
    protected void sortInventoryOrTank() {
        Map<ChemicalStack, CIRecipeProcessInfo<RECIPE>> processes = ChemicalStackMap.createTypeAndComponentsMap();
        ArrayList<CIProcessInfo> emptyProcesses = new ArrayList<CIProcessInfo>();
        for (CIProcessInfo processInfo : this.processInfoSlots) {
            CachedRecipe cachedRecipe;
            IChemicalTank inputTank = processInfo.inputTank();
            if (inputTank.isEmpty()) {
                emptyProcesses.add(processInfo);
                continue;
            }
            ChemicalStack inputStack = inputTank.getStack();
            CIRecipeProcessInfo recipeProcessInfo = processes.computeIfAbsent(inputStack, i -> new CIRecipeProcessInfo());
            recipeProcessInfo.processes.add(processInfo);
            recipeProcessInfo.totalCount += inputStack.getAmount();
            if (recipeProcessInfo.lazyMinPerTank != null || CommonWorldTickHandler.flushTagAndRecipeCaches || !this.isCachedRecipeValid(cachedRecipe = this.getCachedRecipe(processInfo.process()), inputStack)) continue;
            recipeProcessInfo.item = inputStack;
            recipeProcessInfo.recipe = cachedRecipe.getRecipe();
            recipeProcessInfo.lazyMinPerTank = (info, factory) -> factory.getNeededInput(info.recipe, (ChemicalStack)info.item);
        }
        if (processes.isEmpty()) {
            return;
        }
        for (Map.Entry entry : processes.entrySet()) {
            CIRecipeProcessInfo recipeProcessInfo = (CIRecipeProcessInfo)entry.getValue();
            if (recipeProcessInfo.lazyMinPerTank != null) continue;
            recipeProcessInfo.item = entry.getKey();
            recipeProcessInfo.lazyMinPerTank = (info, factory) -> {
                ChemicalStack item = (ChemicalStack)info.item;
                ChemicalStack largerInput = item.copyWithAmount(Math.min(10000L * (long)this.tier.processes, info.totalCount));
                CIProcessInfo processInfo = info.processes.getFirst();
                info.recipe = factory.getRecipeForInput(processInfo.process(), largerInput, processInfo.outputSlot(), true);
                if (info.recipe != null) {
                    return factory.getNeededInput(info.recipe, largerInput);
                }
                return 1;
            };
        }
        if (!emptyProcesses.isEmpty()) {
            this.addEmptyTanksAsTargets(processes, emptyProcesses);
        }
        this.distributeItems(processes);
    }

    protected void addEmptyTanksAsTargets(Map<ChemicalStack, CIRecipeProcessInfo<RECIPE>> processes, List<CIProcessInfo> emptyProcesses) {
        for (Map.Entry<ChemicalStack, CIRecipeProcessInfo<RECIPE>> entry : processes.entrySet()) {
            int processAmount;
            CIRecipeProcessInfo<RECIPE> recipeProcessInfo = entry.getValue();
            long minPerTank = recipeProcessInfo.getMinPerTank(this);
            long maxTanks = recipeProcessInfo.totalCount / minPerTank;
            if (maxTanks <= 1L || maxTanks <= (long)(processAmount = recipeProcessInfo.processes.size())) continue;
            ChemicalStack sourceStack = entry.getKey();
            long emptyToAdd = maxTanks - (long)processAmount;
            int added = 0;
            ArrayList<CIProcessInfo> toRemove = new ArrayList<CIProcessInfo>();
            for (CIProcessInfo emptyProcess : emptyProcesses) {
                if (!this.inputProducesOutput(emptyProcess.process(), sourceStack, emptyProcess.outputSlot(), true)) continue;
                recipeProcessInfo.processes.add(emptyProcess);
                toRemove.add(emptyProcess);
                if ((long)(++added) < emptyToAdd) continue;
                break;
            }
            emptyProcesses.removeAll(toRemove);
            if (!emptyProcesses.isEmpty()) continue;
            break;
        }
    }

    protected void distributeItems(Map<ChemicalStack, CIRecipeProcessInfo<RECIPE>> processes) {
        for (Map.Entry<ChemicalStack, CIRecipeProcessInfo<RECIPE>> entry : processes.entrySet()) {
            CIRecipeProcessInfo<RECIPE> recipeProcessInfo = entry.getValue();
            long processAmount = recipeProcessInfo.processes.size();
            if (processAmount == 1L) continue;
            ChemicalStack item = entry.getKey();
            long numberPerTank = recipeProcessInfo.totalCount / processAmount;
            long maxAmount = 10000L * (long)this.tier.processes;
            if (numberPerTank == maxAmount) continue;
            long remainder = recipeProcessInfo.totalCount % processAmount;
            long minPerTank = recipeProcessInfo.getMinPerTank(this);
            if (minPerTank > 1L) {
                long perSlotRemainder = numberPerTank % minPerTank;
                if (perSlotRemainder > 0L) {
                    numberPerTank -= perSlotRemainder;
                    remainder += perSlotRemainder * processAmount;
                }
                if (numberPerTank + minPerTank > maxAmount) {
                    minPerTank = maxAmount - numberPerTank;
                }
            }
            int i = 0;
            while ((long)i < processAmount) {
                CIProcessInfo processInfo = recipeProcessInfo.processes.get(i);
                IChemicalTank inputTank = processInfo.inputTank();
                long sizeForTank = numberPerTank;
                if (remainder > 0L) {
                    if (remainder > minPerTank) {
                        sizeForTank += minPerTank;
                        remainder -= minPerTank;
                    } else {
                        sizeForTank += remainder;
                        remainder = 0L;
                    }
                }
                if (inputTank.isEmpty()) {
                    if (sizeForTank > 0L) {
                        inputTank.setStackUnchecked(item.copyWithAmount(sizeForTank));
                    }
                } else if (sizeForTank == 0L) {
                    inputTank.setEmpty();
                } else if (inputTank.getCapacity() != sizeForTank) {
                    MekanismUtils.logMismatchedStackSize((long)sizeForTank, (long)inputTank.setStackSize(sizeForTank, Action.EXECUTE));
                }
                ++i;
            }
        }
    }

    public record CIProcessInfo(int process, @NotNull IChemicalTank inputTank, @NotNull IInventorySlot outputSlot) {
    }

    protected static class CIRecipeProcessInfo<RECIPE extends MekanismRecipe<?>> {
        private final List<CIProcessInfo> processes = new ArrayList<CIProcessInfo>();
        @Nullable
        private ToIntBiFunction<CIRecipeProcessInfo<RECIPE>, TileEntityChemicalToItemFactory<RECIPE>> lazyMinPerTank;
        private Object item;
        private RECIPE recipe;
        private long minPerTank = 1L;
        private long totalCount;

        protected CIRecipeProcessInfo() {
        }

        public long getMinPerTank(TileEntityChemicalToItemFactory<RECIPE> factory) {
            if (this.lazyMinPerTank != null) {
                this.minPerTank = Math.max(1, this.lazyMinPerTank.applyAsInt(this, factory));
                this.lazyMinPerTank = null;
            }
            return this.minPerTank;
        }
    }
}

