/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile.factory;

import com.jerry.mekaf.common.capabilities.energy.AdvancedFactoryEnergyContainer;
import com.jerry.mekaf.common.tile.factory.TileEntityChemicalToChemicalFactory;
import com.jerry.mekaf.common.upgrade.ChemicalChemicalToChemicalUpgradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ChemicalChemicalToChemicalCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IEitherSideRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.upgrade.IUpgradeData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityChemicalInfusingFactory
extends TileEntityChemicalToChemicalFactory<ChemicalChemicalToChemicalRecipe>
implements IHasDumpButton,
IEitherSideRecipeLookupHandler.EitherSideChemicalRecipeLookupHandler<ChemicalChemicalToChemicalRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_LEFT_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_RIGHT_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_RIGHT_INPUT);
    public IChemicalTank rightTank;
    private final IInputHandler<@NotNull ChemicalStack> rightInputHandler;
    ChemicalInventorySlot rightInputSlot;

    public TileEntityChemicalInfusingFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        ConfigInfo chemicalConfig;
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.INPUT_2, (ISlotInfo)new InventorySlotInfo(true, false, new IInventorySlot[]{this.rightInputSlot}));
            itemConfig.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.rightInputSlot}));
        }
        if ((chemicalConfig = this.configComponent.getConfig(TransmissionType.CHEMICAL)) != null) {
            chemicalConfig.addSlotInfo(DataType.INPUT_2, (ISlotInfo)new ChemicalSlotInfo(true, false, new IChemicalTank[]{this.rightTank}));
            chemicalConfig.addSlotInfo(DataType.INPUT_1, (ISlotInfo)new ChemicalSlotInfo(true, false, this.inputChemicalTanks));
            ArrayList<IChemicalTank> ioTank = new ArrayList<IChemicalTank>(List.of(this.rightTank));
            ioTank.addAll(this.inputChemicalTanks);
            chemicalConfig.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new ChemicalSlotInfo(true, true, ioTank));
        }
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.CHEMICAL}).setCanTankEject(tank -> this.outputChemicalTanks.contains(tank));
        this.rightInputHandler = InputHelper.getInputHandler((IChemicalTank)this.rightTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_RIGHT_INPUT);
    }

    @Override
    protected void addTanks(ChemicalTankHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        super.addTanks(builder, listener, updateSortingListener);
        this.rightTank = BasicChemicalTank.inputModern((long)(10000L * (long)this.tier.processes), arg_0 -> ((TileEntityChemicalInfusingFactory)this).containsRecipe(arg_0), (IContentsListener)this.markAllMonitorsChanged(listener));
        builder.addTank(this.rightTank);
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.rightInputSlot = ChemicalInventorySlot.fill((IChemicalTank)this.rightTank, (IContentsListener)listener, (int)7, (int)83);
        builder.addSlot((IInventorySlot)this.rightInputSlot);
        this.rightInputSlot.setSlotType(ContainerSlotType.INPUT);
        this.rightInputSlot.setSlotOverlay(SlotOverlay.MINUS);
    }

    @Override
    protected void handleSecondaryFuel() {
        this.rightInputSlot.fillTank();
    }

    @Override
    public boolean hasSecondaryResourceBar() {
        return true;
    }

    @Override
    public IChemicalTank getChemicalTankBar() {
        return this.rightTank;
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<ChemicalChemicalToChemicalRecipe> cached, @NotNull ChemicalStack stack) {
        if (cached != null) {
            ChemicalChemicalToChemicalRecipe cachedRecipe = (ChemicalChemicalToChemicalRecipe)cached.getRecipe();
            return cachedRecipe.getLeftInput().testType(stack) && (this.rightTank.isEmpty() || cachedRecipe.getRightInput().testType(this.rightTank.getTypeHolder()));
        }
        return false;
    }

    @Override
    @Nullable
    protected ChemicalChemicalToChemicalRecipe findRecipe(int process, @NotNull ChemicalStack fallbackInput, @NotNull IChemicalTank outputSlot) {
        return (ChemicalChemicalToChemicalRecipe)((InputRecipeCache.EitherSideChemical)this.getRecipeType().getInputCache()).findFirstRecipe(this.level, (Object)fallbackInput, (Object)outputSlot.getStack());
    }

    @Override
    public boolean isChemicalValidForTank(@NotNull ChemicalStack stack) {
        return this.containsRecipe(this.rightTank.getStack(), stack) || this.containsRecipe(stack, this.rightTank.getStack());
    }

    @Override
    public boolean isValidInputChemical(@NotNull ChemicalStack stack) {
        return this.containsRecipe(stack, this.rightTank.getStack()) || this.containsRecipe(this.rightTank.getStack(), stack);
    }

    @Override
    protected int getNeededInput(ChemicalChemicalToChemicalRecipe recipe, ChemicalStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getLeftInput().getNeededAmount(inputStack));
    }

    @NotNull
    public IMekanismRecipeTypeProvider<?, ChemicalChemicalToChemicalRecipe, InputRecipeCache.EitherSideChemical<ChemicalChemicalToChemicalRecipe>> getRecipeType() {
        return MekanismRecipeType.CHEMICAL_INFUSING;
    }

    @Nullable
    public IRecipeViewerRecipeType<ChemicalChemicalToChemicalRecipe> recipeViewerType() {
        return RecipeViewerRecipeType.CHEMICAL_INFUSING;
    }

    @Nullable
    public ChemicalChemicalToChemicalRecipe getRecipe(int cacheIndex) {
        return (ChemicalChemicalToChemicalRecipe)this.findFirstRecipe(this.chemicalInputHandlers[cacheIndex], this.rightInputHandler);
    }

    @NotNull
    public CachedRecipe<ChemicalChemicalToChemicalRecipe> createNewCachedRecipe(@NotNull ChemicalChemicalToChemicalRecipe recipe, int cacheIndex) {
        return new ChemicalChemicalToChemicalCachedRecipe(recipe, this.recheckAllRecipeErrors[cacheIndex], this.chemicalInputHandlers[cacheIndex], this.rightInputHandler, this.chemicalOutputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> ((TileEntityChemicalInfusingFactory)this).canFunction()).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((AdvancedFactoryEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setBaselineMaxOperations(() -> this.baselineMaxOperations).setOnFinish(() -> ((TileEntityChemicalInfusingFactory)this).markForSave());
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.baselineMaxOperations = (int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        }
    }

    @Override
    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof ChemicalChemicalToChemicalUpgradeData) {
            ChemicalChemicalToChemicalUpgradeData data = (ChemicalChemicalToChemicalUpgradeData)upgradeData;
            super.parseUpgradeData(provider, upgradeData);
            this.rightTank.deserializeNBT(provider, data.inputTank.serializeNBT(provider));
            this.rightInputSlot.deserializeNBT(provider, data.chemicalSlot.serializeNBT(provider));
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @Nullable
    public IUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new ChemicalChemicalToChemicalUpgradeData(provider, this.redstone, this.getControlType(), (IEnergyContainer)this.energyContainer, this.progress, null, this.energySlot, this.rightInputSlot, this.inputChemicalTanks, this.rightTank, this.outputChemicalTanks, this.isSorting(), this.getComponents());
    }

    public void dump() {
        this.rightTank.setEmpty();
    }
}

