/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.mekanism.common.machine.component;

import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.mekanism.common.registration.ComponentRegistration;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.functions.ConstantPredicates;
import net.minecraft.MethodsReturnNonnullByDefault;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ChemicalComponent
extends MachineComponent<BasicChemicalTank> {
    private final BasicChemicalTank handler;

    public ChemicalComponent(BasicChemicalTank handler, IOType ioType) {
        super(ioType);
        this.handler = handler;
    }

    @NotNull
    public ComponentType getComponentType() {
        return ComponentRegistration.COMPONENT_CHEMICAL.get();
    }

    public BasicChemicalTank getContainerProvider() {
        return this.handler;
    }

    public <C extends MachineComponent<?>> boolean canMerge(C c) {
        ChemicalComponent comp = (ChemicalComponent)c;
        if (this.getIOType().isInput()) {
            return this.handler.getStack().is(comp.handler.getStack().getChemical());
        }
        return this.handler.isEmpty() || comp.handler.isEmpty() || this.handler.getStack().is(comp.getContainerProvider().getStack().getChemical());
    }

    public <C extends MachineComponent<?>> C merge(C c) {
        final ChemicalComponent comp = (ChemicalComponent)c;
        return (C)((Object)new ChemicalComponent(new BasicChemicalTank(this.handler.getCapacity() + comp.handler.getCapacity(), (chem, a) -> true, (chem, a) -> true, ConstantPredicates.alwaysTrue(), ChemicalAttributeValidator.ALWAYS_ALLOW, null, null){

            public void setStack(ChemicalStack stack) {
            }

            public void setStackUnchecked(ChemicalStack stack) {
            }

            public boolean isValid(ChemicalStack stack) {
                return ChemicalComponent.this.handler.isValid(stack) || comp.handler.isValid(stack);
            }

            public long setStackSize(long amount, Action action) {
                return 0L;
            }

            public long growStack(long amount, Action action) {
                return 0L;
            }

            public boolean isEmpty() {
                return ChemicalComponent.this.handler.isEmpty() && comp.handler.isEmpty();
            }

            public ChemicalStack insert(ChemicalStack stack, Action action, AutomationType automationType) {
                ChemicalStack inserted1 = ChemicalComponent.this.handler.insert(stack, action, automationType);
                stack = stack.copyWithAmount(inserted1.getAmount());
                return comp.handler.insert(stack, action, automationType);
            }

            public ChemicalStack insertChemical(ChemicalStack stack, Action action) {
                ChemicalStack inserted1 = ChemicalComponent.this.handler.insertChemical(stack, action);
                stack = stack.copyWithAmount(inserted1.getAmount());
                return comp.handler.insertChemical(stack, action);
            }

            public ChemicalStack insertChemical(int tank, ChemicalStack stack, Action action) {
                ChemicalStack inserted1 = ChemicalComponent.this.handler.insertChemical(tank, stack, action);
                stack = stack.copyWithAmount(inserted1.getAmount());
                return comp.handler.insertChemical(tank, stack, action);
            }

            public ChemicalStack extract(long amount, Action action, AutomationType automationType) {
                ChemicalStack extracted1 = ChemicalComponent.this.handler.extract(amount, action, automationType);
                ChemicalStack extracted2 = comp.handler.extract(amount -= extracted1.getAmount(), action, automationType);
                return extracted1.copyWithAmount(extracted1.getAmount() + extracted2.getAmount());
            }

            public ChemicalStack extractChemical(long amount, Action action) {
                ChemicalStack extracted1 = ChemicalComponent.this.handler.extractChemical(amount, action);
                ChemicalStack extracted2 = comp.handler.extractChemical(amount -= extracted1.getAmount(), action);
                return extracted1.copyWithAmount(extracted1.getAmount() + extracted2.getAmount());
            }

            public ChemicalStack extractChemical(ChemicalStack stack, Action action) {
                ChemicalStack extracted1 = ChemicalComponent.this.handler.extractChemical(stack, action);
                stack = stack.copyWithAmount(stack.getAmount() - extracted1.getAmount());
                ChemicalStack extracted2 = comp.handler.extractChemical(stack, action);
                return extracted1.copyWithAmount(extracted1.getAmount() + extracted2.getAmount());
            }

            public ChemicalStack extractChemical(int tank, long amount, Action action) {
                ChemicalStack extracted1 = ChemicalComponent.this.handler.extractChemical(tank, amount, action);
                ChemicalStack extracted2 = comp.handler.extractChemical(tank, amount -= extracted1.getAmount(), action);
                return extracted1.copyWithAmount(extracted1.getAmount() + extracted2.getAmount());
            }

            public ChemicalStack getStack() {
                return ChemicalComponent.this.handler.getStack().copyWithAmount(this.getStored());
            }

            public long getStored() {
                return ChemicalComponent.this.handler.getStored() + comp.handler.getStored();
            }
        }, this.getIOType()));
    }

    public int compareTo(@NotNull MachineComponent<BasicChemicalTank> o) {
        BasicChemicalTank one = this.getContainerProvider();
        BasicChemicalTank two = (BasicChemicalTank)o.getContainerProvider();
        if (one.isEmpty() && two.isEmpty()) {
            return 0;
        }
        if (one.isEmpty() && !two.isEmpty()) {
            return -1;
        }
        if (!one.isEmpty() && !two.isEmpty()) {
            return 0;
        }
        return 1;
    }
}

