/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.mekanism.common.crafting.requirement.jei;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.common.crafting.MachineRecipe;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedSizedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.jei.JeiComponent;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.integration.jei.MMRJeiPlugin;
import es.degrassi.mmreborn.common.integration.jei.category.MMRRecipeCategory;
import es.degrassi.mmreborn.common.integration.jei.category.drawable.DrawableWrappedText;
import es.degrassi.mmreborn.common.util.Utils;
import es.degrassi.mmreborn.mekanism.common.crafting.requirement.RequirementChemical;
import es.degrassi.mmreborn.mekanism.common.machine.component.ChemicalComponent;
import java.util.List;
import java.util.Objects;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.recipe_viewer.jei.ChemicalStackRenderer;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class JeiChemicalComponent
extends JeiComponent<ChemicalStack, RecipeRequirement<ChemicalComponent, RequirementChemical>> {
    public JeiChemicalComponent(RecipeRequirement<ChemicalComponent, RequirementChemical> requirement) {
        super(requirement, 0, 0);
    }

    public int getWidth() {
        return 16;
    }

    public int getHeight() {
        return 16;
    }

    public List<ChemicalStack> ingredients() {
        return Lists.newArrayList((Object[])new ChemicalStack[]{((RequirementChemical)this.requirement.requirement()).required.copy()});
    }

    @NotNull
    public List<Component> getTooltip(@NotNull ChemicalStack ingredient, @NotNull TooltipFlag tooltipFlag) {
        List tooltip = super.getTooltip((Object)ingredient, tooltipFlag);
        String mode = ((RequirementChemical)this.requirement.requirement()).getMode().isInput() ? "input" : "output";
        tooltip.add(Component.translatable((String)("modular_machinery_reborn.jei.ingredient.chemical." + mode), (Object[])new Object[]{ingredient.getTextComponent(), ingredient.getAmount()}));
        if (this.requirement.chance() < 1.0f && this.requirement.chance() >= 0.0f) {
            String keyNever = ((RequirementChemical)this.requirement.requirement()).getMode().isInput() ? "tooltip.machinery.chance.in.never" : "tooltip.machinery.chance.out.never";
            String keyChance = ((RequirementChemical)this.requirement.requirement()).getMode().isInput() ? "tooltip.machinery.chance.in" : "tooltip.machinery.chance.out";
            Object chanceStr = String.valueOf(Mth.floor((float)(this.requirement.chance() * 100.0f)));
            if (this.requirement.chance() == 0.0f) {
                tooltip.add(Component.translatable((String)keyNever));
            } else {
                if (this.requirement.chance() < 0.01f) {
                    chanceStr = "< 1";
                }
                chanceStr = (String)chanceStr + "%";
                tooltip.add(Component.translatable((String)keyChance, (Object[])new Object[]{chanceStr}));
            }
        }
        return tooltip;
    }

    public void setRecipe(MMRRecipeCategory category, IRecipeLayoutBuilder builder, MachineRecipe recipe, IFocusGroup focuses) {
        MutableComponent component = Component.empty();
        String chance = Utils.decimalFormat((double)(this.requirement.chance() * 100.0f));
        if (this.requirement.chance() > 0.0f && this.requirement.chance() < 1.0f) {
            component = Component.translatable((String)"modular_machinery_reborn.ingredient.chance", (Object[])new Object[]{chance, "%"}).withColor(Config.chanceColor);
        } else if (this.requirement.chance() == 0.0f) {
            component = Component.translatable((String)"modular_machinery_reborn.ingredient.chance.nc").withColor(Config.chanceColor);
        }
        Font font = Minecraft.getInstance().font;
        List list = recipe.chanceTexts;
        PositionedSizedRequirement positionedSizedRequirement = new PositionedSizedRequirement(this.getPosition().x(), this.getPosition().y(), this.getWidth(), font.wordWrapHeight((FormattedText)component, this.getWidth()));
        DrawableWrappedText drawableWrappedText = new DrawableWrappedText(List.of(component), this.getWidth() + 2, true).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEX, (double)this.getPosition().x()).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEY, (double)this.getPosition().y()).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.SCALE, 0.75).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEZ, 500.0).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEX, (double)(this.getWidth() - 16) / 2.0).transform(DrawableWrappedText.Operation.ADD, DrawableWrappedText.State.TRANSLATEX, 17.0).transform(DrawableWrappedText.Operation.REMOVE, DrawableWrappedText.State.TRANSLATEX, (double)Math.min(14, font.width((FormattedText)component))).transform(DrawableWrappedText.Operation.SET, DrawableWrappedText.State.TRANSLATEY, (double)(this.getHeight() - 16) / 2.0).transform(DrawableWrappedText.Operation.REMOVE, DrawableWrappedText.State.TRANSLATEY, 1.0);
        Objects.requireNonNull(font);
        list.add(Pair.of((Object)positionedSizedRequirement, (Object)drawableWrappedText.transform(DrawableWrappedText.Operation.ADD, DrawableWrappedText.State.TRANSLATEY, 9.0 * 3.0 / 2.0)));
        ((IRecipeSlotBuilder)builder.addSlot(this.role(), this.getPosition().x(), this.getPosition().y()).setOverlay((IDrawable)MMRJeiPlugin.jeiHelpers.getGuiHelper().createDrawable(this.texture(), this.getUOffset(), this.getVOffset(), this.getWidth() + 2, this.getHeight() + 2), -1, -1).setCustomRenderer(MekanismJEI.TYPE_CHEMICAL, (IIngredientRenderer)new ChemicalStackRenderer(((RequirementChemical)this.getRequirement().requirement()).amount, this.getWidth(), this.getHeight())).addIngredient(MekanismJEI.TYPE_CHEMICAL, (Object)new ChemicalStack(((RequirementChemical)this.getRequirement().requirement()).required.getChemicalHolder(), ((RequirementChemical)this.getRequirement().requirement()).amount))).addRichTooltipCallback((slot, tooltip) -> tooltip.addAll(this.getTooltip(this.ingredients().get(0), (TooltipFlag)TooltipFlag.NORMAL)));
    }
}

