/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.mekanism.common.crafting.requirement.emi;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.screen.EmiScreenManager;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.client.requirement.ChanceRendering;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.SlotTooltip;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.mekanism.client.requirement.ChemicalRendering;
import es.degrassi.mmreborn.mekanism.common.crafting.requirement.RequirementChemical;
import es.degrassi.mmreborn.mekanism.common.machine.component.ChemicalComponent;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.recipe_viewer.emi.ChemicalEmiStack;
import mekanism.common.MekanismLang;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class EmiChemicalComponent
extends EmiComponent<ChemicalStack, RecipeRequirement<ChemicalComponent, RequirementChemical>>
implements ChemicalRendering,
SlotTooltip,
ChanceRendering {
    private int width = 16;
    private int height = 16;
    private EmiRecipe recipe;

    public EmiChemicalComponent(RecipeRequirement<ChemicalComponent, RequirementChemical> requirement) {
        super(requirement, 0, 0);
    }

    public List<ChemicalStack> ingredients() {
        return Lists.newArrayList((Object[])new ChemicalStack[]{((RequirementChemical)this.requirement.requirement()).required.copy()});
    }

    public EmiStack getStack() {
        return new ChemicalEmiStack(((RequirementChemical)this.requirement.requirement()).required.copyWithAmount(((RequirementChemical)this.requirement.requirement()).amount));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.width += 2;
        this.height += 2;
        super.render(guiGraphics, mouseX, mouseY);
        this.width -= 2;
        this.height -= 2;
        this.renderChemical(guiGraphics, ((RequirementChemical)this.requirement.requirement()).required);
        this.drawChance(guiGraphics, false);
    }

    public List<Component> getTooltip() {
        LinkedList<Component> tooltip = new LinkedList<Component>();
        String mode = ((RequirementChemical)this.requirement.requirement()).getMode().isInput() ? "input" : "output";
        tooltip.add((Component)Component.translatable((String)("modular_machinery_reborn.jei.ingredient.chemical." + mode), (Object[])new Object[]{((RequirementChemical)this.requirement.requirement()).required.getTextComponent(), ((RequirementChemical)this.requirement.requirement()).amount}));
        if (this.requirement.chance() < 1.0f && this.requirement.chance() >= 0.0f) {
            String keyNever = ((RequirementChemical)this.requirement.requirement()).getMode().isInput() ? "tooltip.machinery.chance.in.never" : "tooltip.machinery.chance.out.never";
            String keyChance = ((RequirementChemical)this.requirement.requirement()).getMode().isInput() ? "tooltip.machinery.chance.in" : "tooltip.machinery.chance.out";
            Object chanceStr = String.valueOf(Mth.floor((float)(this.requirement.chance() * 100.0f)));
            if (this.requirement.chance() == 0.0f) {
                tooltip.add((Component)Component.translatable((String)keyNever));
            } else {
                if (this.requirement.chance() < 0.01f) {
                    chanceStr = "< 1";
                }
                chanceStr = (String)chanceStr + "%";
                tooltip.add((Component)Component.translatable((String)keyChance, (Object[])new Object[]{chanceStr}));
            }
        }
        this.collectTooltip(tooltip::add);
        this.addChanceTooltips(tooltip);
        return tooltip;
    }

    private void collectTooltip(Consumer<Component> tooltipAdder) {
        ChemicalStack stack = ((RequirementChemical)this.requirement.requirement()).required;
        Chemical chemical = stack.getChemical();
        if (!Objects.equals(stack.getChemicalHolder().getKey(), MekanismAPI.EMPTY_CHEMICAL_KEY)) {
            tooltipAdder.accept((Component)TextComponentUtil.build((Object[])new Object[]{stack}));
            tooltipAdder.accept((Component)MekanismLang.GENERIC_MB.translateColored(EnumColor.GRAY, new Object[]{TextUtils.format((long)stack.getAmount())}));
        }
    }

    public void recipeContext(EmiRecipe recipe) {
        this.recipe = recipe;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.slotInteraction(bind -> bind.matchesMouse(button))) {
            return true;
        }
        return EmiScreenManager.stackInteraction((EmiStackInteraction)new EmiStackInteraction((EmiIngredient)this.getStack(), this.getRecipe(), true), bind -> bind.matchesMouse(button));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.slotInteraction(bind -> bind.matchesKey(keyCode, scanCode))) {
            return true;
        }
        return EmiScreenManager.stackInteraction((EmiStackInteraction)new EmiStackInteraction((EmiIngredient)this.getStack(), this.getRecipe(), true), bind -> bind.matchesKey(keyCode, scanCode));
    }

    public float getChance() {
        return this.requirement.chance();
    }

    public IOType getActionType() {
        return ((RequirementChemical)this.requirement.requirement()).getMode();
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }

    @Generated
    public EmiRecipe getRecipe() {
        return this.recipe;
    }
}

