/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.mekanism.common.crafting.requirement;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.modifier.RecipeModifier;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.mekanism.common.machine.component.ChemicalComponent;
import es.degrassi.mmreborn.mekanism.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.mekanism.common.registration.RequirementTypeRegistration;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.chemical.SingleChemicalIngredient;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class RequirementChemical
implements IRequirement<ChemicalComponent> {
    public static final NamedCodec<RequirementChemical> CODEC = NamedCodec.record(instance -> instance.group((App)NamedCodec.of((Codec)SingleChemicalIngredient.CODEC.codec()).fieldOf("chemical").forGetter(req -> req.ingredient), (App)NamedCodec.longRange((long)0L, (long)Long.MAX_VALUE).optionalFieldOf("amount").forGetter(req -> Optional.of(req.amount)), (App)NamedCodec.enumCodec(IOType.class).fieldOf("mode").forGetter(IRequirement::getMode), (App)PositionedRequirement.POSITION_CODEC.optionalFieldOf("position", (Object)new PositionedRequirement(0, 0)).forGetter(IRequirement::getPosition)).apply((Applicative)instance, (item, amount, mode, position) -> new RequirementChemical((IOType)mode, (SingleChemicalIngredient)item, amount.orElse(1000L), (PositionedRequirement)position)), (String)"RequirementItem");
    public final ChemicalStack required;
    public final long amount;
    private final IOType mode;
    private final PositionedRequirement position;
    private final SingleChemicalIngredient ingredient;

    public RequirementChemical(IOType ioType, SingleChemicalIngredient chemical, long amount, PositionedRequirement position) {
        this.mode = ioType;
        this.ingredient = chemical;
        this.amount = amount;
        this.position = position;
        this.required = new ChemicalStack(chemical.chemical(), amount);
    }

    public RequirementType<RequirementChemical> getType() {
        return RequirementTypeRegistration.CHEMICAL.get();
    }

    public ComponentType getComponentType() {
        return ComponentRegistration.COMPONENT_CHEMICAL.get();
    }

    public boolean test(ChemicalComponent component, ICraftingContext context) {
        BasicChemicalTank handler = component.getContainerProvider();
        long amount = (int)context.getIntegerModifiedValue((float)this.amount, (IRequirement)this);
        return switch (this.getMode()) {
            default -> throw new MatchException(null, null);
            case IOType.INPUT -> {
                if (handler.isEmpty() || !handler.getStack().is(this.required.getChemical())) {
                    yield false;
                }
                ChemicalStack drained = handler.extract(amount, Action.SIMULATE, AutomationType.INTERNAL);
                if (drained.is(this.ingredient.chemical()) && drained.getAmount() == this.required.getAmount()) {
                    yield true;
                }
                yield false;
            }
            case IOType.OUTPUT -> {
                if (!handler.isEmpty() && !handler.getStack().is(this.required.getChemical())) {
                    yield false;
                }
                ChemicalStack filled = handler.insert(this.required.copyWithAmount(amount), Action.SIMULATE, AutomationType.INTERNAL);
                if (filled.getAmount() + amount == amount) {
                    yield true;
                }
                yield false;
            }
        };
    }

    public void gatherRequirements(IRequirementList<ChemicalComponent> list) {
        switch (this.getMode()) {
            case INPUT: {
                list.processOnStart(this::processInput);
                break;
            }
            case OUTPUT: {
                list.processOnEnd(this::processOutput);
            }
        }
    }

    private CraftingResult processInput(ChemicalComponent component, ICraftingContext context) {
        long amount = context.getIntegerModifiedValue((float)this.amount, (IRequirement)this);
        if (!this.required.is(component.getContainerProvider().getStack().getChemical())) {
            this.errorInput(amount, component.getContainerProvider().getStack(), component.getContainerProvider().getStored());
        }
        long toDrain = amount;
        long canDrain = component.getContainerProvider().getStored();
        if (canDrain > 0L) {
            canDrain = Math.min(canDrain, toDrain);
            component.getContainerProvider().extract(canDrain, Action.EXECUTE, AutomationType.INTERNAL);
            if ((toDrain -= canDrain) == 0L) {
                return CraftingResult.success();
            }
        }
        return this.errorInput(amount, component.getContainerProvider().getStack(), component.getContainerProvider().getStored());
    }

    private CraftingResult errorInput(long amount, ChemicalStack found, long amountFound) {
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.chemical.input", (Object[])new Object[]{Component.translatable((String)"%sx %s", (Object[])new Object[]{amount, this.required.getTextComponent()}), Component.translatable((String)"%sx %s", (Object[])new Object[]{amountFound, found.getTextComponent()})}));
    }

    private CraftingResult errorOutput(ChemicalStack found) {
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.chemical.output.chemical", (Object[])new Object[]{this.required.getTextComponent(), found.getTextComponent()}));
    }

    private CraftingResult errorOutput(long amount, long requiredSpace) {
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.chemical.output.space", (Object[])new Object[]{requiredSpace, amount}));
    }

    private CraftingResult processOutput(ChemicalComponent component, ICraftingContext context) {
        BasicChemicalTank handler = component.getContainerProvider();
        if (!handler.isEmpty() && !handler.getStack().is(this.required.getChemical())) {
            return this.errorOutput(handler.getStack());
        }
        long amount = context.getIntegerModifiedValue((float)this.amount, (IRequirement)this);
        long canFill = handler.getCapacity() - handler.getStored();
        if (canFill >= amount) {
            handler.insert(this.required.copyWithAmount(amount), Action.EXECUTE, AutomationType.INTERNAL);
            return CraftingResult.success();
        }
        return this.errorOutput(canFill, amount);
    }

    public JsonObject asJson() {
        JsonObject json = super.asJson();
        json.addProperty("chemical", this.required.getTextComponent().getString());
        json.addProperty("amount", (Number)this.amount);
        return json;
    }

    public RequirementChemical deepCopyModified(List<RecipeModifier> modifiers) {
        int amount = Math.round(RecipeModifier.applyModifiers(modifiers, this.getType(), (IOType)this.getMode(), (float)this.amount, (boolean)false));
        return new RequirementChemical(this.getMode(), new SingleChemicalIngredient(this.ingredient.chemical()), amount, this.getPosition());
    }

    public RequirementChemical deepCopy() {
        return new RequirementChemical(this.getMode(), new SingleChemicalIngredient(this.ingredient.chemical()), this.amount, this.getPosition());
    }

    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)String.format("component.missing.chemical.%s", ioType.name().toLowerCase()));
    }

    public boolean isComponentValid(ChemicalComponent m, ICraftingContext iCraftingContext) {
        if (this.getMode().isInput()) {
            if (m.getContainerProvider().isEmpty()) {
                return false;
            }
        } else if (m.getContainerProvider().isEmpty()) {
            return true;
        }
        return m.getContainerProvider().isTypeEqual(this.required);
    }

    @Generated
    public IOType getMode() {
        return this.mode;
    }

    @Generated
    public PositionedRequirement getPosition() {
        return this.position;
    }
}

