/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.mekanism.common.block.prop;

import es.degrassi.mmreborn.common.block.prop.ConfigLoaded;
import es.degrassi.mmreborn.mekanism.common.entity.base.ChemicalTankEntity;
import es.degrassi.mmreborn.mekanism.common.network.server.component.SUpdateChemicalComponentPacket;
import java.util.Locale;
import java.util.function.Predicate;
import lombok.Generated;
import mekanism.api.AutomationType;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.functions.ConstantPredicates;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public enum ChemicalHatchSize implements StringRepresentable,
ConfigLoaded
{
    TINY(100L),
    SMALL(400L),
    NORMAL(1000L),
    REINFORCED(2000L),
    BIG(4500L),
    HUGE(8000L),
    LUDICROUS(16000L),
    VACUUM(32000L);

    private long size;
    public final long defaultConfigurationValue;

    private ChemicalHatchSize(long defaultConfigurationValue) {
        this.defaultConfigurationValue = defaultConfigurationValue;
    }

    public static ChemicalHatchSize value(String value) {
        return switch (value.toUpperCase(Locale.ROOT)) {
            case "SMALL" -> SMALL;
            case "NORMAL" -> NORMAL;
            case "REINFORCED" -> REINFORCED;
            case "BIG" -> BIG;
            case "HUGE" -> HUGE;
            case "LUDICROUS" -> LUDICROUS;
            case "VACUUM" -> VACUUM;
            default -> TINY;
        };
    }

    public BasicChemicalTank buildTank(ChemicalTankEntity tileEntity, boolean canFill, boolean canDrain) {
        return (BasicChemicalTank)BasicChemicalTank.createModern((long)this.size, (chemical, automationType) -> canDrain || automationType == AutomationType.INTERNAL, (chemical, automationType) -> canFill || automationType == AutomationType.INTERNAL, (Predicate)ConstantPredicates.alwaysTrue(), (ChemicalAttributeValidator)ChemicalAttributeValidator.ALWAYS_ALLOW, () -> {
            Level patt0$temp = tileEntity.getLevel();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel l = (ServerLevel)patt0$temp;
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(tileEntity.getBlockPos()), (CustomPacketPayload)new SUpdateChemicalComponentPacket(tileEntity.getTank().getStack(), tileEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public void setSize(long size) {
        this.size = size;
    }
}

