/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.PositionedAddonsNetworkIngredientsFilter;
import org.cyclops.integrateddynamics.api.part.PartCapability;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integratedtunnels.Capabilities;
import org.cyclops.integratedtunnels.api.network.IItemNetwork;
import org.cyclops.integratedtunnels.core.TunnelHelpers;
import org.cyclops.integratedtunnels.core.part.PartStatePositionedAddon;

public class PartStateItem<P extends IPartTypeWriter>
extends PartStatePositionedAddon<P, IItemNetwork, ItemStack>
implements IItemHandler {
    public PartStateItem(int inventorySize, boolean canReceive, boolean canExtract) {
        super(inventorySize, canReceive, canExtract);
    }

    public <T> Optional<T> getCapability(P partType, PartCapability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        if (capability == Capabilities.ItemHandler.PART) {
            return Optional.of(this);
        }
        return super.getCapability(partType, capability, network, partNetwork, target);
    }

    protected IItemHandler getItemHandler() {
        return (IItemHandler)((IItemNetwork)this.getPositionedAddonsNetwork()).getChannelExternal(Capabilities.ItemHandler.BLOCK, TunnelHelpers.getPassiveInteractionChannel(this));
    }

    public int getSlots() {
        return this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null ? this.getItemHandler().getSlots() : 0;
    }

    public ItemStack getStackInSlot(int slot) {
        ItemStack ret;
        ItemStack itemStack = ret = this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null ? this.getItemHandler().getStackInSlot(slot) : ItemStack.EMPTY;
        if (!ret.isEmpty() && !this.getStorageFilter().testView((Object)ret)) {
            return ItemStack.EMPTY;
        }
        return ret;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.canReceive() && this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null) {
            if (!this.getStorageFilter().testInsertion((Object)stack)) {
                return stack;
            }
            return this.getItemHandler().insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.canExtract() && this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null) {
            ItemStack extractedSimulated;
            PositionedAddonsNetworkIngredientsFilter filter = this.getStorageFilter();
            if (!simulate && !filter.testExtraction((Object)(extractedSimulated = this.getItemHandler().extractItem(slot, amount, true)))) {
                return ItemStack.EMPTY;
            }
            ItemStack extracted = this.getItemHandler().extractItem(slot, amount, simulate);
            if (simulate && !filter.testExtraction((Object)extracted)) {
                return ItemStack.EMPTY;
            }
            return extracted;
        }
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return this.getPositionedAddonsNetwork() != null ? this.getItemHandler().getSlotLimit(slot) : 0;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null && this.getItemHandler().isItemValid(slot, stack) && !this.getStorageFilter().testInsertion((Object)stack);
    }
}

