/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.items;

import java.util.List;
import java.util.Optional;
import net.gigabit101.shrink.api.ShrinkAPI;
import net.gigabit101.shrink.init.ModItems;
import net.gigabit101.shrink.init.ShrinkComponentTypes;
import net.gigabit101.shrink.items.components.ShrinkComponentUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemShrinkBottle
extends Item {
    public ItemShrinkBottle() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        InteractionResult result = ItemShrinkBottle.onInteractWithEntity(stack, player, interactionTarget, usedHand);
        if (result.consumesAction()) {
            return result;
        }
        return super.interactLivingEntity(stack, player, interactionTarget, usedHand);
    }

    public static InteractionResult onInteractWithEntity(ItemStack stack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        if (ShrinkAPI.canCaptureEntity(livingEntity)) {
            ItemStack output = ItemShrinkBottle.setContainedEntity(new ItemStack(ModItems.SHRINK_BOTTLE), livingEntity);
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)output, (boolean)true));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        BlockPos blockPos = context.getClickedPos().relative(context.getClickedFace());
        if (!ItemShrinkBottle.containsEntity(stack)) {
            return super.useOn(context);
        }
        if (stack.isEmpty()) {
            return super.useOn(context);
        }
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        Optional<Entity> maybeEntity = ShrinkComponentUtils.getEntityType(stack).map(type -> type.spawn(serverWorld, stack, player, blockPos, MobSpawnType.MOB_SUMMONED, false, false));
        if (maybeEntity.isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (player != null) {
            ItemStack handStack = ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE), (boolean)true);
            player.setItemInHand(hand, handStack);
        } else {
            stack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    public static ItemStack setContainedEntity(ItemStack emptyBottle, LivingEntity entity) {
        if (ItemShrinkBottle.containsEntity(emptyBottle)) {
            return emptyBottle;
        }
        if (entity.level().isClientSide()) {
            return emptyBottle;
        }
        if (entity instanceof Player || !entity.isAlive() || !entity.getType().canSerialize()) {
            return emptyBottle;
        }
        CompoundTag entityNbt = new CompoundTag();
        if (!entity.save(entityNbt)) {
            return emptyBottle;
        }
        ShrinkComponentUtils.stripTag(entityNbt);
        ItemStack mobBottle = new ItemStack((ItemLike)ModItems.SHRINK_BOTTLE.get(), 1);
        mobBottle.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)entityNbt));
        if (entity.hasCustomName() && entity.isCustomNameVisible()) {
            mobBottle.set((DataComponentType)ShrinkComponentTypes.ENTITY_NAME.get(), (Object)entity.getCustomName());
        } else {
            mobBottle.remove((DataComponentType)ShrinkComponentTypes.ENTITY_NAME.get());
        }
        entity.remove(Entity.RemovalReason.KILLED);
        return mobBottle;
    }

    public static boolean containsEntity(ItemStack stack) {
        return ((CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).contains("id");
    }

    public boolean isFoil(@NotNull ItemStack itemStack) {
        return ItemShrinkBottle.containsEntity(itemStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, tooltipContext, list, tooltipFlag);
        if (ItemShrinkBottle.containsEntity(stack)) {
            Component entityTypeName = ShrinkComponentUtils.getEntityType(stack).map(EntityType::getDescription).orElseGet(Component::empty);
            Component name = (Component)stack.get((DataComponentType)ShrinkComponentTypes.ENTITY_NAME.get());
            if (name != null) {
                list.add((Component)Component.translatable((String)"item.mob_bottle.tooltip_with_name", (Object[])new Object[]{name, entityTypeName}));
            } else {
                list.add((Component)Component.translatable((String)"item.mob_bottle.tooltip", (Object[])new Object[]{entityTypeName}));
            }
        } else {
            list.add((Component)Component.translatable((String)"item.mob_bottle.tooltip_empty"));
        }
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        ShrinkComponentUtils.convertLegacyDataComponent(stack);
        CustomData data = (CustomData)stack.get(DataComponents.ENTITY_DATA);
        if (data != null && !data.contains("id")) {
            stack.remove(DataComponents.ENTITY_DATA);
        }
        Component name = (Component)stack.get((DataComponentType)ShrinkComponentTypes.ENTITY_NAME.get());
        if (!stack.has(DataComponents.ENTITY_DATA) || name != null && name.getString().isBlank()) {
            stack.remove((DataComponentType)ShrinkComponentTypes.ENTITY_NAME.get());
        }
    }
}

