/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.gui;

import com.flanks255.simplylight.SimplyLight;
import com.flanks255.simplylight.network.UpdateEdgeLightPacket;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class EdgeEditorGUI
extends Screen {
    private static final ResourceLocation BG = SimplyLight.SLRes("textures/gui/small_editor.png");
    private final BlockPos target;
    private byte state;
    private int guiLeft;
    private int guiTop;
    private final int xSize = 128;
    private final int ySize = 70;
    private SwitchButton north;
    private SwitchButton east;
    private SwitchButton south;
    private SwitchButton west;

    public EdgeEditorGUI(BlockPos target, byte initialState) {
        super((Component)Component.literal((String)"Edge Editor"));
        this.target = target;
        this.state = initialState;
    }

    protected void init() {
        super.init();
        this.guiLeft = (int)((float)this.width / 2.0f - 192.0f);
        this.guiTop = (this.height - 70) / 2;
        this.north = (SwitchButton)this.addRenderableWidget((GuiEventListener)new SwitchButton(this.guiLeft + 4, this.guiTop + 3, (Component)Component.translatable((String)"simplylight.gui.north"), (this.state & 1) != 0, this::button));
        this.east = (SwitchButton)this.addRenderableWidget((GuiEventListener)new SwitchButton(this.guiLeft + 4, this.guiTop + 3 + 16, (Component)Component.translatable((String)"simplylight.gui.east"), (this.state & 2) != 0, this::button));
        this.south = (SwitchButton)this.addRenderableWidget((GuiEventListener)new SwitchButton(this.guiLeft + 4, this.guiTop + 3 + 32, (Component)Component.translatable((String)"simplylight.gui.south"), (this.state & 4) != 0, this::button));
        this.west = (SwitchButton)this.addRenderableWidget((GuiEventListener)new SwitchButton(this.guiLeft + 4, this.guiTop + 3 + 48, (Component)Component.translatable((String)"simplylight.gui.west"), (this.state & 8) != 0, this::button));
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"simplylight.gui.exit"), $ -> this.onClose()).pos(this.guiLeft + 92, this.guiTop + 50).size(32, 16).build());
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        MutableComponent facing = Component.translatable((String)"simplylight.gui.facing");
        Component direction = this.getDirectionText(this.getNearestHorizontal((Player)player));
        int x = this.guiLeft + 128 - 4 - Math.max(this.font.width((FormattedText)facing), this.font.width((FormattedText)direction));
        guiGraphics.drawString(this.font, (Component)facing, x, this.guiTop + 8, 0x404040, false);
        guiGraphics.drawString(this.font, direction, x, this.guiTop + 18, 0x404040, false);
    }

    private Direction getNearestHorizontal(Player player) {
        for (Direction direction : Direction.orderedByNearest((Entity)player)) {
            if (!direction.getAxis().isHorizontal()) continue;
            return direction;
        }
        return Direction.NORTH;
    }

    private Component getDirectionText(Direction direction) {
        return switch (direction) {
            case Direction.EAST -> Component.translatable((String)"simplylight.gui.east");
            case Direction.SOUTH -> Component.translatable((String)"simplylight.gui.south");
            case Direction.WEST -> Component.translatable((String)"simplylight.gui.west");
            default -> Component.translatable((String)"simplylight.gui.north");
        };
    }

    private void button(Button button) {
        if (button instanceof SwitchButton) {
            SwitchButton btn = (SwitchButton)button;
            btn.state = !btn.state;
        }
        this.state = (byte)((this.north.state ? 1 : 0) | (this.east.state ? 2 : 0) | (this.south.state ? 4 : 0) | (this.west.state ? 8 : 0));
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateEdgeLightPacket(this.target, this.state), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blit(BG, this.guiLeft, this.guiTop, 0.0f, 0.0f, 128, 70, 128, 70);
    }

    class SwitchButton
    extends Button {
        private static final ResourceLocation SWITCH = SimplyLight.SLRes("textures/gui/switch.png");
        public boolean state;
        private final Component textKey;

        public SwitchButton(int x, int y, Component text, boolean initial, Button.OnPress pressable) {
            super(x, y, 32, 16, text, pressable, Button.DEFAULT_NARRATION);
            this.textKey = text;
            this.state = initial;
        }

        public void renderWidget(@Nonnull GuiGraphics gg, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            gg.blit(SWITCH, this.getX(), this.getY(), this.width, this.height, 0.0f, this.state ? 16.0f : 0.0f, 32, 16, 32, 32);
            gg.drawString(EdgeEditorGUI.this.font, this.textKey, this.getX() + 34, this.getY() + 4, 0x404040, false);
        }
    }
}

