/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.transfer_labels.filter;

import com.buuz135.transfer_labels.client.TLAssetTypes;
import com.buuz135.transfer_labels.filter.FilterType;
import com.buuz135.transfer_labels.filter.ILabelFilter;
import com.buuz135.transfer_labels.filter.extras.NumberFilterExtra;
import com.buuz135.transfer_labels.filter.extras.TagFilterExtra;
import com.buuz135.transfer_labels.gui.ScrollableScreenAddon;
import com.buuz135.transfer_labels.gui.ScrollableSelectionHelper;
import com.buuz135.transfer_labels.gui.WhitelistStateButtonAddon;
import com.buuz135.transfer_labels.gui.filter.ItemFilterScreenAddon;
import com.buuz135.transfer_labels.item.TransferLabelItem;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.filter.FilterSlot;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ItemFilter
implements ILabelFilter<ItemStack> {
    private final FilterSlot<ItemStack>[] filter;
    private ILabelFilter.Type type;
    private int pointer;
    private final String name;
    private final HashMap<String, INBTSerializable<CompoundTag>> savedFilters;
    private FilterType filterType;
    private ButtonComponent toggleFilterModeButton;
    private TransferLabelItem.Mode mode;

    public ItemFilter(String name, int filterSize, TransferLabelItem.Mode mode) {
        this.name = name;
        this.filter = new FilterSlot[filterSize];
        this.mode = mode;
        this.type = ILabelFilter.Type.BLACKLIST;
        this.pointer = 0;
        this.filterType = FilterType.NORMAL;
        this.savedFilters = new HashMap();
        this.savedFilters.put(FilterType.REGULATING.getName(), new NumberFilterExtra(filterSize));
        this.savedFilters.put(FilterType.EXACT_COUNT.getName(), new NumberFilterExtra(filterSize));
        this.savedFilters.put(FilterType.TAG.getName(), new TagFilterExtra(filterSize));
        this.toggleFilterModeButton = new ButtonComponent(13, 64, 18, 18);
        this.toggleFilterModeButton.setId(54571);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean acceptsAsFilter(ItemStack filter) {
        return true;
    }

    @Override
    public void setFilter(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.filter.length) {
            throw new RuntimeException("Filter slot " + slot + " not in valid range - [0," + this.filter.length + ")");
        }
        this.filter[slot].setFilter((Object)stack);
        NumberFilterExtra numberFilterExtra = (NumberFilterExtra)this.savedFilters.get(FilterType.EXACT_COUNT.getName());
        numberFilterExtra.getExtra().set(slot, stack.getCount());
        numberFilterExtra = (NumberFilterExtra)this.savedFilters.get(FilterType.REGULATING.getName());
        numberFilterExtra.getExtra().set(slot, stack.getCount());
        TagFilterExtra extra = (TagFilterExtra)this.savedFilters.get(FilterType.TAG.getName());
        extra.initTag(slot, stack);
    }

    @Override
    public void setFilter(int slot, FilterSlot<ItemStack> filterSlot) {
        if (slot < 0 || slot >= this.filter.length) {
            throw new RuntimeException("Filter slot " + slot + " not in valid range - [0," + this.filter.length + ")");
        }
        this.filter[slot] = filterSlot;
    }

    @Override
    public FilterSlot<ItemStack>[] getFilterSlots() {
        return this.filter;
    }

    @Override
    public ILabelFilter.Type getType() {
        return this.type;
    }

    @Override
    public void toggleFilterMode() {
        this.type = this.type.equals((Object)ILabelFilter.Type.WHITELIST) ? ILabelFilter.Type.BLACKLIST : ILabelFilter.Type.WHITELIST;
    }

    @Override
    public void handleButtonMessage(int i, Player player, CompoundTag compoundTag) {
        if (compoundTag.contains("Scrollable_Name") && compoundTag.getString("Scrollable_Name").equals("filter_selector")) {
            double scroll = compoundTag.getDouble("Scroll");
            if (scroll > 0.0) {
                this.filterType = FilterType.getPrevious(this.filterType.getName());
            } else if (scroll < 0.0) {
                this.filterType = FilterType.getNext(this.filterType.getName());
            }
        }
        if (compoundTag.contains("FilterAmount")) {
            int slot = compoundTag.getInt("FilterAmount");
            int amount = compoundTag.getInt("Scroll");
            if (this.filterType == FilterType.EXACT_COUNT || this.filterType == FilterType.REGULATING) {
                NumberFilterExtra numberFilterExtra = (NumberFilterExtra)this.savedFilters.get(this.filterType.getName());
                numberFilterExtra.add(slot, amount);
            }
        }
        if (compoundTag.contains("FilterTag")) {
            int slot = compoundTag.getInt("FilterTag");
            int scroll = compoundTag.getInt("Scroll");
            if (this.filterType == FilterType.TAG) {
                TagFilterExtra tagFilterExtra = (TagFilterExtra)this.savedFilters.get(this.filterType.getName());
                if (scroll > 0) {
                    tagFilterExtra.previousTag(slot, (ItemStack)this.filter[slot].getFilter());
                } else if (scroll < 0) {
                    tagFilterExtra.nextTag(slot, (ItemStack)this.filter[slot].getFilter());
                }
            }
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.putInt("Pointer", this.pointer);
        CompoundTag filter = new CompoundTag();
        for (FilterSlot<ItemStack> itemStackFilterSlot : this.filter) {
            if (itemStackFilterSlot == null) continue;
            filter.put("" + itemStackFilterSlot.getFilterID(), ((ItemStack)itemStackFilterSlot.getFilter()).saveOptional(provider));
        }
        compoundNBT.put("Filter", (Tag)filter);
        compoundNBT.putString("Type", this.type.name());
        compoundNBT.putString("FilterType", this.filterType.getName());
        CompoundTag savedFiltersNBT = new CompoundTag();
        this.savedFilters.forEach((key, value) -> savedFiltersNBT.put(key, value.serializeNBT(provider)));
        compoundNBT.put("SavedFilters", (Tag)savedFiltersNBT);
        return compoundNBT;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.pointer = nbt.getInt("Pointer");
        CompoundTag filter = nbt.getCompound("Filter");
        for (FilterSlot<ItemStack> filterSlot : this.filter) {
            filterSlot.setFilter((Object)ItemStack.EMPTY);
        }
        for (String key2 : filter.getAllKeys()) {
            this.filter[Integer.parseInt(key2)].setFilter((Object)ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)filter.getCompound(key2)));
        }
        this.type = ILabelFilter.Type.valueOf(nbt.getString("Type"));
        this.filterType = FilterType.getByName(nbt.getString("FilterType"));
        CompoundTag savedFiltersNBT = nbt.getCompound("SavedFilters");
        this.savedFilters.forEach((key, value) -> value.deserializeNBT(provider, (Tag)savedFiltersNBT.getCompound(key)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> list = new ArrayList<IFactory<? extends IScreenAddon>>();
        list.add(() -> new ItemFilterScreenAddon(this));
        list.add(() -> {
            ArrayList<String> lines = new ArrayList<String>();
            FilterType.FILTERS.forEach(filterType1 -> lines.addAll(filterType1.getTooltip()));
            lines.add(Component.translatable((String)"filter.type.scroll").withStyle(ChatFormatting.DARK_GRAY).getString());
            return new ScrollableScreenAddon(13, 28, new ScrollableSelectionHelper("filter_selector", -7, lines, () -> Component.translatable((String)this.filterType.getDisplayName()).getString(), false), () -> {
                switch (this.filterType.getName()) {
                    case "normal": {
                        return TLAssetTypes.FILTER_NORMAL;
                    }
                    case "regulating": {
                        return TLAssetTypes.FILTER_REGULATING;
                    }
                    case "exact_count": {
                        return TLAssetTypes.FILTER_EXACT_COUNT;
                    }
                    case "mod": {
                        return TLAssetTypes.FILTER_MOD;
                    }
                    case "tag": {
                        return TLAssetTypes.FILTER_TAG;
                    }
                }
                return AssetTypes.BUTTON_LOCKED;
            });
        });
        list.add(() -> new WhitelistStateButtonAddon(this.toggleFilterModeButton, new StateButtonInfo[]{new StateButtonInfo(0, TLAssetTypes.WHITELIST_BUTTON, new String[]{"tooltip.transfer_labels.whitelist"}), new StateButtonInfo(1, TLAssetTypes.BLACKLIST_BUTTON, new String[]{"tooltip.transfer_labels.blacklist"})}){

            public int getState() {
                return ItemFilter.this.type.equals((Object)ILabelFilter.Type.WHITELIST) ? 0 : 1;
            }
        });
        return list;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public HashMap<String, INBTSerializable<CompoundTag>> getSavedFilters() {
        return this.savedFilters;
    }

    public void onContentChanged() {
    }

    @Override
    public void work(Level level, BlockPos pos, Direction direction, int amount) {
        Direction oppositeDirection = direction.getOpposite();
        BlockPos oppositePos = pos.relative(direction);
        if (!level.isLoaded(pos) || !level.isLoaded(oppositePos)) {
            return;
        }
        IItemHandler sourceHandler = null;
        IItemHandler targetHandler = null;
        if (this.mode == TransferLabelItem.Mode.EXTRACT) {
            targetHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, oppositePos, (Object)oppositeDirection);
            sourceHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)direction);
        } else {
            sourceHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, oppositePos, (Object)oppositeDirection);
            targetHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)direction);
        }
        if (sourceHandler == null || targetHandler == null) {
            return;
        }
        this.transferItems(sourceHandler, targetHandler, amount);
    }

    private void transferItems(IItemHandler sourceHandler, IItemHandler targetHandler, int defaultMaxAmount) {
        for (int sourceSlot = 0; sourceSlot < sourceHandler.getSlots(); ++sourceSlot) {
            int amountToExtract;
            ItemStack simulatedResult;
            int maxAmount = defaultMaxAmount;
            ItemStack sourceStack = sourceHandler.extractItem(sourceSlot, maxAmount, true);
            if (sourceStack.isEmpty() || !this.passesFilter(sourceStack) || (maxAmount = this.calculateMaxTransferAmount(sourceStack, sourceHandler, targetHandler, sourceSlot, defaultMaxAmount)) <= 0) continue;
            if (this.filterType == FilterType.EXACT_COUNT) {
                int exactAmount = 0;
                for (FilterSlot<ItemStack> filterSlot : this.filter) {
                    if (filterSlot == null || ((ItemStack)filterSlot.getFilter()).isEmpty() || !ItemStack.isSameItem((ItemStack)sourceStack, (ItemStack)((ItemStack)filterSlot.getFilter()))) continue;
                    NumberFilterExtra numberFilterExtra = (NumberFilterExtra)this.savedFilters.get(FilterType.EXACT_COUNT.getName());
                    exactAmount = numberFilterExtra.getExtra().get(filterSlot.getFilterID());
                    break;
                }
                if (sourceStack.getCount() < exactAmount) {
                    this.handleExactCountMultiSlotTransfer(sourceHandler, targetHandler, sourceStack, sourceSlot, exactAmount);
                    return;
                }
            }
            if (!(simulatedResult = ItemHandlerHelper.insertItem((IItemHandler)targetHandler, (ItemStack)(sourceStack = sourceHandler.extractItem(sourceSlot, maxAmount, true)).copy(), (boolean)true)).isEmpty() && this.filterType == FilterType.EXACT_COUNT || (amountToExtract = sourceStack.getCount() - simulatedResult.getCount()) <= 0) continue;
            sourceHandler.extractItem(sourceSlot, amountToExtract, false);
            ItemHandlerHelper.insertItem((IItemHandler)targetHandler, (ItemStack)sourceStack.copy().split(amountToExtract), (boolean)false);
            break;
        }
    }

    private int calculateMaxTransferAmount(ItemStack sourceStack, IItemHandler sourceHandler, IItemHandler targetHandler, int sourceSlot, int defaultMaxAmount) {
        int maxAmount;
        block6: {
            block7: {
                maxAmount = defaultMaxAmount;
                if (this.filterType != FilterType.REGULATING) break block7;
                for (FilterSlot<ItemStack> filterSlot : this.filter) {
                    if (filterSlot == null || ((ItemStack)filterSlot.getFilter()).isEmpty() || !ItemStack.isSameItem((ItemStack)sourceStack, (ItemStack)((ItemStack)filterSlot.getFilter()))) continue;
                    int currentCount = 0;
                    for (int targetSlot = 0; targetSlot < targetHandler.getSlots(); ++targetSlot) {
                        ItemStack targetStack = targetHandler.getStackInSlot(targetSlot);
                        if (targetStack.isEmpty() || !ItemStack.isSameItem((ItemStack)targetStack, (ItemStack)((ItemStack)filterSlot.getFilter()))) continue;
                        currentCount += targetStack.getCount();
                    }
                    NumberFilterExtra numberFilterExtra = (NumberFilterExtra)this.savedFilters.get(FilterType.REGULATING.getName());
                    int desiredAmount = numberFilterExtra.getExtra().get(filterSlot.getFilterID());
                    int neededAmount = Math.max(0, desiredAmount - currentCount);
                    maxAmount = Math.min(neededAmount, 4);
                    break block6;
                }
                break block6;
            }
            if (this.filterType != FilterType.EXACT_COUNT) break block6;
            for (FilterSlot<ItemStack> filterSlot : this.filter) {
                ItemStack otherStack;
                if (filterSlot == null || ((ItemStack)filterSlot.getFilter()).isEmpty() || !ItemStack.isSameItem((ItemStack)sourceStack, (ItemStack)((ItemStack)filterSlot.getFilter()))) continue;
                NumberFilterExtra numberFilterExtra = (NumberFilterExtra)this.savedFilters.get(FilterType.EXACT_COUNT.getName());
                int exactAmount = numberFilterExtra.getExtra().get(filterSlot.getFilterID());
                if (exactAmount > defaultMaxAmount) {
                    maxAmount = 0;
                    break;
                }
                if (sourceStack.getCount() >= exactAmount) {
                    maxAmount = exactAmount;
                    break;
                }
                if (sourceStack.getCount() >= exactAmount) break;
                int availableAmount = sourceStack.getCount();
                for (int otherSlot = 0; otherSlot < sourceHandler.getSlots() && (otherSlot == sourceSlot || (otherStack = sourceHandler.getStackInSlot(otherSlot)).isEmpty() || !ItemStack.isSameItem((ItemStack)otherStack, (ItemStack)sourceStack) || (availableAmount += otherStack.getCount()) < exactAmount); ++otherSlot) {
                }
                maxAmount = availableAmount >= exactAmount ? exactAmount : 0;
                break;
            }
        }
        return maxAmount;
    }

    private boolean handleExactCountMultiSlotTransfer(IItemHandler sourceHandler, IItemHandler targetHandler, ItemStack sourceStack, int sourceSlot, int exactAmount) {
        ItemStack combinedStack = sourceStack.copy();
        int remainingNeeded = exactAmount - combinedStack.getCount();
        HashMap<Integer, Integer> extractionPlan = new HashMap<Integer, Integer>();
        extractionPlan.put(sourceSlot, combinedStack.getCount());
        for (int otherSlot = 0; otherSlot < sourceHandler.getSlots() && remainingNeeded > 0; ++otherSlot) {
            ItemStack otherStack;
            if (otherSlot == sourceSlot || (otherStack = sourceHandler.getStackInSlot(otherSlot)).isEmpty() || !ItemStack.isSameItem((ItemStack)otherStack, (ItemStack)combinedStack)) continue;
            int toExtract = Math.min(remainingNeeded, otherStack.getCount());
            extractionPlan.put(otherSlot, toExtract);
            remainingNeeded -= toExtract;
        }
        if (remainingNeeded > 0) {
            return false;
        }
        combinedStack.setCount(exactAmount);
        ItemStack simulatedResult = ItemHandlerHelper.insertItem((IItemHandler)targetHandler, (ItemStack)combinedStack.copy(), (boolean)true);
        if (!simulatedResult.isEmpty()) {
            return false;
        }
        combinedStack = ItemStack.EMPTY;
        for (Map.Entry entry : extractionPlan.entrySet()) {
            int slot = (Integer)entry.getKey();
            int amount = (Integer)entry.getValue();
            ItemStack extracted = sourceHandler.extractItem(slot, amount, false);
            if (combinedStack.isEmpty()) {
                combinedStack = extracted;
                continue;
            }
            combinedStack.grow(extracted.getCount());
        }
        combinedStack.setCount(exactAmount);
        ItemHandlerHelper.insertItem((IItemHandler)targetHandler, (ItemStack)combinedStack, (boolean)false);
        return true;
    }

    private boolean passesFilter(ItemStack stack) {
        if (this.filter.length == 0) {
            return true;
        }
        boolean matches = false;
        for (FilterSlot<ItemStack> filterSlot : this.filter) {
            TagFilterExtra tagFilterExtra;
            TagKey<Item> tagKey;
            if (filterSlot == null || ((ItemStack)filterSlot.getFilter()).isEmpty()) continue;
            boolean itemMatches = false;
            if (this.filterType == FilterType.NORMAL) {
                itemMatches = ItemStack.isSameItem((ItemStack)stack, (ItemStack)((ItemStack)filterSlot.getFilter()));
            } else if (this.filterType == FilterType.REGULATING) {
                itemMatches = ItemStack.isSameItem((ItemStack)stack, (ItemStack)((ItemStack)filterSlot.getFilter()));
            } else if (this.filterType == FilterType.EXACT_COUNT) {
                itemMatches = ItemStack.isSameItem((ItemStack)stack, (ItemStack)((ItemStack)filterSlot.getFilter()));
            } else if (this.filterType == FilterType.MOD) {
                String stackModId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace();
                String filterModId = BuiltInRegistries.ITEM.getKey((Object)((ItemStack)filterSlot.getFilter()).getItem()).getNamespace();
                itemMatches = stackModId.equals(filterModId);
            } else if (this.filterType == FilterType.TAG && (tagKey = (tagFilterExtra = (TagFilterExtra)this.savedFilters.get(FilterType.TAG.getName())).getExtra().get(filterSlot.getFilterID())) != null) {
                itemMatches = stack.is(tagKey);
            }
            if (!itemMatches) continue;
            matches = true;
            break;
        }
        return this.type.getFilter().test(matches);
    }
}

