/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items.armor;

import alexthw.ars_elemental.common.items.armor.ElementalArmor;
import alexthw.ars_elemental.common.items.armor.HeavyArmorE;
import alexthw.ars_elemental.common.items.armor.LightArmorE;
import alexthw.ars_elemental.common.items.armor.MediumArmorE;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import java.util.Map;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;

public abstract class ArmorSet {
    public static final Map<SpellSchool, SpellSchool> weaknessMap = Map.of(SpellSchools.ELEMENTAL_FIRE, SpellSchools.ELEMENTAL_WATER, SpellSchools.ELEMENTAL_WATER, SpellSchools.ELEMENTAL_EARTH, SpellSchools.ELEMENTAL_EARTH, SpellSchools.ELEMENTAL_AIR, SpellSchools.ELEMENTAL_AIR, SpellSchools.ELEMENTAL_FIRE);
    public static final Map<SpellSchool, SpellSchool> resistanceMap = Map.of(SpellSchools.ELEMENTAL_WATER, SpellSchools.ELEMENTAL_FIRE, SpellSchools.ELEMENTAL_EARTH, SpellSchools.ELEMENTAL_WATER, SpellSchools.ELEMENTAL_AIR, SpellSchools.ELEMENTAL_EARTH, SpellSchools.ELEMENTAL_FIRE, SpellSchools.ELEMENTAL_AIR);
    protected String name;
    protected DeferredHolder<Item, ElementalArmor> head;
    protected DeferredHolder<Item, ElementalArmor> chest;
    protected DeferredHolder<Item, ElementalArmor> legs;
    protected DeferredHolder<Item, ElementalArmor> feet;

    public String getName() {
        return this.name;
    }

    public Item getHat() {
        return (Item)this.head.get();
    }

    public Item getChest() {
        return (Item)this.chest.get();
    }

    public Item getLegs() {
        return (Item)this.legs.get();
    }

    public Item getBoots() {
        return (Item)this.feet.get();
    }

    public Item getArmorFromSlot(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.CHEST -> this.getChest();
            case EquipmentSlot.LEGS -> this.getLegs();
            case EquipmentSlot.FEET -> this.getBoots();
            default -> this.getHat();
        };
    }

    public String getTranslationKey() {
        return "ars_elemental.armor_set." + this.name;
    }

    public static class Heavy
    extends ArmorSet {
        public Heavy(String name, SpellSchool element) {
            this.name = name;
            this.head = ModItems.ITEMS.register(name + "_helmet", () -> new HeavyArmorE(ArmorItem.Type.HELMET, element, ModItems.ArmorProp()));
            this.chest = ModItems.ITEMS.register(name + "_chestplate", () -> new HeavyArmorE(ArmorItem.Type.CHESTPLATE, element, ModItems.ArmorProp()));
            this.legs = ModItems.ITEMS.register(name + "_leggings_heavy", () -> new HeavyArmorE(ArmorItem.Type.LEGGINGS, element, ModItems.ArmorProp()));
            this.feet = ModItems.ITEMS.register(name + "_boots_heavy", () -> new HeavyArmorE(ArmorItem.Type.BOOTS, element, ModItems.ArmorProp()));
        }

        @Override
        public String getTranslationKey() {
            return super.getTranslationKey() + "_heavy";
        }
    }

    public static class Medium
    extends ArmorSet {
        public Medium(String name, SpellSchool element) {
            this.name = name;
            this.head = ModItems.ITEMS.register(name + "_hat", () -> new MediumArmorE(ArmorItem.Type.HELMET, element, ModItems.ArmorProp()));
            this.chest = ModItems.ITEMS.register(name + "_robes", () -> new MediumArmorE(ArmorItem.Type.CHESTPLATE, element, ModItems.ArmorProp()));
            this.legs = ModItems.ITEMS.register(name + "_leggings", () -> new MediumArmorE(ArmorItem.Type.LEGGINGS, element, ModItems.ArmorProp()));
            this.feet = ModItems.ITEMS.register(name + "_boots", () -> new MediumArmorE(ArmorItem.Type.BOOTS, element, ModItems.ArmorProp()));
        }
    }

    public static class Light
    extends ArmorSet {
        public Light(String name, SpellSchool element) {
            this.name = name;
            this.head = ModItems.ITEMS.register(name + "_hood", () -> new LightArmorE(ArmorItem.Type.HELMET, element, ModItems.ArmorProp()));
            this.chest = ModItems.ITEMS.register(name + "_tunic", () -> new LightArmorE(ArmorItem.Type.CHESTPLATE, element, ModItems.ArmorProp()));
            this.legs = ModItems.ITEMS.register(name + "_pants", () -> new LightArmorE(ArmorItem.Type.LEGGINGS, element, ModItems.ArmorProp()));
            this.feet = ModItems.ITEMS.register(name + "_shoes", () -> new LightArmorE(ArmorItem.Type.BOOTS, element, ModItems.ArmorProp()));
        }

        @Override
        public String getTranslationKey() {
            return super.getTranslationKey() + "_light";
        }
    }
}

