/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.dispenser;

import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;

public class ShearsDispenseItemBehavior
extends OptionalDispenseItemBehavior {
    protected ItemStack execute(BlockSource pBlockSource, ItemStack stack) {
        BlockPos blockpos;
        ServerLevel level = pBlockSource.level();
        this.setSuccess(ShearsDispenseItemBehavior.tryShearBeehive((Level)level, blockpos = pBlockSource.pos().relative((Direction)pBlockSource.state().getValue((Property)DispenserBlock.FACING))) || ShearsDispenseItemBehavior.tryShearLivingEntity((Level)level, blockpos));
        if (this.isSuccess()) {
            stack.hurtAndBreak(1, level, null, item -> stack.setCount(0));
        }
        return stack;
    }

    private static boolean tryShearBeehive(Level level, BlockPos pos) {
        int i;
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.is(BlockTags.BEEHIVES) && (i = ((Integer)blockstate.getValue((Property)BeehiveBlock.HONEY_LEVEL)).intValue()) >= 5) {
            level.playSound(null, pos, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            BeehiveBlock.dropHoneycomb((Level)level, (BlockPos)pos);
            Block block = blockstate.getBlock();
            if (block instanceof BeehiveBlock) {
                BeehiveBlock beehiveBlock = (BeehiveBlock)block;
                beehiveBlock.releaseBeesAndResetHoneyLevel(level, blockstate, pos, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
            } else {
                block = blockstate.getBlock();
                if (block instanceof AdvancedBeehive) {
                    AdvancedBeehive beehiveBlock = (AdvancedBeehive)block;
                    level.setBlockAndUpdate(pos, (BlockState)blockstate.setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(beehiveBlock.getMaxHoneyLevel() - 5)));
                }
            }
            level.gameEvent(null, (Holder)GameEvent.SHEAR, pos);
            return true;
        }
        return false;
    }

    private static boolean tryShearLivingEntity(Level level, BlockPos pos) {
        for (LivingEntity livingentity : level.getEntitiesOfClass(LivingEntity.class, new AABB(pos), EntitySelector.NO_SPECTATORS)) {
            Shearable shearable;
            if (!(livingentity instanceof Shearable) || !(shearable = (Shearable)livingentity).readyForShearing()) continue;
            shearable.shear(SoundSource.BLOCKS);
            level.gameEvent(null, (Holder)GameEvent.SHEAR, pos);
            return true;
        }
        return false;
    }
}

