/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class HoneyTreatGeneRecipe
implements CraftingRecipe {
    public final ItemStack honeyTreat;

    public HoneyTreatGeneRecipe(ItemStack honeyTreat) {
        this.honeyTreat = honeyTreat;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        HashMap<GeneAttribute, String> addedGenes = new HashMap<GeneAttribute, String>();
        ItemStack honeyTreatStack = null;
        boolean hasAddedGenes = false;
        boolean hasTypeGene = false;
        for (int j = 0; j < inv.size(); ++j) {
            ItemStack itemstack = inv.getItem(j);
            if (itemstack.isEmpty()) continue;
            if (itemstack.getItem().equals(ModItems.HONEY_TREAT.get()) && honeyTreatStack == null) {
                honeyTreatStack = itemstack;
                List<GeneGroup> genes = HoneyTreat.getGenes(honeyTreatStack);
                for (GeneGroup GeneGroup2 : genes) {
                    GeneAttribute attribute = GeneGroup2.attribute();
                    if (addedGenes.containsKey((Object)attribute) && !((String)addedGenes.get((Object)attribute)).equals(GeneGroup2.value())) {
                        return false;
                    }
                    addedGenes.put(attribute, GeneGroup2.value());
                    if (!attribute.equals((Object)GeneAttribute.TYPE)) continue;
                    hasTypeGene = true;
                }
                continue;
            }
            if (itemstack.getItem().equals(ModItems.GENE.get())) {
                GeneAttribute attribute = Gene.getAttribute(itemstack);
                if (attribute.equals((Object)GeneAttribute.TYPE)) {
                    if (addedGenes.size() > 0 && !addedGenes.containsKey((Object)attribute)) {
                        return false;
                    }
                    addedGenes.put(attribute, Gene.getValue(itemstack));
                    hasAddedGenes = true;
                    hasTypeGene = true;
                    continue;
                }
                if (!hasTypeGene) {
                    if (addedGenes.containsKey((Object)attribute) && !((String)addedGenes.get((Object)attribute)).equals(Gene.getValue(itemstack))) {
                        return false;
                    }
                    addedGenes.put(attribute, Gene.getValue(itemstack));
                    hasAddedGenes = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        if (honeyTreatStack == null) {
            return false;
        }
        return hasAddedGenes;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        ItemStack treat = null;
        ArrayList<ItemStack> genes = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.size(); ++j) {
            ItemStack itemstack = inv.getItem(j);
            if (itemstack.isEmpty()) continue;
            if (itemstack.getItem().equals(ModItems.HONEY_TREAT.get())) {
                treat = itemstack;
                continue;
            }
            if (!itemstack.getItem().equals(ModItems.GENE.get())) continue;
            genes.add(itemstack);
        }
        if (treat != null) {
            ItemStack honeyTreat = treat.copy();
            genes.forEach(gene -> HoneyTreat.addGene(honeyTreat, gene));
            honeyTreat.setCount(1);
            return honeyTreat;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.honeyTreat;
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{this.honeyTreat.copy()}));
        list.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.GENE.get())}));
        return list;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.GENE_TREAT.get();
    }

    public static class Serializer
    implements RecipeSerializer<HoneyTreatGeneRecipe> {
        private static final MapCodec<HoneyTreatGeneRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.CODEC.fieldOf("item").orElse((Object)new ItemStack((ItemLike)ModItems.HONEY_TREAT.get())).forGetter(recipe -> recipe.honeyTreat)).apply((Applicative)builder, HoneyTreatGeneRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, HoneyTreatGeneRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<HoneyTreatGeneRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, HoneyTreatGeneRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static HoneyTreatGeneRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                return new HoneyTreatGeneRecipe((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer));
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading honey treat gene recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, HoneyTreatGeneRecipe recipe) {
            try {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.honeyTreat);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing honey treat gene recipe to packet. ", (Throwable)e);
                throw e;
            }
        }
    }
}

