/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.common.advancements.criterion.CatchBeeTrigger;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;

public class BeeCage
extends Item {
    public BeeCage(Item.Properties properties) {
        super(properties);
    }

    public static boolean isFilled(ItemStack itemStack) {
        CustomData data = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        return !itemStack.isEmpty() && itemStack.getItem() instanceof BeeCage && data != null && data.getUnsafe().contains("entity");
    }

    public static String getBeeType(ItemStack itemStack) {
        CustomData data = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        if (!itemStack.isEmpty() && itemStack.getItem() instanceof BeeCage && data != null && data.getUnsafe().contains("entity")) {
            CompoundTag tag = data.copyTag();
            String type = tag.getString("entity");
            if (type.equals("productivebees:configurable_bee")) {
                type = tag.getString("type");
            }
            return type;
        }
        return null;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level playerWorld = context.getPlayer().getCommandSenderWorld();
        ItemStack stack = context.getItemInHand();
        if (playerWorld.isClientSide() || !BeeCage.isFilled(stack)) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Bee entity = BeeCage.getEntityFromStack(stack, level, true);
        if (entity != null) {
            if (entity.isFlowerValid(pos)) {
                entity.setSavedFlowerPos(pos);
            } else if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown() || entity.hivePos != null && !level.isLoaded(entity.hivePos)) {
                entity.hivePos = null;
                if (entity instanceof ProductiveBee) {
                    ProductiveBee pBee = (ProductiveBee)entity;
                    if (level instanceof ServerLevel) {
                        pBee.setHasConverted(false);
                        pBee.setHasNectar(false);
                        PoiManager poiManager = ((ServerLevel)level).getPoiManager();
                        Optional poiAtLocation = poiManager.getType(pos);
                        if (poiAtLocation.isPresent() && ((ProductiveBee)entity).getBeehiveInterests().test((Holder<PoiType>)((Holder)poiAtLocation.get()))) {
                            entity.hivePos = pos;
                        }
                    }
                }
            }
            BlockPos blockPos = pos.relative(context.getClickedFace());
            entity.setPos((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
            level.addFreshEntity((Entity)entity);
            this.postItemUse(context);
        }
        return InteractionResult.SUCCESS;
    }

    protected void postItemUse(UseOnContext context) {
        if (context.getPlayer() != null) {
            if (context.getPlayer().isCreative()) {
                context.getPlayer().getInventory().removeItem(context.getItemInHand());
            } else {
                context.getItemInHand().shrink(1);
            }
        }
    }

    @Nonnull
    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity targetIn, InteractionHand hand) {
        Bee target;
        block10: {
            block9: {
                if (!(targetIn instanceof Bee)) break block9;
                target = (Bee)targetIn;
                if (targetIn.isAlive() && !BeeCage.isFilled(itemStack)) break block10;
            }
            return InteractionResult.PASS;
        }
        if (targetIn.getCommandSenderWorld().isClientSide()) {
            player.swing(hand);
            return InteractionResult.SUCCESS;
        }
        boolean addToInventory = true;
        ItemStack cageStack = new ItemStack((ItemLike)itemStack.getItem());
        if (itemStack.getCount() == 1) {
            cageStack = itemStack;
            addToInventory = false;
        }
        if (target.isLeashed()) {
            target.dropLeash(true, true);
        }
        BeeCage.captureEntity(target, cageStack);
        if (addToInventory || player.isCreative()) {
            if (!player.getInventory().add(cageStack)) {
                player.drop(cageStack, false);
            }
            itemStack.shrink(1);
        }
        player.swing(hand);
        if (player instanceof ServerPlayer) {
            ((CatchBeeTrigger)((Object)ModAdvancements.CATCH_BEE.get())).trigger((ServerPlayer)player, cageStack);
        }
        target.discard();
        return InteractionResult.SUCCESS;
    }

    public static void captureEntity(Bee target, ItemStack cageStack) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("entity", EntityType.getKey((EntityType)target.getType()).toString());
        if (target.hasCustomName()) {
            nbt.putString("name", target.getCustomName().getString());
        } else {
            nbt.putString("name", target.getName().getString());
        }
        target.saveWithoutId(nbt);
        AdvancedBeehiveBlockEntityAbstract.removeIgnoredTags(nbt);
        if (target.hasHive()) {
            nbt.put("HivePos", NbtUtils.writeBlockPos((BlockPos)target.getHivePos()));
        }
        nbt.putBoolean("isProductiveBee", target instanceof ProductiveBee);
        String modId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType()).getNamespace();
        String modName = ((ModContainer)ModList.get().getModContainerById(modId).get()).getClass().getSimpleName();
        if (modId.equals("minecraft")) {
            modName = "Minecraft";
        }
        nbt.putString("mod", modName);
        cageStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
    }

    @Nullable
    public static Bee getEntityFromStack(ItemStack stack, Level world, boolean withInfo) {
        return BeeCage.getEntityFromStack((CustomData)stack.get(DataComponents.CUSTOM_DATA), world, withInfo);
    }

    @Nullable
    public static Bee getEntityFromStack(CustomData data, Level world, boolean withInfo) {
        CompoundTag tag;
        EntityType type;
        if (data != null && (type = (EntityType)EntityType.byString((String)(tag = data.copyTag()).getString("entity")).orElse(null)) != null) {
            Entity entity = type.create(world);
            if (withInfo) {
                entity.load(tag);
            }
            if (entity instanceof Bee) {
                if (entity instanceof ConfigurableBee && !withInfo) {
                    ((ConfigurableBee)entity).setBeeType(tag.getString("type"));
                }
                return (Bee)entity;
            }
        }
        return null;
    }

    @Nonnull
    public Component getName(ItemStack stack) {
        if (!BeeCage.isFilled(stack)) {
            return Component.translatable((String)this.getDescriptionId());
        }
        String entityId = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag().getString("name");
        return Component.translatable((String)this.getDescriptionId()).append((Component)Component.literal((String)(" (" + entityId + ")")));
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        CustomData data = (CustomData)pStack.get(DataComponents.CUSTOM_DATA);
        if (data != null && !data.getUnsafe().equals((Object)new CompoundTag())) {
            CompoundTag tag = data.copyTag();
            if (Screen.hasShiftDown()) {
                boolean hasStung = tag.getBoolean("HasStung");
                if (hasStung) {
                    pTooltipComponents.add((Component)Component.translatable((String)"productivebees.information.health.dying").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC));
                }
                BeeHelper.populateBeeInfoFromTag(tag, pTooltipComponents);
                if (tag.contains("HivePos")) {
                    pTooltipComponents.add((Component)Component.translatable((String)"productivebees.information.cage_release"));
                }
            } else {
                pTooltipComponents.add((Component)Component.translatable((String)"productivebees.information.hold_shift").withStyle(ChatFormatting.WHITE));
            }
        }
    }
}

