/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.hive;

import cy.jdkdigital.productivebees.common.entity.bee.IEffectBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneValue;
import java.util.Collection;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CreeperBee
extends ProductiveBee
implements IEffectBeeEntity {
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(CreeperBee.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> POWERED = SynchedEntityData.defineId(CreeperBee.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int timeSinceIgnited;

    public CreeperBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
        this.setAttributeValue(GeneAttribute.TEMPER, GeneValue.TEMPER_AGGRESSIVE);
    }

    @Override
    public boolean isFlowerBlock(BlockState flowerBlock) {
        return flowerBlock.is(ModTags.POWDERY);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(STATE, (Object)-1);
        pBuilder.define(POWERED, (Object)false);
    }

    @Override
    public void tick() {
        if (this.isAlive() && !this.level().isClientSide) {
            int fuseTime;
            int i = this.getCreeperState();
            if (i > 0 && this.timeSinceIgnited == 0) {
                this.playSound(SoundEvents.CREEPER_PRIMED, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= (fuseTime = 30)) {
                this.timeSinceIgnited = fuseTime;
                this.explode();
            }
        }
        super.tick();
    }

    @Override
    public void attackTarget(LivingEntity target) {
        if (this.isAlive()) {
            this.setCreeperState(1);
        }
    }

    private void explode() {
        if (!this.level().isClientSide) {
            float f = (Boolean)this.entityData.get(POWERED) != false ? 2.0f : 1.0f;
            this.dead = true;
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 1.6f * f, Level.ExplosionInteraction.MOB);
            this.discard();
            this.spawnLingeringCloud();
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.getActiveEffects();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            areaeffectcloudentity.setRadius(2.5f);
            areaeffectcloudentity.setRadiusOnUse(-0.5f);
            areaeffectcloudentity.setWaitTime(10);
            areaeffectcloudentity.setDuration(areaeffectcloudentity.getDuration() / 2);
            areaeffectcloudentity.setRadiusPerTick(-areaeffectcloudentity.getRadius() / (float)areaeffectcloudentity.getDuration());
            for (MobEffectInstance effectinstance : collection) {
                areaeffectcloudentity.addEffect(new MobEffectInstance(effectinstance));
            }
            this.level().addFreshEntity((Entity)areaeffectcloudentity);
        }
    }

    public int getCreeperState() {
        return (Integer)this.entityData.get(STATE);
    }

    public void setCreeperState(int state) {
        this.entityData.set(STATE, (Object)state);
    }

    public void thunderHit(ServerLevel world, LightningBolt lightningBolt) {
        super.thunderHit(world, lightningBolt);
        this.entityData.set(POWERED, (Object)true);
    }
}

