/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.block.entity.SolitaryNestBlockEntity;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.common.recipe.BeeSpawningRecipe;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class SolitaryNest
extends AdvancedBeehiveAbstract {
    public static final MapCodec<SolitaryNest> CODEC = SolitaryNest.simpleCodec(SolitaryNest::new);
    public static Supplier<Map<Block, Block>> BLOCK_TO_NEST = Suppliers.memoize(() -> ImmutableMap.builder().put((Object)Blocks.GRASS_BLOCK, (Object)((Block)ModBlocks.BUMBLE_BEE_NEST.get())).put((Object)Blocks.OAK_LOG, (Object)((Block)ModBlocks.OAK_WOOD_NEST.get())).put((Object)Blocks.BIRCH_LOG, (Object)((Block)ModBlocks.BIRCH_WOOD_NEST.get())).put((Object)Blocks.SPRUCE_LOG, (Object)((Block)ModBlocks.SPRUCE_WOOD_NEST.get())).put((Object)Blocks.ACACIA_LOG, (Object)((Block)ModBlocks.ACACIA_WOOD_NEST.get())).put((Object)Blocks.DARK_OAK_LOG, (Object)((Block)ModBlocks.DARK_OAK_WOOD_NEST.get())).put((Object)Blocks.JUNGLE_LOG, (Object)((Block)ModBlocks.JUNGLE_WOOD_NEST.get())).put((Object)Blocks.MANGROVE_LOG, (Object)((Block)ModBlocks.MANGROVE_WOOD_NEST.get())).put((Object)Blocks.CHERRY_LOG, (Object)((Block)ModBlocks.CHERRY_WOOD_NEST.get())).put((Object)Blocks.GLOWSTONE, (Object)((Block)ModBlocks.GLOWSTONE_NEST.get())).put((Object)Blocks.NETHER_QUARTZ_ORE, (Object)((Block)ModBlocks.NETHER_QUARTZ_NEST.get())).put((Object)Blocks.NETHER_BRICKS, (Object)((Block)ModBlocks.NETHER_BRICK_NEST.get())).put((Object)Blocks.NETHER_GOLD_ORE, (Object)((Block)ModBlocks.NETHER_GOLD_NEST.get())).put((Object)Blocks.SOUL_SAND, (Object)((Block)ModBlocks.SOUL_SAND_NEST.get())).put((Object)Blocks.SOUL_SOIL, (Object)((Block)ModBlocks.SOUL_SAND_NEST.get())).put((Object)Blocks.END_STONE, (Object)((Block)ModBlocks.END_NEST.get())).put((Object)Blocks.OBSIDIAN, (Object)((Block)ModBlocks.OBSIDIAN_PILLAR_NEST.get())).put((Object)Blocks.SLIME_BLOCK, (Object)((Block)ModBlocks.SLIMY_NEST.get())).put((Object)Blocks.SUGAR_CANE, (Object)((Block)ModBlocks.SUGAR_CANE_NEST.get())).put((Object)Blocks.DIRT, (Object)((Block)ModBlocks.COARSE_DIRT_NEST.get())).put((Object)Blocks.STONE, (Object)((Block)ModBlocks.STONE_NEST.get())).put((Object)Blocks.SAND, (Object)((Block)ModBlocks.SAND_NEST.get())).put((Object)Blocks.SNOW_BLOCK, (Object)((Block)ModBlocks.SNOW_NEST.get())).put((Object)Blocks.GRAVEL, (Object)((Block)ModBlocks.GRAVEL_NEST.get())).build());
    static Map<String, List<RecipeHolder<BeeSpawningRecipe>>> recipes = new HashMap<String, List<RecipeHolder<BeeSpawningRecipe>>>();

    public SolitaryNest(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : SolitaryNest.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.SOLITARY_NEST.get()), SolitaryNestBlockEntity::tick);
    }

    @Override
    public int getMaxHoneyLevel() {
        return 0;
    }

    public static Entity getNestingBeeType(SolitaryNest block, Level level, Holder<Biome> biome, RandomSource random) {
        List<RecipeHolder<BeeSpawningRecipe>> spawningRecipes = SolitaryNest.getSpawningRecipes(block, level, biome, ItemStack.EMPTY);
        if (!spawningRecipes.isEmpty()) {
            RecipeHolder<BeeSpawningRecipe> spawningRecipe = spawningRecipes.get(random.nextInt(spawningRecipes.size()));
            BeeIngredient beeIngredient = ((BeeSpawningRecipe)spawningRecipe.value()).output.get(random.nextInt(((BeeSpawningRecipe)spawningRecipe.value()).output.size())).get();
            if (beeIngredient != null) {
                Entity bee = beeIngredient.getBeeEntity().create(level);
                if (bee instanceof ConfigurableBee) {
                    ((ConfigurableBee)bee).setBeeType(beeIngredient.getBeeType().toString());
                    ((ConfigurableBee)bee).setDefaultAttributes();
                }
                return bee;
            }
            ProductiveBees.LOGGER.debug("No bee ingredient found in " + String.valueOf(spawningRecipe));
        }
        return null;
    }

    public static List<RecipeHolder<BeeSpawningRecipe>> getSpawningRecipes(SolitaryNest block, Level level, Holder<Biome> biome, ItemStack heldItem) {
        ArrayList<RecipeHolder<BeeSpawningRecipe>> spawningRecipes = new ArrayList();
        String cacheKey = String.valueOf(BuiltInRegistries.ITEM.getKey((Object)heldItem.getItem())) + "_" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)block)) + "_" + String.valueOf(level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)((Biome)biome.value())));
        if (!recipes.containsKey(cacheKey)) {
            List allRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.BEE_SPAWNING_TYPE.get());
            ItemStack nestItem = new ItemStack((ItemLike)block);
            for (RecipeHolder entry : allRecipes) {
                BeeSpawningRecipe recipe = (BeeSpawningRecipe)entry.value();
                if (!recipe.matches(nestItem, heldItem, biome)) continue;
                spawningRecipes.add((RecipeHolder<BeeSpawningRecipe>)entry);
            }
            recipes.put(cacheKey, spawningRecipes);
        } else {
            spawningRecipes = recipes.get(cacheKey);
        }
        return spawningRecipes;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SolitaryNestBlockEntity(pos, state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext itemUseContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)itemUseContext.getNearestLookingDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.FACING});
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        SolitaryNestBlockEntity tileEntity;
        if (!pLevel.isClientSide() && (tileEntity = (SolitaryNestBlockEntity)pLevel.getBlockEntity(pPos)) != null && !pStack.isEmpty()) {
            if (pStack.getItem() instanceof HoneyTreat && HoneyTreat.hasGene(pStack)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            boolean itemUse = false;
            int currentCooldown = tileEntity.getNestTickCooldown();
            if (tileEntity.canRepopulate(pStack)) {
                itemUse = true;
                if (currentCooldown <= 0) {
                    tileEntity.setNestCooldown((Integer)ProductiveBeesConfig.GENERAL.nestSpawnCooldown.get());
                } else {
                    tileEntity.setNestCooldown((int)((double)currentCooldown * 0.9));
                }
            }
            if (itemUse) {
                pLevel.levelEvent(2011, pPos, 15);
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)pPlayer, pPos, pStack);
                if (!pPlayer.isCreative()) {
                    pStack.shrink(1);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    @Override
    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTootipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTootipComponents, pTooltipFlag);
        if (pStack.has(DataComponents.BLOCK_ENTITY_DATA) && ((CustomData)pStack.get(DataComponents.BLOCK_ENTITY_DATA)).getUnsafe().getInt("spawnCount") >= (Integer)ProductiveBeesConfig.BEES.cuckooSpawnCount.get()) {
            pTootipComponents.add((Component)Component.translatable((String)"productivebees.hive.tooltip.nest_inactive").withStyle(ChatFormatting.BOLD));
        }
    }
}

