/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;

public class JarBlockItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final ConcurrentHashMap<String, Entity> beeEntities = new ConcurrentHashMap();

    public JarBlockItemRenderer() {
        super(null, null);
    }

    public void renderByItem(ItemStack itemStack, ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int packedLightIn, int packedUV) {
        Item item = itemStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem jarBlockItem = (BlockItem)item;
            if (itemStack.has(DataComponents.CONTAINER)) {
                CustomData data;
                String beeTypeOrEntityType = "";
                String entityType = "";
                ItemStack cageStack = ItemStack.EMPTY;
                ItemContainerContents containerData = (ItemContainerContents)itemStack.get(DataComponents.CONTAINER);
                if (containerData != null && containerData.getSlots() > 0) {
                    cageStack = containerData.getStackInSlot(0);
                }
                if (!cageStack.isEmpty() && BeeCage.isFilled(cageStack) && (data = (CustomData)cageStack.get(DataComponents.CUSTOM_DATA)) != null && !data.getUnsafe().equals((Object)new CompoundTag())) {
                    CompoundTag tag = data.copyTag();
                    entityType = tag.getString("entity");
                    beeTypeOrEntityType = entityType.equals("productivebees:configurable_bee") ? tag.getString("type") : tag.getString("entity");
                }
                if (!beeTypeOrEntityType.isEmpty()) {
                    Entity beeEntity;
                    Entity beeEntity2;
                    EntityType type;
                    if (!beeEntities.containsKey(beeTypeOrEntityType) && !entityType.isEmpty() && (type = (EntityType)EntityType.byString((String)entityType).orElse(null)) != null && Minecraft.getInstance().level != null && (beeEntity2 = type.create((Level)Minecraft.getInstance().level)) != null) {
                        if (beeEntity2 instanceof ConfigurableBee) {
                            ConfigurableBee configurableBee = (ConfigurableBee)beeEntity2;
                            configurableBee.setBeeType(beeTypeOrEntityType);
                        }
                        beeEntities.put(beeTypeOrEntityType, beeEntity2);
                    }
                    if ((beeEntity = (Entity)beeEntities.getOrDefault(beeTypeOrEntityType, null)) != null) {
                        JarBlockItemRenderer.renderBee(beeEntity, matrixStack, transformType);
                    }
                }
            }
            JarBlockItemRenderer.renderJar(matrixStack, jarBlockItem, itemStack, packedLightIn, packedUV, transformType);
        }
    }

    public static void renderBee(Entity bee, PoseStack matrixStack, ItemDisplayContext pTransformType) {
        float angle = bee.tickCount % 360;
        float f = 0.47f;
        float f1 = Math.max(bee.getBbWidth(), bee.getBbHeight());
        if ((double)f1 > 1.0) {
            f /= f1;
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5f, 0.4f, 0.5f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(angle));
        matrixStack.translate(0.0f, -0.2f, 0.0f);
        matrixStack.scale(f, f, f);
        if (pTransformType.equals((Object)ItemDisplayContext.GUI)) {
            matrixStack.scale(1.2f, 1.2f, 1.2f);
        }
        EntityRenderDispatcher entityRendererDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        entityRendererDispatcher.setRenderShadow(false);
        entityRendererDispatcher.render(bee, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrixStack, (MultiBufferSource)buffer, 0xF000F0);
        matrixStack.popPose();
    }

    public static void renderJar(PoseStack matrixStack, BlockItem jarBlockItem, ItemStack itemStack, int packedLight, int packedOverlay, ItemDisplayContext transformType) {
        matrixStack.pushPose();
        if (transformType.equals((Object)ItemDisplayContext.GUI)) {
            float x = -0.5f;
            float y = -0.45f;
            float z = -0.5f;
            matrixStack.translate(1.0f, 1.0f, 1.0f);
            matrixStack.translate(x, y, z);
            matrixStack.mulPose(Axis.XP.rotationDegrees(20.0f));
            matrixStack.mulPose(Axis.YP.rotationDegrees(120.0f));
            matrixStack.mulPose(Axis.ZP.rotationDegrees(0.0f));
            matrixStack.translate(x, y, z);
        }
        BakedModel bakedModel = Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(jarBlockItem.getBlock().defaultBlockState());
        RenderType renderType = ItemBlockRenderTypes.getRenderType((ItemStack)itemStack, (boolean)false);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = ItemRenderer.getFoilBuffer((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (boolean)itemStack.hasFoil());
        Minecraft.getInstance().getItemRenderer().renderModelLists(bakedModel, itemStack, packedLight, packedOverlay, matrixStack, vertexConsumer);
        matrixStack.popPose();
    }
}

