/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import cy.jdkdigital.productivebees.setup.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.Lazy;

public class BeeNestHelmetModel<T extends LivingEntity>
extends HumanoidModel<T> {
    public static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"bee_nest_diamond_helmet");
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(TEXTURE_LOCATION, "main");
    public static final Lazy<HumanoidModel<?>> INSTANCE = Lazy.of(() -> new BeeNestHelmetModel(Minecraft.getInstance().getEntityModels().bakeLayer(LAYER_LOCATION)));

    public BeeNestHelmetModel(ModelPart modelRoot) {
        super(modelRoot);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.5f), (float)0.0f);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        super.renderToBuffer(poseStack, buffer, packedLight, packedOverlay, color);
        if (ClientProxy.buffer != null) {
            BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
            BlockState nest = (BlockState)Blocks.BEE_NEST.defaultBlockState().setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(5));
            poseStack.pushPose();
            this.head.translateAndRotate(poseStack);
            poseStack.translate(0.0, -0.3, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.scale(0.825f, -0.825f, -0.825f);
            poseStack.translate(-0.5f, 0.0f, -0.5f);
            poseStack.mulPose(Axis.XP.rotationDegrees(5.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(1.0f));
            blockRenderer.renderSingleBlock(nest, poseStack, ClientProxy.buffer, packedLight, packedOverlay, ModelData.EMPTY, null);
            poseStack.popPose();
        }
    }
}

