/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BaseBlockEntity
extends BlockEntity {
    private boolean dataChanged = true;

    public BaseBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void dataChanged() {
        this.dataChanged = true;
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 6);
    }

    protected abstract CompoundTag writeData();

    protected CompoundTag writeClientData() {
        return this.writeData();
    }

    protected CompoundTag writeItemStackData() {
        return this.writeData();
    }

    protected abstract void readData(CompoundTag var1);

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        CompoundTag data = this.writeData();
        if (data != null && !data.isEmpty()) {
            compound.put("data", (Tag)data);
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.readData(nbt.contains("data", 10) ? nbt.getCompound("data") : new CompoundTag());
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        super.saveAdditional(tag, provider);
        CompoundTag data = this.writeClientData();
        if (data != null && !data.isEmpty()) {
            tag.put("data", (Tag)data);
        }
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        if (this.dataChanged) {
            this.dataChanged = false;
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (entity, registryAccess) -> {
                CompoundTag tag = new CompoundTag();
                CompoundTag data = ((BaseBlockEntity)((Object)entity)).writeClientData();
                if (data != null && !data.isEmpty()) {
                    tag.put("data", (Tag)data);
                }
                return tag;
            });
        }
        return null;
    }
}

