/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.util;

import com.mojang.serialization.Codec;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.systems.mixes.JsonMix;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MiscDatagen
implements DataProvider {
    private final Path outputDir;
    private final CompletableFuture<HolderLookup.Provider> regs;
    private CachedOutput cachedOutput;
    private List<CompletableFuture<?>> futures = new ArrayList();

    public MiscDatagen(Path outputDir, CompletableFuture<HolderLookup.Provider> regs) {
        this.outputDir = outputDir;
        this.regs = regs;
        Object2IntOpenHashMap map = (Object2IntOpenHashMap)DataProvider.FIXED_ORDER_FIELDS;
        map.put((Object)"mix_type", 0);
    }

    public void genPotionRecipes() {
        this.addMix((Holder<Potion>)Potions.AWKWARD, Items.SHULKER_SHELL, ALObjects.Potions.RESISTANCE);
        this.addMix(ALObjects.Potions.RESISTANCE, Items.REDSTONE, ALObjects.Potions.LONG_RESISTANCE);
        this.addMix(ALObjects.Potions.RESISTANCE, Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_RESISTANCE);
        this.addMix(ALObjects.Potions.RESISTANCE, Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.SUNDERING);
        this.addMix(ALObjects.Potions.LONG_RESISTANCE, Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.LONG_SUNDERING);
        this.addMix(ALObjects.Potions.STRONG_RESISTANCE, Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.STRONG_SUNDERING);
        this.addMix(ALObjects.Potions.SUNDERING, Items.REDSTONE, ALObjects.Potions.LONG_SUNDERING);
        this.addMix(ALObjects.Potions.SUNDERING, Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_SUNDERING);
        this.addMix((Holder<Potion>)Potions.AWKWARD, Items.GOLDEN_APPLE, ALObjects.Potions.ABSORPTION);
        this.addMix(ALObjects.Potions.ABSORPTION, Items.REDSTONE, ALObjects.Potions.LONG_ABSORPTION);
        this.addMix(ALObjects.Potions.ABSORPTION, Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_ABSORPTION);
        this.addMix((Holder<Potion>)Potions.AWKWARD, Items.MUSHROOM_STEW, ALObjects.Potions.HASTE);
        this.addMix(ALObjects.Potions.HASTE, Items.REDSTONE, ALObjects.Potions.LONG_HASTE);
        this.addMix(ALObjects.Potions.HASTE, Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_HASTE);
        this.addMix(ALObjects.Potions.HASTE, Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.FATIGUE);
        this.addMix(ALObjects.Potions.LONG_HASTE, Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.LONG_FATIGUE);
        this.addMix(ALObjects.Potions.STRONG_HASTE, Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.STRONG_FATIGUE);
        this.addMix(ALObjects.Potions.FATIGUE, Items.REDSTONE, ALObjects.Potions.LONG_FATIGUE);
        this.addMix(ALObjects.Potions.FATIGUE, Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_FATIGUE);
        this.addMix((Holder<Potion>)Potions.AWKWARD, Items.WITHER_SKELETON_SKULL, ALObjects.Potions.WITHER);
        this.addMix(ALObjects.Potions.WITHER, Items.REDSTONE, ALObjects.Potions.LONG_WITHER);
        this.addMix(ALObjects.Potions.WITHER, Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_WITHER);
        this.addMix((Holder<Potion>)Potions.AWKWARD, Items.EXPERIENCE_BOTTLE, ALObjects.Potions.KNOWLEDGE);
        this.addMix(ALObjects.Potions.KNOWLEDGE, Items.REDSTONE, ALObjects.Potions.LONG_KNOWLEDGE);
        this.addMix(ALObjects.Potions.KNOWLEDGE, Items.EXPERIENCE_BOTTLE, ALObjects.Potions.STRONG_KNOWLEDGE);
        this.addMix((Holder<Potion>)Potions.AWKWARD, Items.SWEET_BERRIES, ALObjects.Potions.VITALITY);
        this.addMix(ALObjects.Potions.VITALITY, Items.REDSTONE, ALObjects.Potions.LONG_VITALITY);
        this.addMix(ALObjects.Potions.VITALITY, Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_VITALITY);
        this.addMix(ALObjects.Potions.VITALITY, Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.GRIEVOUS);
        this.addMix(ALObjects.Potions.LONG_VITALITY, Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.LONG_GRIEVOUS);
        this.addMix(ALObjects.Potions.STRONG_VITALITY, Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.STRONG_GRIEVOUS);
        this.addMix(ALObjects.Potions.GRIEVOUS, Items.REDSTONE, ALObjects.Potions.LONG_GRIEVOUS);
        this.addMix(ALObjects.Potions.GRIEVOUS, Items.GLOWSTONE_DUST, ALObjects.Potions.STRONG_GRIEVOUS);
        this.addMix((Holder<Potion>)Potions.SLOW_FALLING, Items.FERMENTED_SPIDER_EYE, ALObjects.Potions.LEVITATION);
        this.addMix(ALObjects.Potions.LEVITATION, Items.POPPED_CHORUS_FRUIT, ALObjects.Potions.FLYING);
        this.addMix(ALObjects.Potions.FLYING, Items.REDSTONE, ALObjects.Potions.LONG_FLYING);
        this.addMix(ALObjects.Potions.LONG_FLYING, Items.REDSTONE, ALObjects.Potions.EXTRA_LONG_FLYING);
    }

    private void addMix(Holder<Potion> input, Item ingredient, Holder<Potion> output) {
        ResourceLocation inKey = ((ResourceKey)input.unwrapKey().get()).location();
        ResourceLocation outKey = ((ResourceKey)output.unwrapKey().get()).location();
        this.write(new JsonMix(input, Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), output, JsonMix.Type.POTION), "brewing_mixes", outKey.getPath() + "_from_" + inKey.getPath());
    }

    private <T extends CodecProvider<T>> void write(T object, String type, String path) {
        this.futures.add((CompletableFuture<?>)this.regs.thenCompose(registries -> DataProvider.saveStable((CachedOutput)this.cachedOutput, (HolderLookup.Provider)registries, (Codec)object.getCodec(), (Object)object, (Path)this.outputDir.resolve(type + "/" + path + ".json"))));
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        this.cachedOutput = pOutput;
        this.genPotionRecipes();
        return CompletableFuture.allOf((CompletableFuture[])this.futures.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "apothic_attributes";
    }
}

