/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.blueflame.network;

import com.mojang.serialization.Codec;
import cy.jdkdigital.blueflame.BlueFlame;
import cy.jdkdigital.blueflame.cap.BlueFlameHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record FirePacket(int entityID, CompoundTag data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FirePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"blueflame", (String)"fire_packet"));
    public static final StreamCodec<FriendlyByteBuf, FirePacket> STREAM_CODEC = CustomPacketPayload.codec(FirePacket::write, FirePacket::new);

    private FirePacket(FriendlyByteBuf buffer) {
        this(buffer.readInt(), (CompoundTag)ByteBufCodecs.fromCodec((Codec)CompoundTag.CODEC).decode((Object)buffer));
    }

    private void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityID);
        ByteBufCodecs.fromCodec((Codec)CompoundTag.CODEC).encode((Object)buffer, (Object)this.data);
    }

    public static void clientHandle(FirePacket data, IPayloadContext context) {
        Entity entity;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && (entity = level.getEntity(data.entityID)) != null) {
            ((BlueFlameHandler)entity.getData(BlueFlame.BLUE_FLAME_HANDLER)).deserializeNBT((HolderLookup.Provider)level.registryAccess(), data.data());
        }
    }

    public static void serverHandle(FirePacket data, IPayloadContext context) {
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

