/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.blueflame.mixin;

import cy.jdkdigital.blueflame.BlueFlame;
import cy.jdkdigital.blueflame.cap.BlueFlameHandler;
import cy.jdkdigital.blueflame.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class MixinEntity {
    @Inject(at={@At(value="HEAD")}, method={"lavaHurt()V"})
    public void lavaHurt(CallbackInfo callbackInfo) {
        Entity entity = (Entity)this;
        if (!entity.level().isClientSide()) {
            AABB aabb = entity.getBoundingBox().deflate(0.001);
            BlockPos.MutableBlockPos mutableBlockpos = new BlockPos.MutableBlockPos();
            for (int l1 = Mth.floor((double)aabb.minX); l1 < Mth.ceil((double)aabb.maxX); ++l1) {
                for (int i2 = Mth.floor((double)aabb.minY); i2 < Mth.ceil((double)aabb.maxY); ++i2) {
                    for (int j2 = Mth.floor((double)aabb.minZ); j2 < Mth.ceil((double)aabb.maxZ); ++j2) {
                        mutableBlockpos.set(l1, i2, j2);
                        FluidState fluidstate = entity.level().getFluidState((BlockPos)mutableBlockpos);
                        if (!fluidstate.is(ModTags.SOUL_FLAME_SOURCE)) continue;
                        ((BlueFlameHandler)entity.getData(BlueFlame.BLUE_FLAME_HANDLER)).setOnFire(entity);
                    }
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setRemainingFireTicks(I)V"})
    public void setRemainingFireTicks(int remainingFireTicks, CallbackInfo callbackInfo) {
        BlueFlameHandler data;
        Entity entity = (Entity)this;
        if (!entity.level().isClientSide() && remainingFireTicks <= 0 && (data = (BlueFlameHandler)entity.getData(BlueFlame.BLUE_FLAME_HANDLER)).isOnFire()) {
            data.unsetOnFire(entity);
        }
    }
}

