/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.IInvCharge;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.init.TechProperties;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.items.equipment.DETier;
import com.brandon3055.draconicevolution.items.equipment.IModularEnergyItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class DraconiumCapacitor
extends Item
implements IInvCharge,
IModularEnergyItem {
    private TechLevel techLevel;

    public DraconiumCapacitor(TechProperties properties) {
        super((Item.Properties)properties);
        this.techLevel = properties.getTechLevel();
    }

    @Override
    public boolean canCharge(ItemStack stack, LivingEntity player, boolean isHeld) {
        return isHeld;
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    public ModuleHostImpl createHostCapForRegistration(ItemStack stack) {
        ModuleHostImpl host = IModularEnergyItem.super.createHostCapForRegistration(stack);
        if (this == DEContent.CAPACITOR_CREATIVE.get()) {
            host.getModuleCategories().remove(ModuleCategory.ENERGY);
        }
        return host;
    }

    @Override
    @NotNull
    public ModuleHostImpl instantiateHost(ItemStack stack) {
        ModuleHostImpl host = this == DEContent.CAPACITOR_CREATIVE.get() ? new ModuleHostImpl(this.techLevel, 1, 1, "capacitor", ModuleCfg.removeInvalidModules, new ModuleCategory[0]) : new ModuleHostImpl(this.techLevel, ModuleCfg.capacitorWidth(this.techLevel), ModuleCfg.capacitorHeight(this.techLevel), "capacitor", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addPropertyBuilder(props -> {
            props.add(new BooleanProperty("charge_held_item", false));
            props.add(new BooleanProperty("charge_armor", false));
            props.add(new BooleanProperty("charge_hot_bar", false));
            props.add(new BooleanProperty("charge_main", false));
            if (EquipmentManager.equipModLoaded()) {
                props.add(new BooleanProperty("charge_" + EquipmentManager.equipModID(), false));
            }
        });
        return host;
    }

    @Override
    @NotNull
    public ModularOPStorage instantiateOPStorage(ItemStack stack, Supplier<ModuleHost> hostSupplier) {
        if (this == DEContent.CAPACITOR_CREATIVE.get()) {
            return new ModularOPStorage(this, hostSupplier, Long.MAX_VALUE, Long.MAX_VALUE){

                public long getOPStored() {
                    return 0x3FFFFFFFFFFFFFFFL;
                }

                public long receiveOP(long maxReceive, boolean simulate) {
                    return maxReceive;
                }

                public long extractOP(long maxExtract, boolean simulate) {
                    return maxExtract;
                }

                public boolean canExtract() {
                    return true;
                }
            }.setIOMode(true, true);
        }
        return new ModularOPStorage(hostSupplier, EquipCfg.getBaseCapEnergy(this.techLevel), EquipCfg.getBaseCapTransfer(this.techLevel)).setIOMode(true, true);
    }

    @Override
    public void handleTick(ModuleHost host, ItemStack stack, LivingEntity entity, @Nullable EquipmentSlot slot, boolean inEquipModSlot) {
        IModularEnergyItem.super.handleTick(host, stack, entity, slot, inEquipModSlot);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        boolean held = host.getBool("charge_held_item").getValue();
        boolean armor = host.getBool("charge_armor").getValue();
        boolean hot_bar = host.getBool("charge_hot_bar").getValue();
        boolean main = host.getBool("charge_main").getValue();
        if (EquipmentManager.equipModLoaded() && host.getBool("charge_" + EquipmentManager.equipModID()).getValue()) {
            stacks.addAll(EquipmentManager.getAllItems(entity));
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (hot_bar && main) {
                stacks.addAll((Collection<ItemStack>)player.getInventory().items);
            } else if (hot_bar) {
                stacks.addAll(player.getInventory().items.subList(0, 9));
            } else if (main) {
                stacks.addAll(player.getInventory().items.subList(9, 36));
            }
            if (held) {
                if (!hot_bar) {
                    stacks.add(entity.getMainHandItem());
                }
                stacks.add(entity.getOffhandItem());
            }
        } else if (held) {
            entity.getHandSlots().forEach(stacks::add);
        }
        if (armor) {
            entity.getArmorSlots().forEach(stacks::add);
        }
        stacks.remove(stack);
        if (!stacks.isEmpty()) {
            this.updateEnergy(stack, entity, stacks);
        }
    }

    public void updateEnergy(ItemStack capacitor, LivingEntity player, List<ItemStack> stacks) {
        IOPStorage storage = (IOPStorage)capacitor.getCapability(CapabilityOP.ITEM);
        if (storage != null) {
            for (ItemStack stack : stacks) {
                Item item;
                if (!EnergyUtils.canReceiveEnergy((ItemStack)stack) || (item = stack.getItem()) instanceof IInvCharge && !((IInvCharge)item).canCharge(stack, player, DataUtils.contains((Iterable)player.getHandSlots(), (Object)stack))) continue;
                EnergyUtils.insertEnergy((ItemStack)stack, (long)EnergyUtils.extractEnergy((ItemStack)capacitor, (long)EnergyUtils.insertEnergy((ItemStack)stack, (long)storage.getOPStored(), (boolean)true), (boolean)false), (boolean)false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        this.addModularItemInformation(stack, context, tooltip, flagIn);
    }

    public int getEnchantmentValue() {
        return DETier.getEnchantability(this.techLevel);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.damageBarVisible(stack);
    }

    public int getBarWidth(ItemStack stack) {
        return this.damageBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return this.damageBarColour(stack);
    }

    public boolean canBeHurtBy(ItemStack stack, DamageSource source) {
        return source.is(DamageTypes.FELL_OUT_OF_WORLD);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.getAge() >= 0 && entity.pickupDelay != Short.MAX_VALUE) {
            entity.setExtendedLifetime();
        }
        return super.onEntityItemUpdate(stack, entity);
    }
}

