/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostContainer;
import com.brandon3055.draconicevolution.api.modules.lib.TileModuleContext;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.util.thread.EffectiveSide;
import org.jetbrains.annotations.Nullable;

public abstract class DETileMenu<T extends TileBCore>
extends ContainerBCTile<T>
implements ModuleHostContainer {
    protected ModuleGrid moduleGrid;
    protected ModuleHost moduleHost = null;
    private int gridWidth;
    private int gridHeight;

    public DETileMenu(@Nullable MenuType<?> type, int windowId, Inventory player, FriendlyByteBuf extraData) {
        super(type, windowId, player, extraData);
        this.initHost(this.tile, player);
    }

    public DETileMenu(@Nullable MenuType<?> type, int windowId, Inventory player, T tile) {
        super(type, windowId, player, tile);
        this.initHost(tile, player);
    }

    protected void initHost(T tile, Inventory player) {
        ModuleHost host = DECapabilities.Host.fromBlockEntity(tile);
        if (host != null) {
            this.moduleHost = host;
            this.gridWidth = this.moduleHost.getGridWidth();
            this.gridHeight = this.moduleHost.getGridHeight();
            this.moduleGrid = new ModuleGrid(this, player);
        }
    }

    @Override
    public int getGridWidth() {
        return this.gridWidth;
    }

    @Override
    public int getGridHeight() {
        return this.gridHeight;
    }

    public ItemStack quickMoveStack(Player player, int i) {
        if (this.moduleHost != null && this.quickMoveModule(this.moduleHost, player, this.getSlot(i))) {
            return ItemStack.EMPTY;
        }
        if (this.moduleHost != null) {
            this.moduleHost.save();
        }
        return super.quickMoveStack(player, i);
    }

    @Override
    public ModuleGrid getGrid() {
        return this.moduleGrid;
    }

    @Override
    public ModuleHost getModuleHost() {
        return this.moduleHost;
    }

    @Override
    public ModuleContext getModuleContext() {
        return new TileModuleContext((BlockEntity)this.tile);
    }

    public void clicked(int p_150400_, int p_150401_, ClickType p_150402_, Player p_150403_) {
        super.clicked(p_150400_, p_150401_, p_150402_, p_150403_);
    }

    @Override
    public void onGridChange() {
        if (EffectiveSide.get().isServer()) {
            for (int i = 0; i < this.slots.size(); ++i) {
                ItemStack itemstack = ((Slot)this.slots.get(i)).getItem();
                ItemStack itemstack1 = (ItemStack)this.lastSlots.get(i);
                if (ItemStack.matches((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
                itemstack1 = itemstack.copy();
                this.lastSlots.set(i, (Object)itemstack1);
                for (ContainerListener icontainerlistener : this.containerListeners) {
                    icontainerlistener.slotChanged((AbstractContainerMenu)this, i, itemstack1);
                }
            }
        }
    }
}

