/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianProjectileEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.Phase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;

public class CoverFirePhase
extends Phase {
    private static final Logger LOGGER = DraconicEvolution.LOGGER;
    private Path currentPath;
    private Vec3 targetLocation;
    private boolean clockwise;
    private int tick;

    public CoverFirePhase(DraconicGuardianEntity guardisn) {
        super(guardisn);
    }

    public PhaseType<CoverFirePhase> getType() {
        return PhaseType.COVER_FIRE;
    }

    @Override
    public void serverTick() {
        double distanceFromTarget;
        Vec3 vector3d2 = this.guardian.getViewVector(1.0f);
        double headX = this.guardian.dragonPartHead.getX() - vector3d2.x * 1.0;
        double headY = this.guardian.dragonPartHead.getY(0.5) + 0.5;
        double headZ = this.guardian.dragonPartHead.getZ() - vector3d2.z * 1.0;
        Vec3 targetPos = this.guardian.position();
        targetPos = targetPos.add((this.guardian.getRandom().nextDouble() - 0.5) * 50.0, (this.guardian.getRandom().nextDouble() - 0.5) * 50.0, (this.guardian.getRandom().nextDouble() - 0.5) * 50.0);
        double targetRelX = targetPos.x - headX;
        double targetRelY = targetPos.y - headY;
        double targetRelZ = targetPos.z - headZ;
        if (!this.guardian.isSilent()) {
            this.guardian.level().levelEvent(null, 1017, this.guardian.blockPosition(), 0);
        }
        GuardianProjectileEntity projectile = new GuardianProjectileEntity(this.guardian.level(), (LivingEntity)this.guardian, targetRelX, targetRelY, targetRelZ, targetPos, 25.0, 15.0);
        projectile.moveTo(headX, headY, headZ, 0.0f, 0.0f);
        this.guardian.level().addFreshEntity((Entity)projectile);
        double d = distanceFromTarget = this.targetLocation == null ? 0.0 : this.targetLocation.distanceToSqr(this.guardian.getX(), this.guardian.getY(), this.guardian.getZ());
        if (this.currentPath != null && this.currentPath.isDone() && distanceFromTarget < 100.0) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).immediateAttack(null);
            return;
        }
        if (distanceFromTarget < 100.0) {
            this.updatePathing();
        }
        if (this.tick++ > 60) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).immediateAttack(null);
        }
    }

    @Override
    public void initPhase() {
        this.currentPath = null;
        this.targetLocation = null;
        this.tick = 0;
    }

    private void updatePathing() {
        if (this.currentPath == null || this.currentPath.isDone()) {
            int nearestIndex;
            int endIndex = nearestIndex = this.guardian.initPathPoints(false);
            if (this.guardian.getRandom().nextInt(8) == 0) {
                boolean bl = this.clockwise = !this.clockwise;
            }
            endIndex = this.clockwise ? (endIndex += 12) : (endIndex -= 12);
            endIndex = Math.floorMod(endIndex, 24);
            this.currentPath = this.guardian.findPath(nearestIndex, endIndex, null);
            if (this.currentPath != null) {
                this.currentPath.advance();
            }
        }
        this.navigateToNextPathNode();
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.isDone()) {
            BlockPos nextPos = this.currentPath.getNextNodePos();
            this.currentPath.advance();
            double x = nextPos.getX();
            double z = nextPos.getZ();
            double y = (float)nextPos.getY() + this.guardian.getRandom().nextFloat() * 20.0f;
            this.targetLocation = new Vec3(x, y, z);
        }
    }

    @Override
    public double getGuardianSpeed() {
        return 3.0;
    }

    @Override
    @Nullable
    public Vec3 getTargetLocation() {
        return this.targetLocation;
    }
}

