/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.sound;

import codechicken.lib.vec.Vector3;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class SimpleSoundImpl
extends SimpleSoundInstance
implements TickableSoundInstance {
    private Supplier<Float> pitchSupplier;
    private Supplier<Float> volumeSupplier;
    private Supplier<Boolean> stoppedSupplier;
    private Supplier<Vector3> posSupplier;
    private boolean stop = false;

    public static SimpleSoundImpl create(SoundEvent sound, SoundSource source, RandomSource random) {
        return new SimpleSoundImpl(sound, source, random);
    }

    private SimpleSoundImpl(SoundEvent sound, SoundSource source, RandomSource random) {
        super(sound, source, 1.0f, 1.0f, random, BlockPos.ZERO);
    }

    public SimpleSoundImpl setPitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public SimpleSoundImpl setPitchSupplier(Supplier<Float> pitchSupplier) {
        this.pitchSupplier = pitchSupplier;
        return this;
    }

    public SimpleSoundImpl setVolume(float volume) {
        this.volume = volume;
        return this;
    }

    public SimpleSoundImpl setVolumeSupplier(Supplier<Float> volumeSupplier) {
        this.volumeSupplier = volumeSupplier;
        return this;
    }

    public SimpleSoundImpl setPos(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public SimpleSoundImpl setPos(Vector3 pos) {
        return this.setPos(pos.x, pos.y, pos.z);
    }

    public SimpleSoundImpl setPos(BlockPos pos) {
        return this.setPos(Vector3.fromBlockPosCenter((BlockPos)pos));
    }

    public SimpleSoundImpl setPos(Entity pos) {
        return this.setPos(Vector3.fromEntityCenter((Entity)pos));
    }

    public SimpleSoundImpl setPosSupplier(Supplier<Vector3> posSupplier) {
        this.posSupplier = posSupplier;
        return this;
    }

    public SimpleSoundImpl setStoppedSupplier(Supplier<Boolean> stoppedSupplier) {
        this.stoppedSupplier = stoppedSupplier;
        return this;
    }

    public SimpleSoundImpl loop() {
        this.looping = true;
        return this;
    }

    public SimpleSoundImpl play(Minecraft minecraft) {
        minecraft.getSoundManager().play((SoundInstance)this);
        return this;
    }

    public void stop() {
        this.stop = true;
    }

    public boolean isStopped() {
        return this.stop || this.stoppedSupplier != null && this.stoppedSupplier.get() != false;
    }

    public void tick() {
        if (this.pitchSupplier != null) {
            this.setPitch(this.pitchSupplier.get().floatValue());
        }
        if (this.volumeSupplier != null) {
            this.setVolume(this.volumeSupplier.get().floatValue());
        }
        if (this.posSupplier != null) {
            this.setPos(this.posSupplier.get());
        }
    }
}

