/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import com.brandon3055.draconicevolution.blocks.PlacedItem;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePlacedItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;

public class RenderTilePlacedItem
implements BlockEntityRenderer<TilePlacedItem> {
    public RenderTilePlacedItem(BlockEntityRendererProvider.Context context) {
    }

    public void render(TilePlacedItem tile, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        Minecraft mc = Minecraft.getInstance();
        List<ItemStack> stackList = tile.getStacksInOrder();
        float scale = stackList.size() == 1 && tile.toolMode.get() ? 0.875f : 0.4375f;
        mStack.pushPose();
        mStack.translate(0.5, 0.5, 0.5);
        Direction direction = (Direction)tile.getBlockState().getValue((Property)PlacedItem.FACING);
        this.rotateToSide(direction, mStack);
        int posLong = (int)tile.getBlockPos().asLong();
        for (int i = 0; i < stackList.size(); ++i) {
            ItemStack stack = stackList.get(i);
            mStack.pushPose();
            if (stack.getItem() instanceof BlockItem) {
                mStack.translate(PlacedItem.getXOffset(i, stackList.size()), -0.3125, PlacedItem.getZOffset(i, stackList.size()));
                mStack.mulPose(Axis.YP.rotationDegrees((float)tile.rotation[i].get() * -22.5f));
                if (direction.getAxis() != Direction.Axis.Y) {
                    mStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                }
                mStack.scale(0.75f, 0.75f, 0.75f);
            } else {
                mStack.translate(PlacedItem.getXOffset(i, stackList.size()), -0.5 + 0.034375 * (double)scale, PlacedItem.getZOffset(i, stackList.size()));
                mStack.mulPose(Axis.YP.rotationDegrees((float)tile.rotation[i].get() * -22.5f));
                mStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                mStack.scale(scale, scale, scale);
            }
            mc.getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, mStack, getter, tile.getLevel(), posLong + i);
            mStack.popPose();
            mStack.translate(0.0f, 5.0E-5f, 0.0f);
        }
        mStack.popPose();
    }

    private void rotateToSide(Direction direction, PoseStack mStack) {
        switch (direction) {
            case DOWN: {
                mStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                break;
            }
            case NORTH: {
                mStack.mulPose(Axis.XN.rotationDegrees(90.0f));
                break;
            }
            case SOUTH: {
                mStack.mulPose(new Quaternionf().rotationXYZ(-1.5707964f, 0.0f, (float)Math.PI));
                break;
            }
            case WEST: {
                mStack.mulPose(new Quaternionf().rotationXYZ(-1.5707964f, 0.0f, 1.5707964f));
                break;
            }
            case EAST: {
                mStack.mulPose(new Quaternionf().rotationXYZ(-1.5707964f, 0.0f, -1.5707964f));
            }
        }
    }

    public AABB getRenderBoundingBox(TilePlacedItem blockEntity) {
        return new AABB(blockEntity.getBlockPos()).inflate(1.0);
    }
}

