/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.blocks.tileentity.TileChaosCrystal;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class RenderTileChaosCrystal
implements BlockEntityRenderer<TileChaosCrystal> {
    private static final RenderType CHAOS_CRYSTAL_INNER = RenderType.create((String)"draconicevolution:chaos_crystal_inner", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> DEShaders.chaosBlockShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"textures/item/equipment/chaos_shader.png"), true, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).setLightmapState(RenderStateShard.LIGHTMAP).createCompositeState(false));
    private static final RenderType CHAOS_CRYSTAL = RenderType.create((String)"draconicevolution:chaos_crystal", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getRendertypeCutoutShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"textures/block/chaos_crystal.png"), false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setLightmapState(RenderStateShard.LIGHTMAP).createCompositeState(false));
    private static final RenderType CHAOS_CRYSTAL_SHIELD = RenderType.create((String)"draconicevolution:chaos_shield_type", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> DEShaders.shieldShader)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setLightmapState(RenderStateShard.LIGHTMAP).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));
    private final CCModel model;

    public RenderTileChaosCrystal(BlockEntityRendererProvider.Context context) {
        Map map = new OBJParser(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"models/block/chaos_crystal.obj")).ignoreMtl().parse();
        this.model = CCModel.combine(map.values()).backfacedCopy().computeNormals();
    }

    public int getViewDistance() {
        return 256;
    }

    public void render(TileChaosCrystal te, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        if (te.parentPos.notNull()) {
            return;
        }
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        mat.translate(0.5, 0.5, 0.5);
        mat.rotate((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 180.0f), Vector3.Y_POS);
        mat.scale(0.75);
        LocalPlayer player = Minecraft.getInstance().player;
        DEShaders.chaosBlockTime.glUniform1f((float)ClientUtils.getRenderTime());
        DEShaders.chaosBlockYaw.glUniform1f((float)((double)player.getYRot() * 0.017453292519943));
        DEShaders.chaosBlockPitch.glUniform1f((float)(-((double)player.getXRot() * 0.017453292519943)));
        ccrs.bind(CHAOS_CRYSTAL_INNER, getter);
        this.model.render(ccrs, new IVertexOperation[]{mat});
        ccrs.baseColour = -16;
        ccrs.bind(CHAOS_CRYSTAL, getter);
        this.model.render(ccrs, new IVertexOperation[]{mat});
        if (!te.guardianDefeated.get()) {
            DEShaders.shieldBarMode.glUniform1i(0);
            DEShaders.shieldActivation.glUniform1f(1.0f);
            DEShaders.shieldColour.glUniform4f(1.0f, 0.0f, 0.0f, 1.0f);
            ccrs.bind(CHAOS_CRYSTAL_SHIELD, getter);
            this.model.render(ccrs, new IVertexOperation[]{mat});
        }
    }

    public AABB getRenderBoundingBox(TileChaosCrystal blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity).inflate(3.0);
    }
}

