/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.ModularGuiContainer;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiManipulable;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiSlots;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.elements.GuiTexture;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.ForegroundRender;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.container.ContainerGuiProvider;
import codechicken.lib.gui.modular.lib.container.ContainerScreenAccess;
import codechicken.lib.gui.modular.lib.container.SlotGroup;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.Direction;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.ShaderEnergyBar;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.ButtonRow;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyTransfuser;
import com.brandon3055.draconicevolution.client.DEGuiTextures;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyTransfuser;
import com.brandon3055.draconicevolution.inventory.TransfuserMenu;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EnergyTransfuserGui
extends ContainerGuiProvider<TransfuserMenu> {
    private static final GuiToolkit TOOLKIT = new GuiToolkit("gui.draconicevolution.transfuser");
    public static final int GUI_WIDTH = 218;
    public static final int GUI_HEIGHT = 215;

    public GuiElement<?> createRootElement(ModularGui gui) {
        GuiManipulable root = new GuiManipulable((GuiParent)gui).addMoveHandle(3).enableCursors(true);
        GuiTexture bg = new GuiTexture((GuiParent)root.getContentElement(), DEGuiTextures.themedGetter("transfuser"));
        Constraints.bind((ConstrainedGeometry)bg, (ConstrainedGeometry)root.getContentElement());
        return root;
    }

    public void buildGui(ModularGui gui, ContainerScreenAccess<TransfuserMenu> screenAccess) {
        gui.initStandardGui(218, 215);
        TransfuserMenu menu = (TransfuserMenu)screenAccess.getMenu();
        TileEnergyTransfuser tile = (TileEnergyTransfuser)menu.tile;
        GuiElement root = gui.getRoot();
        GuiText title = TOOLKIT.createHeading((GuiParent)root, gui.getGuiTitle(), true);
        ButtonRow buttonRow = ButtonRow.topRightInside((GuiElement)root, (Direction)Direction.DOWN, (int)3, (int)3).setSpacing(1.0);
        buttonRow.addButton(arg_0 -> ((GuiToolkit)TOOLKIT).createThemeButton(arg_0));
        buttonRow.addButton(e -> TOOLKIT.createRSSwitch((GuiParent)e, (IRSSwitchable)((TransfuserMenu)screenAccess.getMenu()).tile));
        GuiSlots.PlayerAll playInv = GuiSlots.playerAllSlots((GuiParent)root, screenAccess, (SlotGroup)menu.main, (SlotGroup)menu.hotBar, (SlotGroup)menu.armor, (SlotGroup)menu.offhand);
        playInv.stream().forEach(e -> e.setSlotTexture(slot -> BCGuiTextures.getThemed((String)"slot")));
        Constraints.placeInside((ConstrainedGeometry)playInv.container(), (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)-7.0);
        GuiText invTitle = TOOLKIT.playerInvTitle((GuiElement)playInv.main());
        int padding = 3;
        int columnWidth = 24;
        for (int i = 0; i < 4; ++i) {
            int fi = i;
            GuiRectangle column = (GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle((GuiParent)root).shadedRect(() -> GuiToolkit.Palette.Ctrl.accentLight((boolean)false), () -> GuiToolkit.Palette.Ctrl.accentDark((boolean)false), () -> GuiToolkit.Palette.Ctrl.fill((boolean)false)).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)columnWidth))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)invTitle.get(GeoParam.TOP), (double)(-padding)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)title.get(GeoParam.BOTTOM), (double)padding))).constrain(GeoParam.LEFT, (Constraint)Constraint.between((GeoRef)playInv.main().get(GeoParam.LEFT), (GeoRef)playInv.main().get(GeoParam.RIGHT), (double)((double)i / 3.0), (double)(-((double)(columnWidth * i) / 3.0))));
            GuiSlots slot = (GuiSlots)((GuiSlots)GuiSlots.singleSlot((GuiParent)root, screenAccess, (SlotGroup)menu.slotGroups[i], (int)0).setSlotTexture(e -> BCGuiTextures.getThemed((String)"slot")).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)column.get(GeoParam.LEFT), (double)3.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)column.get(GeoParam.BOTTOM), (double)-3.0));
            Constraints.bind((ConstrainedGeometry)new SlotLetter((GuiParent<?>)slot, i, tile).setEnabled(() -> !menu.slotGroups[fi].getSlot(0).hasItem()), (ConstrainedGeometry)slot);
            GuiButton button = ((GuiButton)TOOLKIT.createBorderlessButton((GuiParent)column).setResetHoverOnPress(false).setTooltipSingle(() -> TOOLKIT.translate(((TileEnergyTransfuser.ItemIOMode)tile.ioModes[fi].get()).getName(), new Object[0]))).onPress(() -> tile.ioModes[fi].set((Enum)((TileEnergyTransfuser.ItemIOMode)tile.ioModes[fi].get()).nextMode(Screen.hasShiftDown())), 0).onPress(() -> tile.ioModes[fi].set((Enum)((TileEnergyTransfuser.ItemIOMode)tile.ioModes[fi].get()).nextMode(true)), 1);
            Constraints.size((ConstrainedGeometry)button, (double)16.0, (double)16.0);
            Constraints.placeOutside((ConstrainedGeometry)button, (ConstrainedGeometry)slot, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)-1.0);
            Constraints.bind((ConstrainedGeometry)new GuiTexture((GuiParent)button, () -> DEGuiTextures.get(((TileEnergyTransfuser.ItemIOMode)tile.ioModes[fi].get()).getSpriteName())), (ConstrainedGeometry)button);
            ShaderEnergyBar.EnergyBar energyBar = TOOLKIT.createEnergyBar((GuiParent)root, null);
            ((GuiRectangle)((GuiRectangle)((GuiRectangle)energyBar.container().constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)column.get(GeoParam.TOP), (double)3.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)column.get(GeoParam.LEFT), (double)3.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)column.get(GeoParam.RIGHT), (double)-3.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)button.get(GeoParam.TOP), (double)-1.0));
            energyBar.bar().setShaderEnabled(() -> tile.itemsCombined.getStackInSlot(fi).getCapability(CapabilityOP.ITEM) != null).setItemSupplier(() -> tile.itemsCombined.getStackInSlot(fi)).setDisabled(() -> !EnergyUtils.isEnergyItem((ItemStack)tile.itemsCombined.getStackInSlot(fi)));
        }
        GuiButton modeButton = ((GuiButton)((GuiButton)((GuiButton)TOOLKIT.createBorderlessButton((GuiParent)root).setResetHoverOnPress(false).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)6.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)invTitle.get(GeoParam.TOP), (double)-3.0))).setTooltipSingle(() -> TOOLKIT.translate(tile.balancedMode.get() ? "balanced_charge" : "sequential_charge", new Object[0]))).onPress(() -> tile.balancedMode.invert());
        Constraints.size((ConstrainedGeometry)modeButton, (double)20.0, (double)20.0);
        Constraints.bind((ConstrainedGeometry)new GuiTexture((GuiParent)modeButton, () -> DEGuiTextures.get("transfuser/" + (tile.balancedMode.get() ? "balanced_charge" : "sequential_charge"))), (ConstrainedGeometry)modeButton, (double)1.0);
    }

    private static class SlotLetter
    extends GuiElement<SlotLetter>
    implements ForegroundRender {
        private final int index;
        private final TileEnergyTransfuser tile;

        public SlotLetter(@NotNull GuiParent<?> parent, int index, TileEnergyTransfuser tile) {
            super(parent);
            this.index = index;
            this.tile = tile;
        }

        public void renderForeground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
            render.pose().pushPose();
            render.pose().translate(this.xMin() + (double)(this.index == 0 ? 5 : (this.index == 2 ? 7 : 4)), this.yMin() + 2.0, 0.0);
            render.pose().scale(2.0f, 2.0f, 2.0f);
            render.drawString(RenderTileEnergyTransfuser.TEXT[this.index].getVisualOrderText(), 0.0, 0.0, ((TileEnergyTransfuser.ItemIOMode)this.tile.ioModes[this.index].get()).getColour(), false);
            render.pose().popPose();
        }
    }

    public static class Screen
    extends ModularGuiContainer<TransfuserMenu> {
        public Screen(TransfuserMenu menu, Inventory inv, Component title) {
            super((AbstractContainerMenu)menu, inv, (ContainerGuiProvider)new EnergyTransfuserGui());
            this.getModularGui().setGuiTitle(title);
        }
    }
}

