/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.rendering;

import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.brandon3055.draconicevolution.api.energy.IENetEffectTile;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ENetFXHandlerServer<T extends BlockEntity>
extends ENetFXHandler<T> {
    private Map<Byte, Byte> lastTickIndexToFlow = new HashMap<Byte, Byte>();
    private long lastTickEnergy = -1L;

    public ENetFXHandlerServer(T tile) {
        super(tile);
    }

    @Override
    public void update() {
    }

    @Override
    public void detectAndSendChanges() {
        this.lastTickIndexToFlow.clear();
        CrystalUpdateBatcher.BatchedCrystalUpdate update = new CrystalUpdateBatcher.BatchedCrystalUpdate(((IENetEffectTile)this.tile).getIDHash(), ((ICrystalLink)this.tile).getEnergyStored());
        for (byte i = 0; i < ((IENetEffectTile)this.tile).getFlowRates().size(); i = (byte)(i + 1)) {
            byte flow = ((IENetEffectTile)this.tile).getFlowRates().get(i);
            if (this.lastTickIndexToFlow.containsKey(i) && this.lastTickIndexToFlow.get(i) == flow) continue;
            update.indexToFlowMap.put(i, flow);
            this.lastTickIndexToFlow.put(i, flow);
        }
        if (update.indexToFlowMap.size() > 0 || Math.abs(this.lastTickEnergy - ((ICrystalLink)this.tile).getEnergyStored()) > 100L) {
            this.lastTickEnergy = ((ICrystalLink)this.tile).getEnergyStored();
            this.queUpdate(update);
        }
    }

    @Override
    public void reloadConnections() {
        this.lastTickIndexToFlow.clear();
    }

    private void queUpdate(CrystalUpdateBatcher.BatchedCrystalUpdate update) {
        ServerLevel serverWorld = (ServerLevel)this.tile.getLevel();
        if (serverWorld != null) {
            serverWorld.getChunkSource().chunkMap.getPlayers(new ChunkPos(this.tile.getBlockPos()), false).forEach(player -> CrystalUpdateBatcher.queData(update, player));
        }
    }
}

