/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import codechicken.lib.raytracer.IndexedVoxelShape;
import codechicken.lib.raytracer.MultiIndexedVoxelShape;
import codechicken.lib.raytracer.SubHitBlockHitResult;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.brandonscore.lib.CustomTabHandling;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePlacedItem;
import com.brandon3055.draconicevolution.init.DEContent;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PlacedItem
extends EntityBlockBCore
implements CustomTabHandling {
    private static final VoxelShape FALLBACK_SHAPE = Shapes.box((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);
    private static Int2ObjectMap<VoxelShape> SHAPE_CACHE = new Int2ObjectOpenHashMap();
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    public PlacedItem(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP));
        this.setBlockEntity(() -> DEContent.TILE_PLACED_ITEM.get(), true);
    }

    private static VoxelShape computeShape(int stackCount, boolean tool, boolean[] isBlock, Direction facing, boolean getCollisionShape) {
        int shapeConfig = 0;
        shapeConfig |= facing.ordinal() & 7;
        shapeConfig |= (tool ? 1 : 0) << 3;
        shapeConfig |= (getCollisionShape ? 1 : 0) << 4;
        for (int i = 0; i < stackCount; ++i) {
            shapeConfig |= (2 | (isBlock[i] ? 1 : 0)) << 5 + i * 2;
        }
        return (VoxelShape)SHAPE_CACHE.computeIfAbsent(shapeConfig, integer -> {
            Cuboid6 baseCuboid = new Cuboid6(0.5, 0.0, 0.5, 0.5, 0.0, 0.5);
            ArrayList<Cuboid6> stackCuboids = new ArrayList<Cuboid6>();
            boolean toolSize = tool && stackCount == 1;
            for (int i = 0; i < stackCount; ++i) {
                double xOffset = PlacedItem.getXOffset(i, stackCount);
                double zOffset = PlacedItem.getZOffset(i, stackCount);
                double xzSize = 3.5;
                double ySize = 0.029296875;
                if (isBlock[i]) {
                    xzSize = 3.0;
                    ySize = 0.375;
                } else if (toolSize) {
                    xzSize = 7.0;
                    ySize = 0.056640625;
                }
                Cuboid6 stackBox = new Cuboid6((8.0 - xzSize) / 16.0 + xOffset, 0.0, (8.0 - xzSize) / 16.0 + zOffset, (8.0 + xzSize) / 16.0 + xOffset, ySize, (8.0 + xzSize) / 16.0 + zOffset);
                baseCuboid.enclose(stackBox);
                stackCuboids.add(stackBox);
            }
            if (getCollisionShape) {
                PlacedItem.rotateCuboid(baseCuboid, facing);
                return VoxelShapeCache.getShape((Cuboid6)baseCuboid);
            }
            baseCuboid.expand(0.015625);
            baseCuboid.max.y = 0.00625;
            baseCuboid.min.y = 0.0;
            PlacedItem.rotateCuboid(baseCuboid, facing);
            ImmutableSet.Builder cuboids = ImmutableSet.builder();
            IndexedVoxelShape baseShape = new IndexedVoxelShape(VoxelShapeCache.getShape((Cuboid6)baseCuboid), (Object)0);
            cuboids.add((Object)baseShape);
            for (int i = 0; i < stackCuboids.size(); ++i) {
                PlacedItem.rotateCuboid((Cuboid6)stackCuboids.get(i), facing);
                cuboids.add((Object)new IndexedVoxelShape(VoxelShapeCache.getShape((Cuboid6)((Cuboid6)stackCuboids.get(i))), (Object)(1 + i)));
            }
            return new MultiIndexedVoxelShape((VoxelShape)baseShape, cuboids.build());
        });
    }

    private static void rotateCuboid(Cuboid6 cuboid, Direction rotation) {
        switch (rotation) {
            case DOWN: {
                cuboid.apply(new Rotation(3.1415926535897403, Vector3.X_POS).at(new Vector3(0.5, 0.5, 0.5)));
                break;
            }
            case NORTH: {
                cuboid.apply(new Rotation(-1.5707963267948701, Vector3.X_POS).at(new Vector3(0.5, 0.5, 0.5)));
                break;
            }
            case SOUTH: {
                cuboid.apply(new Rotation(-1.5707963267948701, Vector3.X_POS).at(new Vector3(0.5, 0.5, 0.5)));
                cuboid.apply(new Rotation(3.1415926535897403, Vector3.Y_POS).at(new Vector3(0.5, 0.5, 0.5)));
                break;
            }
            case WEST: {
                cuboid.apply(new Rotation(-1.5707963267948701, Vector3.X_POS).at(new Vector3(0.5, 0.5, 0.5)));
                cuboid.apply(new Rotation(1.5707963267948701, Vector3.Y_POS).at(new Vector3(0.5, 0.5, 0.5)));
                break;
            }
            case EAST: {
                cuboid.apply(new Rotation(-1.5707963267948701, Vector3.X_POS).at(new Vector3(0.5, 0.5, 0.5)));
                cuboid.apply(new Rotation(-1.5707963267948701, Vector3.Y_POS).at(new Vector3(0.5, 0.5, 0.5)));
            }
        }
    }

    public static double getXOffset(int index, int count) {
        double spacing = 0.25;
        double lowerVal = 3.5 + spacing;
        double upperVal = 7.0 + spacing * 2.0;
        if (count == 1) {
            return 0.0;
        }
        if (count == 2) {
            return -(lowerVal / 16.0) + (double)index * (upperVal / 16.0);
        }
        if (count == 3) {
            return index == 2 ? 0.0 : -(lowerVal / 16.0) + (double)index * (upperVal / 16.0);
        }
        return -(lowerVal / 16.0) + (double)(index % 2) * (upperVal / 16.0);
    }

    public static double getZOffset(int index, int count) {
        if (count <= 2) {
            return 0.0;
        }
        double spacing = 0.25;
        double lowerVal = 3.5 + spacing;
        return index <= 1 ? -(lowerVal / 16.0) : lowerVal / 16.0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        BlockEntity te = reader.getBlockEntity(pos);
        if (te instanceof TilePlacedItem) {
            TilePlacedItem tile = (TilePlacedItem)te;
            return PlacedItem.computeShape(tile.stackCount.get(), tile.toolMode.get(), tile.getBlockArray(), (Direction)state.getValue((Property)FACING), false);
        }
        return FALLBACK_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        BlockEntity te = reader.getBlockEntity(pos);
        if (te instanceof TilePlacedItem) {
            TilePlacedItem tile = (TilePlacedItem)te;
            return PlacedItem.computeShape(tile.stackCount.get(), tile.toolMode.get(), tile.getBlockArray(), (Direction)state.getValue((Property)FACING), true);
        }
        return FALLBACK_SHAPE;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof TilePlacedItem && target instanceof SubHitBlockHitResult) {
            List<ItemStack> stacks = ((TilePlacedItem)tile).getStacksInOrder();
            int index = ((SubHitBlockHitResult)target).subHit - 1;
            if (index >= 0 && index < stacks.size()) {
                ItemStack stack = stacks.get(index).copy();
                stack.setCount(1);
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof TilePlacedItem) {
            ((TilePlacedItem)tile).onBroken(player, pos, false);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        level.levelEvent(player, 2001, pos, PlacedItem.getId((BlockState)state));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addLandingEffects(BlockState state1, ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        return true;
    }
}

