/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities.logic;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.inventory.BlockToStackHelper;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.draconicevolution.init.EquipCfg;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.level.BlockEvent;

public interface IHarvestHandler {
    public boolean start(BlockPos var1, Level var2, ServerPlayer var3);

    public void tick(Level var1, ServerPlayer var2, ItemStack var3, IOPStorage var4, InventoryDynamic var5);

    public boolean isDone();

    public void stop(Level var1, ServerPlayer var2);

    default public void doHarvest(ItemStack stack, Player player, Level level, BlockPos pos, IOPStorage storage, InventoryDynamic stackCollector) {
        if (level.isClientSide || storage.getOPStored() < (long)EquipCfg.energyHarvest && !player.getAbilities().instabuild) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        FluidState fluidState = level.getFluidState(pos);
        Block block = state.getBlock();
        BlockEvent.BreakEvent event = CommonHooks.fireBlockBreak((Level)level, (GameType)((ServerPlayer)player).gameMode.getGameModeForPlayer(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos, (BlockState)state);
        if (event.isCanceled()) {
            ServerPlayer mpPlayer = (ServerPlayer)player;
            mpPlayer.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            return;
        }
        if (player.getAbilities().instabuild) {
            if (block.onDestroyedByPlayer(state, level, pos, player, false, fluidState)) {
                block.destroy((LevelAccessor)level, pos, state);
            }
            ((ServerPlayer)player).connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            return;
        }
        stack.mineBlock(level, state, pos, player);
        BlockToStackHelper.breakAndCollectWithPlayer((Level)level, (BlockPos)pos, (InventoryDynamic)stackCollector, (Player)player);
        storage.modifyEnergyStored((long)(-EquipCfg.energyHarvest));
    }
}

