/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.brandonscore.api.BCStreamCodec;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleHelper;
import com.brandon3055.draconicevolution.api.modules.data.TreeHarvestData;
import com.brandon3055.draconicevolution.api.modules.entities.logic.ForestHarvestHandler;
import com.brandon3055.draconicevolution.api.modules.entities.logic.IHarvestHandler;
import com.brandon3055.draconicevolution.api.modules.entities.logic.TreeHarvestHandler;
import com.brandon3055.draconicevolution.api.modules.lib.EntityOverridesItemUse;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.init.ItemData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class TreeHarvestEntity
extends ModuleEntity<TreeHarvestData>
implements EntityOverridesItemUse {
    private static final Map<UUID, IHarvestHandler> activeHandlers = new HashMap<UUID, IHarvestHandler>();
    private InventoryDynamic itemBuffer = new InventoryDynamic();
    private BooleanProperty harvestLeaves = new BooleanProperty("tree_harvest_mod.leaves", true).setFormatter(ConfigProperty.BooleanFormatter.YES_NO);
    private IntegerProperty harvestRange = new IntegerProperty("tree_harvest_mod.range", ((TreeHarvestData)this.module.getData()).range()).setFormatter(ConfigProperty.IntegerFormatter.RAW).range(0, ((TreeHarvestData)this.module.getData()).range());
    public static final Codec<TreeHarvestEntity> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DEModules.codec().fieldOf("module").forGetter(ModuleEntity::getModule), (App)Codec.INT.fieldOf("gridx").forGetter(ModuleEntity::getGridX), (App)Codec.INT.fieldOf("gridy").forGetter(ModuleEntity::getGridY), (App)InventoryDynamic.CODEC.fieldOf("item_buffer").forGetter(e -> e.itemBuffer), (App)BooleanProperty.CODEC.fieldOf("harvest_leaves").forGetter(e -> e.harvestLeaves), (App)IntegerProperty.CODEC.fieldOf("harvest_range").forGetter(e -> e.harvestRange)).apply((Applicative)builder, TreeHarvestEntity::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TreeHarvestEntity> STREAM_CODEC = BCStreamCodec.composite(DEModules.streamCodec(), ModuleEntity::getModule, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridX, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridY, (StreamCodec)InventoryDynamic.STREAM_CODEC, e -> e.itemBuffer, BooleanProperty.STREAM_CODEC, e -> e.harvestLeaves, IntegerProperty.STREAM_CODEC, e -> e.harvestRange, TreeHarvestEntity::new);

    public TreeHarvestEntity(Module<TreeHarvestData> module) {
        super(module);
    }

    TreeHarvestEntity(Module<?> module, int gridX, int gridY, InventoryDynamic itemBuffer, BooleanProperty harvestLeaves, IntegerProperty harvestRange) {
        super(module, gridX, gridY);
        this.itemBuffer = itemBuffer;
        this.harvestLeaves = harvestLeaves;
        this.harvestRange = harvestRange;
    }

    @Override
    public ModuleEntity<?> copy() {
        return new TreeHarvestEntity(this.module, this.getGridX(), this.getGridY(), this.itemBuffer.copy(), this.harvestLeaves.copy(), this.harvestRange.copy());
    }

    @Override
    public void getEntityProperties(List<ConfigProperty> properties) {
        super.getEntityProperties(properties);
        properties.add(this.harvestLeaves);
        properties.add(this.harvestRange);
    }

    private void useTick(LivingEntityUseItemEvent.Tick event) {
        LivingEntity livingEntity;
        IHarvestHandler activeHandler = activeHandlers.get(event.getEntity().getUUID());
        if (activeHandler == null || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ItemStack stack = event.getItem();
        IOPStorage storage = (IOPStorage)stack.getCapability(CapabilityOP.ITEM);
        if (storage == null) {
            return;
        }
        activeHandler.tick(player.level(), player, stack, storage, this.itemBuffer);
        this.markDirty();
        if (this.itemBuffer.getStacks().size() > 8) {
            this.dropContents((Entity)player, stack);
        }
    }

    private void endUse(LivingEntityUseItemEvent event) {
        LivingEntity livingEntity;
        IHarvestHandler activeHandler = activeHandlers.get(event.getEntity().getUUID());
        if (activeHandler != null && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            activeHandler.stop(player.level(), player);
        }
        activeHandlers.remove(event.getEntity().getUUID());
        this.dropContents((Entity)event.getEntity(), event.getItem());
    }

    private void dropContents(Entity entity, ItemStack stack) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!this.itemBuffer.isEmpty()) {
                ModuleHelper.handleItemCollection((Player)serverPlayer, this.host, EnergyUtils.getStorage((ItemStack)stack), this.itemBuffer);
                this.itemBuffer.clearContent();
                this.markDirty();
            }
        }
    }

    @Override
    public void onEntityUseItem(LivingEntityUseItemEvent useEvent) {
        ICancellableEvent cancellable;
        if (useEvent instanceof ICancellableEvent && (cancellable = (ICancellableEvent)useEvent).isCanceled()) {
            return;
        }
        if (useEvent instanceof LivingEntityUseItemEvent.Start) {
            LivingEntityUseItemEvent.Start event = (LivingEntityUseItemEvent.Start)useEvent;
            event.setDuration(72000);
        } else if (useEvent instanceof LivingEntityUseItemEvent.Tick) {
            LivingEntityUseItemEvent.Tick event = (LivingEntityUseItemEvent.Tick)useEvent;
            this.useTick(event);
        } else if (useEvent instanceof LivingEntityUseItemEvent.Stop || useEvent instanceof LivingEntityUseItemEvent.Finish) {
            this.endUse(useEvent);
        }
    }

    @Override
    public void onPlayerInteractEvent(PlayerInteractEvent.RightClickItem event) {
        if (event.isCanceled()) {
            return;
        }
        TreeHarvestData data = (TreeHarvestData)this.getModule().getData();
        IHarvestHandler activeHandler = activeHandlers.get(event.getEntity().getUUID());
        if (activeHandler == null) {
            if (data.range() <= 0) {
                return;
            }
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                activeHandler = new ForestHarvestHandler(data.speed(), this.harvestRange.getValue(), this.harvestLeaves.getValue());
                activeHandler.start(event.getPos(), event.getLevel(), player2);
                activeHandlers.put(event.getEntity().getUUID(), activeHandler);
                this.markDirty();
            }
        } else {
            return;
        }
        event.setCanceled(true);
        event.getEntity().startUsingItem(event.getHand());
    }

    @Override
    public void onPlayerInteractEvent(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        TreeHarvestData data = (TreeHarvestData)this.getModule().getData();
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            TreeHarvestHandler activeHandler = new TreeHarvestHandler(data.speed(), event.getHitVec().getDirection(), this.harvestLeaves.getValue());
            activeHandler.start(event.getPos(), event.getLevel(), player2);
            activeHandlers.put(event.getEntity().getUUID(), activeHandler);
            this.markDirty();
        }
        event.setCanceled(true);
        event.getEntity().startUsingItem(event.getHand());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHostHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"module.draconicevolution.tree_harvest.single").withStyle(ChatFormatting.DARK_GRAY));
            if (((TreeHarvestData)this.getModule().getData()).range() > 0) {
                tooltip.add((Component)Component.translatable((String)"module.draconicevolution.tree_harvest.area").withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void modifyFirstPersonUsingPose(RenderHandEvent event, boolean leftHand) {
        PoseStack poseStack = event.getPoseStack();
        LocalPlayer player = Minecraft.getInstance().player;
        int handOffset = !leftHand ? 1 : -1;
        poseStack.translate((float)handOffset * -0.2785682f, 0.18344387f, 0.15731531f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-13.935f));
        poseStack.mulPose(Axis.YP.rotationDegrees((float)handOffset * 35.3f));
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)handOffset * -9.785f));
        float drawTime = 72000.0f - ((float)player.getUseItemRemainingTicks() - event.getPartialTick() + 1.0f);
        float charge = drawTime / 20.0f;
        charge = (charge * charge + charge * 2.0f) / 3.0f;
        if (charge > 1.0f) {
            charge = 1.0f;
        }
        if (charge > 0.1f) {
            float f15 = Mth.sin((float)((drawTime - 0.1f) * 1.3f));
            float f18 = charge - 0.1f;
            float animOffset = f15 * f18;
            poseStack.translate(animOffset * 0.0f, animOffset * 0.004f, animOffset * 0.0f);
        }
        poseStack.translate(charge * 0.0f, charge * 0.0f, charge * 0.04f);
        poseStack.scale(1.0f, 1.0f, 1.0f + charge * 0.2f);
        poseStack.mulPose(Axis.YN.rotationDegrees((float)handOffset * 45.0f));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void modifyPlayerModelPose(Player player, PlayerModel<?> model, boolean leftHand) {
        if (!leftHand) {
            model.rightArm.yRot = -0.1f + model.head.yRot;
            model.leftArm.yRot = 0.1f + model.head.yRot + 0.4f;
            model.rightArm.xRot = -1.5707964f + model.head.xRot;
            model.leftArm.xRot = -1.5707964f + model.head.xRot;
        } else {
            model.rightArm.yRot = -0.1f + model.head.yRot - 0.4f;
            model.leftArm.yRot = 0.1f + model.head.yRot;
            model.rightArm.xRot = -1.5707964f + model.head.xRot;
            model.leftArm.xRot = -1.5707964f + model.head.xRot;
        }
        model.leftPants.copyFrom(model.leftLeg);
        model.rightPants.copyFrom(model.rightLeg);
        model.leftSleeve.copyFrom(model.leftArm);
        model.rightSleeve.copyFrom(model.rightArm);
        model.jacket.copyFrom(model.body);
    }

    @Override
    public void saveEntityToStack(ItemStack stack, ModuleContext context) {
        stack.set(ItemData.TREE_MODULE_INVENTORY, (Object)this.itemBuffer.copy());
        stack.set(ItemData.BOOL_ITEM_PROP_1, (Object)this.harvestLeaves.copy());
        stack.set(ItemData.INT_ITEM_PROP_1, (Object)this.harvestRange.copy());
    }

    @Override
    public void loadEntityFromStack(ItemStack stack, ModuleContext context) {
        this.itemBuffer = ((InventoryDynamic)stack.getOrDefault(ItemData.TREE_MODULE_INVENTORY, (Object)this.itemBuffer)).copy();
        this.harvestLeaves = ((BooleanProperty)stack.getOrDefault(ItemData.BOOL_ITEM_PROP_1, (Object)this.harvestLeaves)).copy();
        this.harvestRange = ((IntegerProperty)stack.getOrDefault(ItemData.INT_ITEM_PROP_1, (Object)this.harvestRange)).copy();
    }
}

