/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.sprite.Material;
import codechicken.lib.inventory.InventoryUtils;
import com.brandon3055.brandonscore.api.BCStreamCodec;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.NoData;
import com.brandon3055.draconicevolution.api.modules.entities.FilteredModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.client.DEGuiTextures;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ItemData;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EnderCollectionEntity
extends FilteredModuleEntity<NoData> {
    protected CompoundTag frequencyTag = new CompoundTag();
    protected BooleanProperty filterEnabled = this.createEnabledProperty("ender_collection_mod", false);
    public static final Codec<EnderCollectionEntity> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DEModules.codec().fieldOf("module").forGetter(ModuleEntity::getModule), (App)Codec.INT.fieldOf("gridx").forGetter(ModuleEntity::getGridX), (App)Codec.INT.fieldOf("gridy").forGetter(ModuleEntity::getGridY), (App)FILTERS_CODEC.fieldOf("filters").forGetter(e -> e.filters), (App)CompoundTag.CODEC.fieldOf("frequency_tag").forGetter(e -> e.frequencyTag), (App)BooleanProperty.CODEC.fieldOf("enabled").forGetter(e -> e.filterEnabled)).apply((Applicative)builder, EnderCollectionEntity::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EnderCollectionEntity> STREAM_CODEC = BCStreamCodec.composite(DEModules.streamCodec(), ModuleEntity::getModule, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridX, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridY, (StreamCodec)FILTERS_STREAM_CODEC, e -> e.filters, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, e -> e.frequencyTag, BooleanProperty.STREAM_CODEC, e -> e.filterEnabled, EnderCollectionEntity::new);

    public EnderCollectionEntity(Module<NoData> module) {
        super(module, module.getProperties().getTechLevel() == TechLevel.DRACONIC ? 9 : 0);
    }

    EnderCollectionEntity(Module<?> module, int gridX, int gridY, List<FilteredModuleEntity.Filter> filters, CompoundTag frequencyTag, BooleanProperty filterEnabled) {
        super(module, gridX, gridY, module.getProperties().getTechLevel() == TechLevel.DRACONIC ? 9 : 0, filters);
        this.frequencyTag = frequencyTag;
        this.filterEnabled = filterEnabled;
    }

    @Override
    public ModuleEntity<?> copy() {
        return new EnderCollectionEntity(this.module, this.getGridX(), this.getGridY(), this.copyFilters(this.filters), this.frequencyTag.copy(), this.filterEnabled.copy());
    }

    @Override
    public void getEntityProperties(List<ConfigProperty> properties) {
        super.getEntityProperties(properties);
        properties.add(this.filterEnabled);
    }

    @Override
    protected List<FilteredModuleEntity.Slot> layoutSlots(int x, int y, int width, int height) {
        ArrayList<FilteredModuleEntity.Slot> slots = new ArrayList<FilteredModuleEntity.Slot>();
        double slotXSize = (double)width / 3.0;
        double slotYSize = (double)height / 3.0;
        for (int i = 0; i < this.slotsCount; ++i) {
            double xPos = (double)x + (double)(i % 3) * slotXSize;
            double yPos = (double)y + (double)(i / 3) * slotYSize;
            slots.add(new FilteredModuleEntity.Slot(i, xPos, yPos, slotXSize));
        }
        return slots;
    }

    @Override
    public boolean isEnabled() {
        return this.filterEnabled.getValue();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected Material getSlotOverlay() {
        return BCGuiTextures.get((String)"slots/filter");
    }

    @Override
    public void saveEntityToStack(ItemStack stack, ModuleContext context) {
        super.saveEntityToStack(stack, context);
        stack.set(ItemData.BOOL_ITEM_PROP_1, (Object)this.filterEnabled.copy());
        stack.set(ItemData.ENDER_MODULE_FREQUENCY, (Object)CustomData.of((CompoundTag)this.frequencyTag));
    }

    @Override
    public void loadEntityFromStack(ItemStack stack, ModuleContext context) {
        super.loadEntityFromStack(stack, context);
        this.filterEnabled = ((BooleanProperty)stack.getOrDefault(ItemData.BOOL_ITEM_PROP_1, (Object)this.filterEnabled)).copy();
        this.frequencyTag = ((CustomData)stack.getOrDefault(ItemData.ENDER_MODULE_FREQUENCY, (Object)CustomData.EMPTY)).copyTag();
    }

    public List<ItemStack> insertStacks(Player player, Collection<ItemStack> stacks, IOPStorage opStorage) {
        if (opStorage == null || !this.isEnabled()) {
            return new ArrayList<ItemStack>(stacks);
        }
        Object container = ModHelper.ENDERSTORAGE ? this.getEnderStorage(player) : player.getEnderChestInventory();
        Predicate<ItemStack> filter = null;
        if (!this.filters.isEmpty()) {
            filter = this.createFilterTest();
        }
        ArrayList<ItemStack> notInserted = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            long cost = (long)EquipCfg.enderModulePerItemEnergy * (long)stack.getCount();
            if (opStorage.getOPStored() < cost || filter != null && !filter.test(stack)) {
                notInserted.add(stack);
                continue;
            }
            opStorage.modifyEnergyStored(-cost);
            int remainder = InventoryUtils.insertItem((Container)container, (ItemStack)stack, (boolean)false);
            if (remainder <= 0) continue;
            stack.setCount(remainder);
            notInserted.add(stack);
        }
        return notInserted;
    }

    public int insertStack(Player player, ItemStack stack, IOPStorage opStorage) {
        if (!this.isEnabled()) {
            return stack.getCount();
        }
        Object container = ModHelper.ENDERSTORAGE ? this.getEnderStorage(player) : player.getEnderChestInventory();
        Predicate<ItemStack> filter = null;
        if (!this.filters.isEmpty()) {
            filter = this.createFilterTest();
        }
        long cost = (long)EquipCfg.enderModulePerItemEnergy * (long)stack.getCount();
        if (opStorage.getOPStored() < cost || filter != null && !filter.test(stack)) {
            return stack.getCount();
        }
        opStorage.modifyEnergyStored(-cost);
        return InventoryUtils.insertItem((Container)container, (ItemStack)stack, (boolean)false);
    }

    private Container getEnderStorage(Player player) {
        if (this.frequencyTag.isEmpty()) {
            return player.getEnderChestInventory();
        }
        Frequency frequency = new Frequency(this.frequencyTag);
        return (Container)EnderStorageManager.instance((boolean)false).getStorage(frequency, EnderItemStorage.TYPE);
    }

    private EnumColour[] getColours() {
        Frequency frequency = new Frequency(this.frequencyTag);
        return new EnumColour[]{frequency.left(), frequency.middle(), frequency.right()};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderModule(GuiElement<?> parent, GuiRender render, int x, int y, int width, int height, double mouseX, double mouseY, boolean renderStack, float partialTicks) {
        float alpha;
        super.renderModule(parent, render, x, y, width, height, mouseX, mouseY, renderStack, partialTicks);
        if (this.frequencyTag.isEmpty() || !ModHelper.ENDERSTORAGE) {
            return;
        }
        float dist = (float)Utils.distToRect((double)x, (double)y, (double)width, (double)height, (double)mouseX, (double)mouseY);
        float f = alpha = dist <= 10.0f ? dist / 10.0f : 1.0f;
        if (alpha == 0.0f) {
            return;
        }
        if (alpha != 1.0f) {
            render.pose().translate(0.0f, 0.0f, 201.0f);
        }
        float p = (float)width / 16.0f;
        float w = p * 2.0f;
        float h = p * 4.0f;
        float mid = (float)x + (float)width / 2.0f;
        float py = (float)y + (float)height / 2.0f - h / 2.0f;
        EnumColour[] colours = this.getColours();
        Material mat = DEGuiTextures.get("misc/es_buttons");
        float hp = 0.03125f;
        for (int i = 0; i < 3; ++i) {
            float px = mid - w / 2.0f - p * 3.0f + (float)i * (p * 3.0f);
            float u = hp * 3.0f + hp * 8.0f * (float)(colours[i].getWoolMeta() % 4);
            float v = hp * 2.0f + hp * 8.0f * (float)(colours[i].getWoolMeta() / 4);
            render.partialSprite(mat.renderType(GuiRender::texColType), (double)px, (double)py, (double)(px + w), (double)(py + h), mat.sprite(), u, v, u + hp * 2.0f, v + hp * 4.0f, 1.0f, 1.0f, 1.0f, alpha);
        }
        if (alpha != 1.0f) {
            render.pose().translate(0.0f, 0.0f, -201.0f);
        }
    }
}

