/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import earth.terrarium.handcrafted.common.blocks.CushionBlock;
import earth.terrarium.handcrafted.common.constants.ConstantComponents;
import earth.terrarium.handcrafted.common.items.TooltipItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class HandcraftedCompat {
    private static final Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> CUSHIONS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    private static final Map<DyenamicDyeColor, DeferredHolder<Item, ? extends Item>> SHEETS = new HashMap<DyenamicDyeColor, DeferredHolder<Item, ? extends Item>>();

    public static void registerBlocks(DyenamicDyeColor color) {
        String prefix = "handcrafted_" + color.getSerializedName();
        CUSHIONS.put(color, DyenamicRegistry.registerBlock(prefix + "_cushion", () -> new CushionBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).lightLevel(state -> color.getLightValue())), () -> new ItemNameBlockItem((Block)CUSHIONS.get(color).get(), new Item.Properties())));
    }

    public static void registerItems(DyenamicDyeColor color) {
        String prefix = "handcrafted_" + color.getSerializedName();
        SHEETS.put(color, DyenamicRegistry.registerItem(prefix + "_sheet", () -> new TooltipItem(ConstantComponents.PLACE_ON_FURNITURE, new Item.Properties())));
    }

    public static void buildTabContents(BuildCreativeModeTabContentsEvent event) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.parse((String)"handcrafted:main"));
        if (event.getTabKey().equals(key)) {
            CUSHIONS.forEach((dyenamicDyeColor, registryObject) -> event.accept((ItemLike)registryObject.get()));
            SHEETS.forEach((dyenamicDyeColor, registryObject) -> event.accept((ItemLike)registryObject.get()));
        }
    }
}

