/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import com.satherov.crystalix.content.CrystalixRegistry;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.common.block.crystalix.DyenamicsCrystalixGlass;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CrystalixCompat {
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> GLASS = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> CLEAR = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();
    public static Map<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>> BORDERED = new HashMap<DyenamicDyeColor, DeferredHolder<Block, ? extends Block>>();

    public static void registerBlocks(DyenamicDyeColor color) {
        String prefix = "crystalix_" + color.getSerializedName();
        GLASS.put(color, DyenamicRegistry.registerBlock(prefix + "_crystalix_glass", () -> new DyenamicsCrystalixGlass(color), true));
        CLEAR.put(color, DyenamicRegistry.registerBlock(prefix + "_clear_crystalix_glass", () -> new DyenamicsCrystalixGlass(color), true));
        BORDERED.put(color, DyenamicRegistry.registerBlock(prefix + "_bordered_crystalix_glass", () -> new DyenamicsCrystalixGlass(color), true));
    }

    public static void buildTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(CrystalixRegistry.CREATIVE_TAB.getKey())) {
            Arrays.stream(DyenamicDyeColor.dyenamicValues()).forEach(dyenamicDyeColor -> {
                event.accept((ItemLike)GLASS.get(dyenamicDyeColor).get());
                event.accept((ItemLike)CLEAR.get(dyenamicDyeColor).get());
                event.accept((ItemLike)BORDERED.get(dyenamicDyeColor).get());
            });
        }
    }

    public static class Client {
        public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            GLASS.forEach((dyenamicDyeColor, registryObject) -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.translucent()));
            CLEAR.forEach((dyenamicDyeColor, registryObject) -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.translucent()));
            BORDERED.forEach((dyenamicDyeColor, registryObject) -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)RenderType.translucent()));
        }
    }
}

