/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.tag;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public class TagSource<T> {
    private final Supplier<@NotNull Registry<T>> _registry;

    public TagSource(Supplier<@NotNull Registry<T>> registrySupplier) {
        this._registry = registrySupplier;
    }

    public TagKey<T> createKey(ResourceLocation id) {
        return TagKey.create((ResourceKey)this._registry.get().key(), (ResourceLocation)id);
    }

    public TagKey<T> createKey(String id) {
        return this.createKey(ResourceLocation.parse((String)id));
    }

    public TagKey<T> createKey(String namespace, String name) {
        return this.createKey(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)name));
    }

    public TagKey<T> createKey(String id, Function<@NotNull String, @NotNull ResourceLocation> factory) {
        return this.createKey(factory.apply(id));
    }

    public TagKey<T> createCommonKey(String name) {
        return this.createKey("c", name);
    }

    public boolean isTagged(T object, TagKey<T> tagKey) {
        Registry<T> registry = this._registry.get();
        return registry.getResourceKey(object).map(arg_0 -> registry.getHolderOrThrow(arg_0)).map(holder -> holder.is(tagKey)).orElse(false);
    }

    public boolean exist(TagKey<T> tagKey) {
        return this._registry.get().getTag(tagKey).isPresent();
    }

    public boolean existWithContent(TagKey<T> tagKey) {
        return !this.getObjects(tagKey).isEmpty();
    }

    public List<T> getObjects(TagKey<T> tagKey) {
        LinkedList list = new LinkedList();
        this._registry.get().getTagOrEmpty(tagKey).forEach(holder -> list.add(holder.value()));
        return list.isEmpty() ? ObjectLists.emptyList() : ObjectLists.unmodifiable((ObjectList)new ObjectArrayList(list));
    }

    public Optional<T> getFirstObject(TagKey<T> tagKey) {
        List<T> objects = this.getObjects(tagKey);
        return objects.isEmpty() ? Optional.empty() : Optional.ofNullable(objects.getFirst());
    }

    public List<TagKey<T>> getTags(T object) {
        Registry<T> registry = this._registry.get();
        List list = registry.getResourceKey(object).map(arg_0 -> registry.getHolderOrThrow(arg_0)).map(Holder::tags).map(s -> s.collect(Collectors.toList())).orElse(Collections.emptyList());
        return list.isEmpty() ? ObjectLists.emptyList() : ObjectLists.unmodifiable((ObjectList)new ObjectArrayList(list));
    }
}

