/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolderAccess;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.ItemStackHolder;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.AmountChangedEntry;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackData
extends AbstractData<ItemStack>
implements IContainerData {
    private ItemStack _lastValue;
    private IBindableData<Integer> _amountData;

    public static ItemStackData immutable(ModContainer container, ItemStack value) {
        return ItemStackData.of(container, () -> value, CodeHelper.emptyConsumer());
    }

    public static ItemStackData empty(ModContainer container) {
        return ItemStackData.immutable(container, ItemStack.EMPTY);
    }

    public static ItemStackData sampled(int frequency, ModContainer container, Supplier<@NotNull ItemStack> getter, Consumer<@NotNull ItemStack> clientSideSetter) {
        return ItemStackData.of(container, new Sampler<ItemStack>(frequency, getter), clientSideSetter);
    }

    public static ItemStackData sampled(int frequency, ModContainer container, Supplier<@NotNull ItemStack> getter) {
        return ItemStackData.of(container, new Sampler<ItemStack>(frequency, getter), CodeHelper.emptyConsumer());
    }

    public static ItemStackData of(ModContainer container, Supplier<@NotNull ItemStack> getter, Consumer<@NotNull ItemStack> clientSideSetter) {
        Preconditions.checkNotNull((Object)((Object)container), (Object)"Container must not be null.");
        ItemStackData data = container.isClientSide() ? new ItemStackData(getter, clientSideSetter) : new ItemStackData(getter);
        container.addBindableData(data);
        return data;
    }

    public static ItemStackData of(ModContainer container, NonNullList<ItemStack> list, int index) {
        Preconditions.checkNotNull(list, (Object)"List must not be null.");
        Preconditions.checkArgument((index >= 0 && index < list.size() ? 1 : 0) != 0, (Object)"Index must be a valid index for the list.");
        return ItemStackData.of(container, () -> (ItemStack)list.get(index), v -> list.set(index, v));
    }

    public static ItemStackData of(ModContainer container, IItemHandlerModifiable handler, int slot) {
        Preconditions.checkNotNull((Object)handler, (Object)"Handler must not be null.");
        Preconditions.checkArgument((slot >= 0 && slot < handler.getSlots() ? 1 : 0) != 0, (Object)"Slot must be a valid slot index for the handler.");
        return ItemStackData.of(container, () -> handler.getStackInSlot(slot), v -> handler.setStackInSlot(slot, v));
    }

    public static ItemStackData of(ModContainer container, boolean isClientSide, IStackHolderAccess<ItemStackHolder, ItemStack> holder, int index) {
        Preconditions.checkNotNull(holder, (Object)"Holder must not be null.");
        return ItemStackData.of(container, () -> (ItemStack)holder.getStackAt(index), v -> holder.setStackAt(index, (ItemStack)v));
    }

    public static ItemStackData of(ModContainer container, Supplier<@NotNull ItemStack> getter) {
        return ItemStackData.of(container, getter, CodeHelper.emptyConsumer());
    }

    public IBindableData<Integer> amount() {
        if (null == this._amountData) {
            this._amountData = AbstractData.as(0, intConsumer -> this.bind(stack -> intConsumer.accept(stack.getCount())));
        }
        return this._amountData;
    }

    @Override
    @Nullable
    public ISyncedSetEntry getChangedValue() {
        ItemStack current = (ItemStack)this.getValue();
        if (this._lastValue.isEmpty() && current.isEmpty()) {
            return null;
        }
        boolean equalItem = ItemHelper.stackMatch(this._lastValue, current, ItemHelper.MatchOption.MATCH_EXISTING_STACK);
        if (!equalItem || current.getCount() != this._lastValue.getCount()) {
            this._lastValue = current.copy();
            if (equalItem) {
                return new AmountChangedEntry(this._lastValue.getCount());
            }
            return new ItemStackEntry(this._lastValue);
        }
        return null;
    }

    @Override
    public ISyncedSetEntry getValueFrom(RegistryFriendlyByteBuf buffer) {
        return AmountChangedEntry.from(buffer, ItemStackEntry::from);
    }

    @Override
    public void updateFrom(ISyncedSetEntry entry) {
        if (entry instanceof ItemStackEntry) {
            ItemStackEntry record = (ItemStackEntry)entry;
            this.setClientSideValue(record.value);
            this.notify(record.value);
        } else if (entry instanceof AmountChangedEntry) {
            AmountChangedEntry record = (AmountChangedEntry)entry;
            this.setClientSideValue(((ItemStack)this.getValue()).copyWithCount(record.amount()));
        }
    }

    @Override
    @Nullable
    public ItemStack defaultValue() {
        return ItemStack.EMPTY;
    }

    private ItemStackData(Supplier<ItemStack> getter, Consumer<ItemStack> clientSideSetter) {
        super(getter, clientSideSetter);
    }

    private ItemStackData(Supplier<ItemStack> getter) {
        super(getter);
        this._lastValue = ItemStack.EMPTY;
    }

    private record ItemStackEntry(ItemStack value) implements ISyncedSetEntry
    {
        private static ItemStackEntry from(RegistryFriendlyByteBuf buffer) {
            return new ItemStackEntry((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer));
        }

        @Override
        public void accept(@NotNull RegistryFriendlyByteBuf buffer) {
            buffer.writeByte(1);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.value);
        }
    }
}

