/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatData
extends AbstractData<Float>
implements IContainerData {
    private float _lastValue;

    public static FloatData immutable(ModContainer container, float value) {
        return FloatData.of(container, () -> Float.valueOf(value), CodeHelper.emptyConsumer());
    }

    public static FloatData sampled(int frequency, ModContainer container, Supplier<@NotNull Float> getter, Consumer<@NotNull Float> clientSideSetter) {
        return FloatData.of(container, new Sampler<Float>(frequency, getter), clientSideSetter);
    }

    public static FloatData sampled(int frequency, ModContainer container, Supplier<@NotNull Float> getter) {
        return FloatData.of(container, new Sampler<Float>(frequency, getter), CodeHelper.emptyConsumer());
    }

    public static FloatData of(ModContainer container, Supplier<@NotNull Float> getter, Consumer<@NotNull Float> clientSideSetter) {
        Preconditions.checkNotNull((Object)((Object)container), (Object)"Container must not be null.");
        FloatData data = container.isClientSide() ? new FloatData(getter, clientSideSetter) : new FloatData(getter);
        container.addBindableData(data);
        return data;
    }

    public static FloatData of(ModContainer container, float[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        return FloatData.of(container, () -> Float.valueOf(array[index]), v -> {
            array[index] = v.floatValue();
        });
    }

    public static FloatData of(ModContainer container, Supplier<@NotNull Float> getter) {
        return FloatData.of(container, getter, CodeHelper.emptyConsumer());
    }

    @Override
    @Nullable
    public ISyncedSetEntry getChangedValue() {
        float current = ((Float)this.getValue()).floatValue();
        if (this._lastValue != current) {
            this._lastValue = current;
            return new FloatEntry(current);
        }
        return null;
    }

    @Override
    public ISyncedSetEntry getValueFrom(RegistryFriendlyByteBuf buffer) {
        return FloatEntry.from(buffer);
    }

    @Override
    public void updateFrom(ISyncedSetEntry entry) {
        if (entry instanceof FloatEntry) {
            FloatEntry record = (FloatEntry)entry;
            this.setClientSideValue(Float.valueOf(record.value));
            this.notify(Float.valueOf(record.value));
        }
    }

    @Override
    @Nullable
    public Float defaultValue() {
        return Float.valueOf(0.0f);
    }

    private FloatData(Supplier<Float> getter, Consumer<Float> clientSideSetter) {
        super(getter, clientSideSetter);
    }

    private FloatData(Supplier<Float> getter) {
        super(getter);
        this._lastValue = 0.0f;
    }

    private record FloatEntry(float value) implements ISyncedSetEntry
    {
        private static FloatEntry from(RegistryFriendlyByteBuf buffer) {
            return new FloatEntry(buffer.readFloat());
        }

        @Override
        public void accept(@NotNull RegistryFriendlyByteBuf buffer) {
            buffer.writeFloat(this.value);
        }
    }
}

