/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.recipe;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.AbstractModRecipeBuilder;
import it.zerono.mods.zerocore.lib.recipe.AbstractOneToOneRecipe;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class OneToOneRecipeBuilder<Ingredient, Result, RecipeIngredient extends IRecipeIngredient<Ingredient>, RecipeResult extends IRecipeResult<Result>, Recipe extends AbstractOneToOneRecipe<Ingredient, Result, RecipeIngredient, RecipeResult>>
extends AbstractModRecipeBuilder<Recipe, Result, RecipeResult, OneToOneRecipeBuilder<Ingredient, Result, RecipeIngredient, RecipeResult, Recipe>> {
    private final Supplier<@NotNull Recipe> _recipeFactory;

    public OneToOneRecipeBuilder(RecipeIngredient ingredient, RecipeResult result, BiFunction<RecipeIngredient, RecipeResult, Recipe> recipeFactory) {
        super(result);
        Preconditions.checkArgument((!ingredient.isEmpty() ? 1 : 0) != 0, (Object)"Ingredient cannot be empty");
        Preconditions.checkArgument((!result.isEmpty() ? 1 : 0) != 0, (Object)"Result cannot be empty");
        Preconditions.checkNotNull(recipeFactory, (Object)"Recipe factory cannot be empty");
        this._recipeFactory = () -> Objects.requireNonNull((AbstractOneToOneRecipe)recipeFactory.apply(ingredient, result));
    }

    @Override
    protected Recipe getRecipe() {
        return (Recipe)((AbstractOneToOneRecipe)this._recipeFactory.get());
    }
}

